#%define ssl_libs openssl
%define ssl_libs gnutls

Name: msmtp
Version: 1.4.27
Release: alt1

Summary: Mail delivering agent (MDA) that uses customizable SMTP-server
License: GPLv3+
Group: Networking/Mail

Url: http://msmtp.sourceforge.net/
Source: http://download.sourceforge.net/sourceforge/msmtp/msmtp-%version.tar.bz2

# Automatically added by buildreq on Wed May 04 2011
# optimized out: glib2-devel libgnome-keyring libgpg-error pkg-config
# for gnutls libs:
BuildRequires: libgnome-keyring-devel libgnutls-devel libgsasl-devel libidn-devel

# for openssl ssl libs:
#BuildRequires: libgnome-keyring-devel libgsasl-devel libidn-devel libssl-devel

%description
msmtp is an SMTP client: it transmits a mail to an SMTP server
(for example, at a free mail provider) which does the delivery.
To use this program with your mail user agent (MUA),
create a configuration file with your mail account(s)
and tell your MUA to call msmtp instead of /usr/sbin/sendmail.

Features include:
- Sendmail compatible interface (command line options and exit codes)
- Many authentication methods: PLAIN, LOGIN, CRAM-MD5, EXTERNAL.
  With GNU SASL, GSSAPI, DIGEST-MD5 and NTLM are also allowed.
- TLS/SSL encrypted connections (including server certificate verification
  and optional sending of client certificate) in separate %name-ssl package
- DSN (Delivery Status Notification) support
- RMQS (Remote Message Queue Starting) support (ETRN keyword)
- PIPELINING support for increased transmission speed
- IPv6 support
- LMTP support
- support for multiple accounts

%prep
%setup

%build
%configure --with-ssl=%ssl_libs --with-gnome-keyring
%make_build

%install
%makeinstall_std

%find_lang msmtp

%files -f msmtp.lang
%_bindir/msmtp
%_man1dir/*
%_infodir/msmtp.*
%doc NEWS README doc/Mutt+msmtp.txt doc/msmtprc-*.example

%changelog
