Name: mtr
Version: 0.82
Release: alt2

Summary: Matt's Traceroute - network diagnostic tool
License: GPL
Group: Monitoring
Url: http://www.bitwizard.nl/mtr/
Packager: Michael Shigorin <mike@altlinux.org>

Source: ftp://ftp.bitwizard.nl/mtr/mtr-%version.tar.gz
Source1: gtk1.m4
Source2: mtr.8ru
Source3: mtr.desktop
Source4: mtr.xpm
Source5: mtr.control
Patch1: mtr-0.80-alt-droppriv.patch
Patch2: mtr-0.80-alt-bound.patch
Patch3: mtr-0.72-rh-underflow.patch
Patch4: mtr-0.80-fc-crash-in-xml-mode.patch
Patch5: mtr-0.80-fc-now-waits-for-last-response.patch
Patch6: mtr-0.80-fc-xml-format-fixes.patch

Requires: shadow-utils
Requires: /var/resolv

BuildRequires: libgtk+2-devel libncurses-devel

Summary(ru_RU.KOI8-R): Matt's Traceroute -    
Summary(uk_UA.KOI8-U): Matt's Traceroute - ̦  Ħ ֦

%define _sbindir %_bindir

%package -n xmtr
Summary: Ping/Traceroute network diagnostic tool - GTK Interface
Summary(ru_RU.KOI8-R): Ping/Traceroute -     - GTK 
Summary(uk_UA.KOI8-U): Ping/Traceroute - ̦  Ħ ֦ - GTK 
Group: Monitoring
Provides: %name-gtk = %version-%release
Obsoletes: %name-gtk
Requires: %name = %version-%release

%description
mtr combines the functionaly of the traceroute and ping programs in
a single network diagnostic tool.  As mtr starts, it investigates the
network connection between the host mtr runs on and the destination.
After it determines the address of each network hop between the machines,
it sends a sequence ICMP ECHO requests to each one to determine the
quality of the link to each machine.  As it does this, it prints running
statistics about each machine.

%description -l ru_RU.KOI8-R
mtr -  traceroute  ping   .    
    ,    ,
 ,  .   ,   
      ,  
 ICMP ECHO       
     .    ,    ,
     .

%description -l uk_UA.KOI8-U
mtr -  traceroute  ping   Φ.    mtr
̦դ  ' ͦ ,  ˦ צ  
 .       ͦ 
 , mtr  ̦Φ ICMP ECHO Ԧ  
 Ц   Ԧ ̦  ϧ  .   Ħ 
 mtr     Φ Φ.

%description -n xmtr
mtr is a network diagnostic tool which combines Ping and Traceroute
into one program.

This is the GTK interface for mtr.

%description -l ru_RU.KOI8-R -n xmtr
mtr -    ,  ping  traceroute
  "".

   GTK-  mtr.

%description -l uk_UA.KOI8-U -n xmtr
mtr - ̦  Ħ ֦,  Ϥդ ping  traceroute
  "Φ".

 GTK-  mtr.

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
install -pm644 %_sourcedir/gtk1.m4 acinclude.m4
touch ChangeLog

%build
%autoreconf
%define _configure_script ../configure

mkdir -p build-xmtr
	pushd build-xmtr
	%configure --with-gtk --enable-gtk2 --enable-ipv6
	%make_build
popd

mkdir -p build-mtr
	pushd build-mtr
	%configure --without-gtk --enable-ipv6
	%make_build
popd

%install
%makeinstall -C build-mtr

install -pD -m700 build-mtr/mtr %buildroot%_bindir/mtr
install -pD -m700 build-xmtr/mtr %buildroot%_bindir/xmtr
ln -s mtr %buildroot%_bindir/mtr6
ln -s xmtr %buildroot%_bindir/mtr-gtk

install -pD -m644 %_sourcedir/mtr.desktop %buildroot%_desktopdir/mtr.desktop
install -pD -m644 %_sourcedir/mtr.xpm %buildroot%_niconsdir/mtr.xpm
for n in mtr xmtr; do
	install -pD -m755 %_sourcedir/mtr.control "%buildroot%_controldir/$n"
	subst -p "s/@NAME@/$n/" "%buildroot%_controldir/$n"
done

%pre
/usr/sbin/groupadd -r -f netadmin
/usr/sbin/groupadd -r -f mtruser
/usr/sbin/useradd -r -g mtruser -d /dev/null -s /dev/null -n mtruser >/dev/null 2>&1 ||:
%pre_control mtr

%post
%post_control -s netadmin mtr

%pre -n xmtr
%pre_control xmtr

%post -n xmtr
%post_control -s netadmin xmtr

%files
%_bindir/mtr
%_bindir/mtr6
%_man8dir/*
%config %_controldir/mtr
#attr(0644,root,man) %_mandir/ru_RU.KOI8-R/man8/*
%doc AUTHORS FORMATS NEWS README SECURITY TODO

%files -n xmtr
%_bindir/xmtr
%_bindir/mtr-gtk
%_desktopdir/*.desktop
%_niconsdir/*.xpm
%config %_controldir/xmtr

# TODO:
# - update russian manpage and get it back into the package?
# - change "mtruser" group to e.g. "_mtr"?
# FIXME:
# - netadmin group would get non-predictable gid if not pre-existed

%changelog
