%define _sbindir /sbin
%define _libdir /%_lib
%define _libmpathdir %_libdir/multipath

Name: multipath-tools
Version: 0.4.9
Release: alt4

Summary: Tools to manage multipath devices with device-mapper
License: GPLv2+
Group: System/Configuration/Hardware

Url: http://christophe.varoqui.free.fr
Source: %name-%version.tar
# http://git.opensvc.com/multipath-tools/.git
Packager: Konstantin Pavlov <thresh@altlinux.org>

Requires: libmultipath = %version-%release
Requires: kpartx = %version-%release
Requires: dmsetup

BuildRequires: libaio-devel libdevmapper-devel libreadline-devel libudev-devel

%description
This package provides the tools to manage multipath devices by
instructing the device-mapper multipath module what to do.
The tools are:
- multipath: lists and configures multipath devices.
- multipathd: monitors paths; as paths fail and come back, it may
  initiate path group switches.

%package -n libmultipath
Summary: The %name modules and shared library
License: GPL+
Group: System/Libraries

%description -n libmultipath
The libmultipath provides the path checker
and prioritizer modules. It also contains the multipath shared library,
libmultipath.

%package -n kpartx
Summary: Partition device manager for device-mapper devices
Group: System/Configuration/Hardware

%description -n kpartx
kpartx manages partition creation and removal for device-mapper devices.

%prep
%setup

%build
# non-SMP build
make LIB=%_lib

%install
mkdir -p %buildroot{%_sbindir,%_libdir,%_man8dir,%_initdir,%_unitdir}
make install \
	DESTDIR=%buildroot \
	bindir=%_sbindir \
	syslibdir=%_libdir \
	libdir=%_libmpathdir \
	rcdir=%_initrddir \
	unitdir=%_unitdir

install -pm755 multipathd/multipathd.init.alt %buildroot%_initdir/multipathd
cp multipath.conf.annotated %buildroot%_sysconfdir/multipath.conf

%post
%post_service multipathd

%preun
%preun_service multipathd

%files
%doc AUTHOR README FAQ TODO ChangeLog multipath.conf.annotated multipath.conf.synthetic
%_sbindir/multipath
%_sbindir/multipathd
%_sbindir/mpathconf
%_sbindir/mpathpersist
/lib/udev/rules.d/62-multipath.rules
%config(noreplace) %attr(644,root,root) %_sysconfdir/multipath.conf
%_initdir/multipathd
%_unitdir/multipathd.service
%_man5dir/*
%_man8dir/*
%exclude %_man8dir/kpartx.8.*

%files -n libmultipath
%_libdir/libmultipath.so.*
%_libdir/libmpathpersist.so.*
%dir %_libdir/multipath
%_libdir/multipath/*

%files -n kpartx
/sbin/kpartx
/lib/udev/kpartx_id
%_man8dir/kpartx.8.*

%changelog
