%define rname mscore

Name: musescore
Version: 1.3
Release: alt1

Summary: A free WYSIWYG music score typesetter

License: GPL2
Group: Sound
Url: http://mscore.sourceforge.net/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://prdownloads.sf.net/%rname/%rname-%version.tar.bz2
Source1: mscore.desktop
Patch1: mscore-dso-linking.patch

BuildPreReq: chrpath

# Automatically added by buildreq on Thu Jan 06 2011
BuildRequires: ccmake doxygen gcc-c++ ghostscript-utils graphviz latex2html libalsa-devel libjack-devel libportaudio2-devel libsndfile-devel qt4-designer

# needed for qt.core and so on in JavaScript plugins
Requires: qtscriptbindings

%description
MuseScore is a graphical music typesetter. It allows for fast
and easy note entry on a virtual note sheet. It has an
integrated sequencer to allow for immediate play of the score.
MuseScore can import and export MusicXml and standard Midi files.

Run
"modprobe snd-seq" as root
if you get ALSA lib seq_hw.c:457:(snd_seq_hw_open) open /dev/snd/seq failed: No such file or directory

%prep
%setup -n %rname-%version
sed -i "s| -m32||g" mscore/CMakeLists.txt
%patch1 -p1 -b .dso
sed -i 's@":/fonts@"%_datadir/mscore-%version/fonts@g' mscore/mscore/mscore.cpp

%build
export PATH=$PATH:%_qt4dir/bin
mkdir build && cd build
cmake \
	-DCMAKE_BUILD_TYPE=RELEASE \
	-DCMAKE_INSTALL_PREFIX=%_prefix \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
        -DBUILD_SCRIPTGEN=FALSE \
	../mscore
# compile translations
make lupdate
make lrelease
# run build
%make_build
make doxy
cp %SOURCE1 .

%install
cd build
%makeinstall_std
for f in ../mscore/mscore/fonts/*.ttf; do
	install -D $f %buildroot%_datadir/mscore-%version/fonts/$(basename $f)
done

chrpath -d %buildroot%_bindir/mscore

%files
%_bindir/mscore
%_desktopdir/mscore.desktop
%_datadir/mscore-%version
%_qt4dir/plugins/designer/libawlplugin.so
%_pixmapsdir/mscore.*

%changelog
