%def_enable shared
%def_enable static
%def_enable gcc_wrapper
%define libc_dir /%_lib

%{!?x86_64:%define x86_64 x86_64}
%define subst_enable_to() %{expand:%%{?_enable_%{1}:--enable-%{2}}} %{expand:%%{?_disable_%{1}:--disable-%{2}}}

Name: musl
Version: 0.9.10
Release: alt4
Group: System/Libraries
Summary: musl libc - new standard library
License: MIT
Url: http://www.etalabs.net/%name
Source: %url/releases/%name-%version.tar
Patch: %name-%version-%release.patch
ExclusiveOS: Linux
%define musl_dir %_libdir/%name
%define soname libc-%name.so.1
%define libname libc-%name-%version.so

%{!?libc_dir:%define libc_dir %musl_dir/lib}

%description
%name libc is a new standard library to power a new generation of Linux-based
devices. %name is lightweight, fast, simple, free, and strives to be correct in
the sense of standards-conformance and safety.
%name is an alternative to glibc, eglibc, uClibc, dietlibc, and klibc.


%package devel
Summary: Development files for %name
Group: Development/C
AutoReq: yes, nosymlinks, nocpp
Requires: %name = %version-%release
Requires: kernel-headers-common
Provides: %name-gcc = %version-%release

%description devel
Development files and headers for %name.


%prep
%setup -q
%patch -p1
sed -i '/--hash-style=both/d' configure
sed -i 's/\(-soname=\)libc\.so/\1%soname/' Makefile
sed -i 's/libc\.so/%libname/' Makefile
%if "%_lib" != "lib"
sed -i 's|"/lib\(:/usr/local/lib:\)/usr/lib"|"/%_lib\1%_libdir"|' src/ldso/dynlink.c
%endif


%build
%define _optlevel s
%add_optflags -U_FORTIFY_SOURCE
./configure \
	CFLAGS="%optflags" \
	--prefix=%musl_dir \
	--exec-prefix=%prefix \
	--syslibdir=/%_lib \
	%{subst_enable shared} \
	%{subst_enable static} \
	%{subst_enable_to gcc_wrapper gcc-wrapper} \
	--enable-warnings
%make_build


%install
%makeinstall_std
rm -rf %buildroot%musl_dir/include/linux
for d in linux asm asm-generic; do
	ln -sf %_includedir/$d %buildroot%musl_dir/include/
done

install -d -m 0755 %buildroot%_docdir/%name-%version
install -m 0644 README WHATSNEW %buildroot%_docdir/%name-%version/

%if "%libc_dir" != "%musl_dir/lib"
mv %buildroot%musl_dir/lib/%libname %buildroot/%_lib/
ln -sf /%_lib/%soname %buildroot%musl_dir/lib/libc.so
%if "%libc_dir" == "/%_lib"
ln -sf %libname %buildroot/%_lib/ld-*
%else
ln -sf %libc_dir/%libname %buildroot/%_lib/ld-*
%endif
%endif

install -d -m 0755 %buildroot%_sysconfdir/ld.so.conf.d
echo "%musl_dir/lib" > %buildroot%_sysconfdir/ld.so.conf.d/%name-%_lib.conf


%files
%if "%libc_dir" != "%musl_dir/lib"
%dir %musl_dir
%dir %musl_dir/lib
%endif
%if "%libc_dir" != "/%_lib"
%libc_dir/*.so
%endif
/%_lib/*
%config %_sysconfdir/ld.so.conf.d/*


%files devel
%doc %_docdir/%name-%version
%_bindir/*
%musl_dir/include
%musl_dir/lib/*
%if "%libc_dir" == "%musl_dir/lib"
%exclude %musl_dir/lib/*.so
%endif


%changelog
