Name: mutt
Version: 1.4.2.3
Release: alt7
Epoch: 3

%def_without dotlock
%define docdir %_docdir/mutt-%version

Summary: A text mode mail and news user agent
License: GPLv2+
Group: Networking/Mail
Url: http://www.mutt.org/

# ftp://ftp.mutt.org/pub/mutt/mutt-%version.tar.gz
Source: mutt-%version.tar
Source1: http://jblosser.firinn.org/pub/config/mutt/mutt-16.xpm
Source2: http://jblosser.firinn.org/pub/config/mutt/mutt-32.xpm
Source3: http://www.math.fu-berlin.de/~guckes/mutt/mutt-48.xpm
Source4: mutt.desktop
Source5: http://www.fefe.de/muttfaq/faq.html
Source6: mutt-FAQ.ru.html
Source7: http://solidlinux.com/~justin/mutt/mutt-gnupg-howto.txt
# http://mutt.sourceforge.net/imap/
Source8: Mutt-and-IMAP.html
Source10: patchlist.sh

%define vvv_version 1.4.2.2
Patch11: http://mutt.kiev.ua/download/mutt-%vvv_version/mutt-%vvv_version-vvv-compressed.patch
Patch12: http://mutt.kiev.ua/download/mutt-%vvv_version/mutt-%vvv_version-vvv-initials.patch
Patch13: http://mutt.kiev.ua/download/mutt-%vvv_version/mutt-%vvv_version-vvv-nntp.patch
Patch14: http://mutt.kiev.ua/download/mutt-%vvv_version/mutt-%vvv_version-vvv-quote.patch

Patch16: mutt-1.4-headercache.patch 

Patch21: mutt-1.3.22.1-alt-no_dotlock.patch
Patch22: mutt-1.2.5-alt-8bitpgp.patch
Patch23: mutt-1.3.28-alt-flea.patch
Patch24: mutt-1.3.22.1-alt-altyesorno.patch
Patch25: mutt-1.3.22.1-alt-send_charset-koi8-r.patch
Patch26: mutt-1.3.22.1-alt-muttrc-show-docs.patch
Patch27: mutt-1.3.22.1-alt-compressed-hooks.patch
Patch28: mutt-1.4-alt-m4-fixes.patch
Patch29: mutt-1.4-owl-muttbug-tmp.patch
Patch30: mutt-1.4.2.1-owl-tmp.patch
Patch31: mutt-1.4-alt-tmp.patch
Patch32: mutt-1.4-alt-fixes.patch
Patch33: mutt-1.4-alt-gpg.patch
Patch34: mutt-1.4.2.1-alt-stat_check.patch
Patch35: mutt-1.4.2.1-owl-man.patch
Patch36: mutt-1.4.2.1-owl-bound.patch
Patch37: mutt-1.4.2.2i-alt-fixes.patch
Patch38: mutt-1.4.2.3-alt-bound.patch
Patch39: mutt-1.4.2.3-alt-automake.patch

Requires: MTA, urlview, mailcap

BuildPreReq: OpenSP groff-base libncursesw-devel libssl-devel sgml-tools sgml-common

%description
Mutt is a feature-rich text-based mail user agent.  Mutt supports local
and remote mail spools (POP3 and IMAP, including with SSL), MIME, OpenPGP
(PGP/MIME) with GnuPG and PGP, colored display, threading, and a lot of
customization including arbitrary message headers, key remapping, colors,
and more.

%prep
%setup
install -pm755 %SOURCE10 .

%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1

%patch16 -p1

%patch21 -p1
#%patch22 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p1
%patch26 -p1
%patch27 -p1
%patch28 -p1
%patch29 -p1
%patch30 -p1
%patch31 -p1
%patch32 -p1
%patch33 -p1
%patch34 -p1
%patch35 -p1
%patch36 -p1
%patch37 -p1
%patch38 -p1
%patch39 -p1

find -type f -name \*.orig -delete

%build
export ac_cv_path_GDB=/usr/bin/gdb
export ac_cv_path_ISPELL=/usr/bin/ispell
export ac_cv_path_SENDMAIL=/usr/sbin/sendmail
%if_without dotlock
export mutt_cv_worldwrite=no
export mutt_cv_groupwrite=no
%endif

# Correct manual name (#2710).
%__subst -p 's,/manual\.txt\\n,/manual.txt.bz2\\n,g' Muttrc.head.in

%{expand:%%add_optflags %(getconf LFS_CFLAGS) -D_GNU_SOURCE -fno-strict-aliasing}
make -C m4 -f Makefile.am.in
autoreconf -fisv -I m4
%configure \
	--with-sharedir=%_sysconfdir \
	--with-docdir=%docdir \
	--enable-pop \
	--enable-imap \
	--enable-nntp \
	--disable-warnings \
	--with-ncurses \
	--disable-domain \
	--enable-nfs-fix \
	--with-charmaps \
	--with-ssl \
	--enable-compressed

make clean
make -C doc clean-real
%make_build

%install
%makeinstall sharedir=%buildroot%_sysconfdir docdir=%buildroot%docdir

# Icons.
install -pD -m644 %SOURCE1 %buildroot%_miconsdir/mutt.xpm
install -pD -m644 %SOURCE2 %buildroot%_niconsdir/mutt.xpm
install -pD -m644 %SOURCE3 %buildroot%_liconsdir/mutt.xpm
install -pD -m644 %SOURCE4 %buildroot%_desktopdir/%name.desktop

# More docs.
install -p -m644 %SOURCE5 %SOURCE6 %SOURCE7 %SOURCE8 *.nntp \
	%buildroot%docdir/
find %buildroot%docdir/ \( -name \*.txt -or -iname changelog\* \) -size +8k -print0 |
	xargs -r0 bzip2 -9 --

# Fix configs.
find %buildroot%_sysconfdir -type f -print0 |
	xargs -r0 grep -FZl '%buildroot' |
	xargs -r0 %__subst -p 's|%buildroot||g' --

rm %buildroot%_sysconfdir/mime.types

%find_lang mutt

%files -f mutt.lang
%if_with dotlock
%attr(2711,root,mail) %_bindir/mutt_dotlock
%else
%exclude %_mandir/man?/*dotlock*
%endif
%config(noreplace) %_sysconfdir/Muttrc
%_bindir/flea
%_bindir/mutt
%_bindir/muttbug
%_bindir/pgp*
%_mandir/man?/*
%_desktopdir/%name.desktop
%_miconsdir/*.xpm
%_niconsdir/*.xpm
%_liconsdir/*.xpm
%docdir

%changelog
