# vim: set ft=spec: -*- rpm-spec -*-

%def_disable debug
#def_enable Werror

%define oname mutt
%define branch 1.5
Name: %oname%branch
Version: 1.5.21
Release: alt2.qa1
Serial: 3

%def_without dotlock
%define docdir %_docdir/%name-%version

Summary: A text mode mail and news user agent
Group: Networking/Mail
License: GPL
Url: http://www.mutt.org/

Packager: Sir Raorn <raorn@altlinux.ru>

Source: ftp://ftp.%oname.org/%oname/devel/%oname-%version.tar
Patch: %oname-%version-%release.patch

# http://jblosser.firinn.org/pub/config/mutt/ (DEAD)
Source1: %oname-16.xpm
# http://jblosser.firinn.org/pub/config/mutt/ (DEAD)
Source2: %oname-32.xpm
# http://www.math.fu-berlin.de/~guckes/mutt/ (DEAD)
Source3: %oname-48.xpm
Source4: %name.desktop
Source5: http://www.fefe.de/%{oname}faq/faq.html
Source6: mutt-FAQ.ru.html
# http://solidlinux.com/~justin/mutt/ (DEAD)
Source7: %oname-gnupg-howto.txt
# http://mutt.sourceforge.net/imap/
Source8: Mutt-and-IMAP.html

Requires: urlview

Conflicts: %oname

# Automatically added by buildreq on Mon Jun 02 2008
BuildRequires: OpenSP docbook-dtds docbook-style-xsl libgdbm-devel libgpgme-devel libidn-devel libncursesw-devel libsasl2-devel libssl-devel lynx mailcap xsltproc zlib-devel

%description
Mutt is a feature-rich text-based mail user agent.  Mutt supports local
and remote mail spools (POP3 and IMAP, including with SSL), MIME, OpenPGP
(PGP/MIME) with GnuPG and PGP, colored display, threading, and a lot of
customization including arbitrary message headers, key remapping, colors,
and more.

%prep
%setup -q -n %oname-%version
%patch -p1

%build
export ac_cv_path_GDB=/usr/bin/gdb
export ac_cv_path_ISPELL=/usr/bin/ispell
export ac_cv_path_SENDMAIL=/usr/sbin/sendmail
%if_without dotlock
export mutt_cv_worldwrite=no
export mutt_cv_groupwrite=no
%endif

%add_optflags -std=c99
%autoreconf -I m4
%configure \
	--with-docdir=%docdir \
	--enable-gpgme \
	--enable-pop \
	--enable-imap \
	--enable-smtp \
	--enable-nntp \
	%{subst_enable debug} \
	--enable-nfs-fix \
	--enable-compressed \
	--enable-hcache \
	--with-curses \
	--with-gss \
	--with-ssl \
	--with-sasl \
	--with-idn \
	#

%make clean
%make_build

%install
%make_install DESTDIR=%buildroot install

# Icons.
install -pD -m644 %_sourcedir/%oname-16.xpm %buildroot%_miconsdir/%oname.xpm
install -pD -m644 %_sourcedir/%oname-32.xpm %buildroot%_niconsdir/%oname.xpm
install -pD -m644 %_sourcedir/%oname-48.xpm %buildroot%_liconsdir/%oname.xpm

# Menu.
install -pD -m644 %_sourcedir/%name.desktop %buildroot%_desktopdir/%name.desktop

# More docs.
install -p -m644 %_sourcedir/{faq.html,mutt-FAQ.ru.html,%oname-gnupg-howto.txt,Mutt-and-IMAP.html} *.nntp \
	%buildroot%docdir/
find %buildroot%docdir/ \( -name \*.txt -o -name ChangeLog\* \) -size +8k -print0 |
	xargs -r0 bzip2 -9 --

# HACK
[ -f %buildroot%docdir/manual.txt.bz2 ] || exit 1

# Fix configs.
find %buildroot%_sysconfdir -type f -print0 |
	xargs -r0 grep -FZl "%buildroot" |
	xargs -r0 sed -i "s|%buildroot||g" --

# Don't package flea, use ALT bugzilla
cat <<EOF > %buildroot%_bindir/flea
#!/bin/sh

exec >&2
cat <<EOS
\${0##*/}: Don't panic!

You are using heavily patched unstable version of Mutt mail client.
Mutt authors are not responsible for anything, that could be broken
in this build, so don't bother them.  Instead, visit ALT Linux
Bugzilla on https://bugzilla.altlinux.org/ and fill a bug report
against %name package.

You are using %name-%version-%release RPM package.

So Long, and Thanks for All the Fish.
EOS
exit 1
EOF

%find_lang %oname

%files -f %oname.lang
%if_with dotlock
%attr(2711,root,mail) %_bindir/mutt_dotlock
%endif
%config(noreplace) %_sysconfdir/Muttrc
%_bindir/flea
%_bindir/mutt
%_bindir/muttbug
%_bindir/pgp*
%_bindir/smime_keys
%_mandir/man?/*
%_desktopdir/%name.desktop
%_miconsdir/*.xpm
%_niconsdir/*.xpm
%_liconsdir/*.xpm
%docdir

%changelog
