%define ver_major 3.8
%def_enable privatelib
%def_enable gtk_doc

Name: mutter
Version: %ver_major.4
Release: alt1
Epoch: 1

Summary: Clutter based compositing GTK3 Window Manager
Group: Graphical desktop/GNOME
License: GPLv2+
Url: http://ftp.gnome.org/pub/gnome/sources/%name
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Requires: lib%name = %epoch:%version-%release
Requires: zenity

#Source: %name-%version.tar
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

BuildPreReq: rpm-build-gnome gnome-common
BuildPreReq: intltool >= 0.34.90
BuildPreReq: gobject-introspection-devel >= 0.9.5
BuildRequires: libgtk+3-devel >= 3.3.7
BuildRequires: glib2-devel  libgio-devel >= 2.25.10
BuildRequires: libpango-devel >= 1.2.0
BuildRequires: libcairo-devel >= 1.10.0
BuildRequires: gsettings-desktop-schemas-devel >= 3.7.3
BuildRequires: libXcomposite-devel libXfixes-devel libXrender-devel libXdamage-devel libXi-devel >= 1.6.0
BuildRequires: libXcursor-devel libX11-devel libXinerama-devel libXext-devel libXrandr-devel libSM-devel libICE-devel
BuildRequires: libclutter-devel >= 1.14.3 libcogl-devel >= 1.13.3
BuildRequires: libgdk-pixbuf-devel
BuildRequires: gtk-doc
BuildRequires: libstartup-notification-devel zenity libcanberra-gtk3-devel
BuildRequires: libclutter-gir-devel libpango-gir-devel libgtk+3-gir-devel gsettings-desktop-schemas-gir-devel

%set_typelibdir %_libdir/%name
%set_girdir %_libdir/%name

%description
mutter is a minimal X window manager aimed at nontechnical users and is
designed  to  integrate well with the GNOME desktop.  mutter lacks some
features that may be expected by traditional UNIX  or  other  technical
users;  these users may want to investigate other available window man-
agers for use with GNOME or standalone.

%package -n lib%name
Summary: Shared library for Mutter
Group: System/Libraries

%description -n lib%name
This package contains shared library needed to run Mutter.

%package -n lib%name-devel
Summary: Development files for lib%name
Group: Development/C
Requires: lib%name = %epoch:%version-%release

%description -n lib%name-devel
This package contains headers and development libraries for lib%name

%package -n lib%name-gir
Summary: GObject introspection data for the Mutter library
Group: System/Libraries
Requires: lib%name = %epoch:%version-%release

%description -n lib%name-gir
GObject introspection data for the Mutter library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Mutter library
Group: System/Libraries
Requires: lib%name-devel = %epoch:%version-%release lib%name-gir = %epoch:%version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the Mutter library

%package gnome
Summary: GNOME-specific parts of Mutter
Group: Graphical desktop/GNOME
BuildArch: noarch
Provides: gnome-wm
Requires: %name = %epoch:%version-%release

%description gnome
This package contains everything necessary to use Mutter in GNOME desktop
environment.

%package devel-doc
Summary: Development docs package for mutter
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
Development docs package for mutter

%prep
%setup -q

%build
%autoreconf
DATADIRNAME=share %configure \
	--enable-introspection \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	--disable-static \
	--disable-schemas-compile

%make_build

%install
%make DESTDIR=%buildroot DATADIRNAME=share install

%find_lang --with-gnome %name creating-%name-themes

%files -f %name.lang
%doc README AUTHORS NEWS
%_bindir/*
%dir %_libdir/%name
%dir %_libdir/%name/plugins
%_libdir/%name/plugins/*.so
%_datadir/%name
%_desktopdir/%name.desktop
%_man1dir/*

%if_enabled privatelib
%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%doc doc/*.txt HACKING
%_includedir/%name
%_libdir/*.so
%_pkgconfigdir/*.pc
%endif

%files -n lib%name-gir
%_libdir/%name/*.typelib

%files -n lib%name-gir-devel
%_libdir/%name/*.gir

%files gnome
%_datadir/glib-2.0/schemas/org.gnome.mutter.gschema.xml
%_datadir/GConf/gsettings/mutter-schemas.convert
%_datadir/gnome-control-center/keybindings/*.xml
%_datadir/gnome/wm-properties/%name-wm.desktop

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif


%changelog
