Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>
%def_enable shared
%def_enable static
%def_enable threads
%def_disable debug

%define Name Mini-XML
Name: mxml
%define lname lib%name
Version: 2.7
Release: alt1
Summary: %Name documentation generator
Group: Text tools
License: %lgpl2plus with exceptions
Url: http://www.minixml.org/
Source: %name-%version.tar
Provides: %{name}doc = %version-%release
Obsoletes: %{name}doc < %version-%release
Requires: %lname = %version-%release

# Automatically added by buildreq on Sun Jul 27 2008
BuildRequires: gcc-c++
BuildRequires: rpm-build-licenses

%description
mxmldoc scans the specified C and C++ source files to produce an XML
representation of globally accessible classes, constants, enumerations,
functions, structures, typedefs, unions, and variables. The XML file is
updated as necessary and a HTML representation of the XML file is
written to the standard output. If no source files are specified then
the current XML file is converted to HTML on the standard output.


%if_enabled shared
%package -n %lname
Summary: %Name library
Group: System/Libraries

%description -n %lname
%Name is a small XML parsing library that you can use to read XML
and XML-like data files in your application without requiring large
non-standard libraries.
%endif


%package -n %lname-devel
Summary: %Name library header
Group: Development/C
Requires: %lname%{?_disable_shared:-devel-static} = %version-%release

%description -n %lname-devel
%Name is a small XML parsing library that you can use to read XML
and XML-like data files in your application without requiring large
non-standard libraries.
This package includes headers and other files necessary to build
applications that use %Name.


%if_enabled static
%package -n %lname-devel-static
Summary: %Name library
Group: Development/C
Requires: %lname-devel = %version-%release

%description -n %lname-devel-static
%Name is a small XML parsing library that you can use to read XML
and XML-like data files in your application without requiring large
non-standard libraries.
This package includes %Name static library.
%endif


%package doc
Summary: %Name documentation
Group: Documentation
BuildArch: noarch

%description doc
%Name is a small XML parsing library that you can use to read XML
and XML-like data files in your application without requiring large
non-standard libraries.
This package includes %Name documentation.


%prep
%setup


%build
%configure \
    %{subst_enable debug} \
    %{subst_enable shared} \
    %{subst_enable threads} \
    --with-docdir=%_docdir/%name-%version
%make_build


%install
%make_install BUILDROOT=%buildroot install


%files
%_bindir/*
%_man1dir/*


%if_enabled shared
%files -n %lname
%_libdir/*.so.*
%endif


%files -n %lname-devel
%_pkgconfigdir/*
%_includedir/*
%{?_enable_shared:%_libdir/*.so}
%_man3dir/*


%if_enabled static
%files -n %lname-devel-static
%_libdir/*.a
%endif


%files doc
%_docdir/%name-%version


%changelog
