Name: mysql-workbench-gpl
Version: 5.2.47
Release: alt1.M70P.2
Packager: Evgeny Sinelnikov <sin@altlinux.ru>

Summary: A MySQL visual database modeling tool

License: %gpllgpl2only
Group: Development/Databases
Url: http://wb.mysql.com
Source0: %name-%version.tar.gz

Patch1: mysql-workbench-gpl-5.2.33-alt-build.patch
Patch2: mysql-workbench-gpl-5.2.47-alt-ctemplate.patch

Provides: mysql-workbench-oss = %version-%release
Obsoletes: mysql-workbench-oss < %version-%release

Provides: mysql-administrator = %version-%release
Obsoletes: mysql-administrator < %version-%release

Provides: mysql-query-browser = %version-%release
Obsoletes: mysql-query-browser < %version-%release

# "_mforms" and "grt" are accessable from "MySQL Workbench GRT Shell" only.
%add_python_req_skip _mforms grt mforms

# internal Workbench's libraries
%add_python_req_skip db_utils wb workbench _cairo

# shell_snippets.py is not pure Python
%add_findreq_skiplist */mysql-workbench/shell_snippets.py

# templates only
%add_findreq_skiplist */mysql-workbench/script_templates/*

%add_findreq_skiplist */mysql-workbench/libraries/grt_python_debugger.py

Requires: python-module-paramiko python-module-pexpect
Requires: mysql-client gnome-keyring
Requires: %name-data = %version

BuildRequires(pre): rpm-build-licenses

# Automatically added by buildreq on Sun Mar 20 2011
# and edited manualy
# - removed mysql-workbench-gpl
# - boost-devel-headers changed to boost-devel
BuildRequires: boost-devel gcc-c++ libglade-devel libgnome-devel libgtkmm2-devel liblua5-devel libmysqlclient-devel libpcre-devel libsqlite3-devel libuuid-devel libxml2-devel libzip-devel python-devel

BuildRequires: boost-signals-devel

BuildRequires: libGL-devel
BuildRequires: libctemplate-devel
BuildRequires: libiodbc-devel

%description
MySQL Workbench is modeling tool that allows you to design
and generate MySQL databases graphically.

%package data
Summary: Architecture independent files for %name
License: %gpllgpl2only
Group: Development/Databases
BuildArch: noarch
Conflicts: %name < %version

%description data
Architecture independent files for %name

%prep

%setup -q

%patch1 -p1
#patch2 -p2

%set_verify_elf_method unresolved=relaxed

%build

NOCONFIGURE=yes ./autogen.sh

export LIBS="-lgthread-2.0"

%configure --disable-debug

%make_build

%install

%makeinstall_std

mkdir -p %buildroot%_niconsdir
cp images/icons/MySQLWorkbench-32.png %buildroot%_niconsdir/mysql-workbench.png

mkdir -p %buildroot%_iconsdir/hicolor/32x32/mimetypes
cp images/icons/MySQLPlugin-32.png %buildroot%_iconsdir/hicolor/32x32/mimetypes/application-vnd.mysql-workbench-plugin.png
cp images/icons/MySQLWorkbenchDocIcon32x32.png %buildroot%_iconsdir/hicolor/32x32/mimetypes/application-vnd.mysql-workbench-model.png

%files
%exclude %_libdir/mysql-workbench/*.*a
%exclude %_libdir/mysql-workbench/plugins/*.*a
%exclude %_libdir/mysql-workbench/modules/*.*a
%exclude %_libdir/mysql-workbench/modules/*.py?

%exclude %_datadir/applications/*.desktop
%exclude %_datadir/mysql-workbench/*

%doc COPYING README
%exclude %_datadir/doc/mysql-workbench/COPYING
%exclude %_datadir/doc/mysql-workbench/README

%_bindir/mysql-workbench
%_bindir/wbcopytables
%_libexecdir/mysql-workbench-bin
%dir %_libdir/mysql-workbench
%_libdir/mysql-workbench/*

%files data
%_datadir/applications/*.desktop
%dir %_datadir/mysql-workbench
%_datadir/mysql-workbench/*
%_miconsdir/*
%_niconsdir/*
%_liconsdir/*
%_iconsdir/hicolor/128x128/apps/*
%_iconsdir/hicolor/16x16/mimetypes/*
%_iconsdir/hicolor/32x32/mimetypes/*
%_iconsdir/hicolor/48x48/mimetypes/*
%_iconsdir/hicolor/128x128/mimetypes/*
%_xdgmimedir/packages/*.xml
%_xdgdatadir/mime-info/*.mime

%changelog
