#TODO:
# -
%define realname nrpe
%define rev %nil
%define nagios_confdir   %_sysconfdir/nagios
%define contacts_cfgdir  %_sysconfdir/nagios/contacts
%define plugins_cmddir   %_sysconfdir/nagios/commands
%define templates_cfgdir %_sysconfdir/nagios/templates
%define nagios_plugdir   %_libexecdir/nagios/plugins
%define nagios_evhdir    %_libexecdir/nagios/eventhandlers
%define plugin_docdir    %_docdir/%name-%version
%define nagios_usr nagios
%define nagios_grp nagios

Name: nagios-%realname
Version: 2.12
Release: alt3%rev.qa2

Summary: NRPE -- Nagios(R) Remote Plug-ins Execution daemon.
Summary(ru_RU.UTF-8): NRPE -- Сервер выполнения команд Nagios(R) на удаленном хосте.
License: GPL
Group: Monitoring
URL: http://www.nagios.org
Packager: Dmitry Lebkov <dlebkov@altlinux.ru>

###########################################
# Relations with Nagios daemon or other nagios-plugins executors pkgs (like NRPE)

# Provide the abstract service names (which are virtual pkg names),
# specify their origin (our pkg name as the epoch + version-release):
Provides: nagios-daemon = %name:%version-%release

# Conflict with all other real pkgs which provide the same services
# (they should specify the origin the same way, so the epoch-version-release
# of the virtual pkgs will always differ from that of ours if they are provided
# by a different real pkg):
Conflicts: nagios-daemon < %name:%version-%release
Conflicts: nagios-daemon > %name:%version-%release

# End of the statements to describe relations with Nagios daemon or NRPE pkgs
########################################
Requires: nagios-plugins
Requires(pre): nagios-common

Source0: %realname-%version%rev.tar.gz
Source1: %realname-init
Source2: nagios-addons-nrpe.cfg

# fix default NRPE configuration
Patch0: %realname-2.12-alt-config.patch
Patch1: %realname-2.12-alt-warnings.patch
Patch2: %realname-2.12-alt-defpath.patch

Prefix: %prefix

# Automatically added by buildreq on Sat Jul 01 2006
BuildRequires: libssl-devel libwrap-devel openssl

%package -n nagios-addons-%realname
Summary: Nagios(R) plug-in for NRPE.
Summary(ru_RU.UTF-8): Модуль для Nagios(R), взаимодействующий с сервером NRPE.
License: GPL
Group: Monitoring
PreReq: nagios-plugins
Provides: nagios-plugins-nrpe = %version
Obsoletes: nagios-plugins-nrpe

%description
The %name packages contains the Nagios(R) Remote Plug-ins Executor
-- daemon which can execute predefined commands on the remote host.
Execution request is send via check_nrpe Nagios(R) plug-in. Allowed
monitoring commands are described in the daemon configuration file.

Install the %name package if you want accept and procedd requests
from check_nrpe on this hosts.

%description -l ru_RU.UTF-8
NRPE -- сервер выполнения комманд системы мониторинга Nagios(R) на удаленном
хосте. Система мониторинга Nagios(R) отправляет запросы серверу NRPE с помощью
подключаемого модуля check_nrpe. Команды мониторинга описываются в файле
конфигурации демона.

Установите этот пакет, если вы желаете принимать запросы на выполнение команд
мониторинга от сервера Nagios(R).

%description -n nagios-addons-%realname
Plug-in for Nagios(R) monitoring system. With this plug-in you can send check
request to remote host, with installed NRPE, and process result of execution
as host or service state.

%description -l ru_RU.UTF-8 -n nagios-addons-%realname
Подключаемый модуль для системы мониторинга Nagios(R). Позволяет отправлять
запросы на выполнение команд мониторинга к удаленному хосту с установленным
демоном NRPE.

%prep
%setup -n %realname-%version%rev
%patch0 -p1
%patch1 -p1
%patch2 -p1

%build
%configure \
	--with-nrpe-user=%nagios_usr \
	--with-nrpe-group=%nagios_grp \
	--with-nrpe-port=65534 \
	--enable-ssl \
	--enable-command-args

%make_build all
pushd contrib
	gcc -o nrpe_check_control nrpe_check_control.c
popd

%install
mkdir -p %buildroot/%plugin_docdir

# install binaries
install -pDm0711 src/nrpe %buildroot/%_sbindir/nrpe
install -pDm0711 src/check_nrpe %buildroot/%nagios_plugdir/check_nrpe
install -pDm0711 contrib/nrpe_check_control %buildroot/%nagios_evhdir/nrpe_check_control

# install config
install -pDm0644 sample-config/nrpe.cfg %buildroot/%nagios_confdir/nrpe.cfg
install -pDm0644 %SOURCE2 %buildroot/%plugins_cmddir/nagios-addons-nrpe.cfg

#install init-script
install -pDm0755 %SOURCE1 %buildroot/%_initdir/nrpe

# install sample xinetd config file
install -m 0644 sample-config/nrpe.xinetd %buildroot/%plugin_docdir/nrpe.xinetd

# install docs
for d in Changelog LEGAL README README.SSL SECURITY; do
	install -m 0644 $d %buildroot/%plugin_docdir/
done
install -m 0644 contrib/README.nrpe_check_control %buildroot/%plugin_docdir/

%post
%post_service %realname

%preun
%preun_service %realname

%files
%dir %nagios_confdir
%config(noreplace) %nagios_confdir/nrpe.cfg
%_initdir/nrpe
%_sbindir/nrpe
%doc %plugin_docdir/*
# The package does not own its own docdir subdirectory.
# The line below is added by repocop to fix this bug in a straightforward way. 
# Another way is to rewrite the spec to use relative doc paths.
%dir %_docdir/nagios-nrpe-%version 

%files -n nagios-addons-%realname
%config(noreplace) %plugins_cmddir/nagios-addons-nrpe.cfg
%nagios_plugdir/check_nrpe
%nagios_evhdir/nrpe_check_control
%doc %plugin_docdir/*
%exclude %plugin_docdir/nrpe.xinetd

%changelog
