Name: nant
Version: 0.91
Release: alt1

Summary: A cross platform build tool for the .Net platform
License: GPLv2+
Group: Development/Other

# git://github.com/nant/nant.git
Url: http://nant.sourceforge.net

# for build boo with bootstraped nant
Provides: mono(NAnt.Core)
Provides: mono(NAnt.DotNetTasks)

Source: %name-%version.tar
Patch: %name-%version-%release.patch

# Automatically added by buildreq on Tue Dec 25 2007
BuildRequires: mono-winforms mono-web libgcc mono-devel mono-mcs
BuildRequires: mono-nunit-devel

%description
NAnt is a .NET based build tool. In theory it is kind of like make without
make's wrinkles. In practice it's a lot like Ant.

If you are not familiar with Jakarta Ant you can get more information at the
Ant project web site (http://ant.apache.org/).

If you are not familiar with NAnt you can get more information at the NAnt
project web site (http://NAnt.sourceforge.net).

%package doc
Summary: Documentation and examples for nant
Group: Documentation
BuildArch: noarch

%description doc
Documentation for nant

%package devel
Summary: Develepment file for nant
Group: Development/Other
Requires: %name = %version-%release

%description devel
Develepment file for nant

%prep
%setup
%patch -p1

# install to libdir instead of datadir
sed -i -e "/property name=\"install\.share\"/ s/'share'/'lib'/" NAnt.build
sed -i -e "s,/share/,/lib/," etc/nant.pc.in

# Remove NDoc support
rm src/NAnt.DotNet/Tasks/NDocTask.cs
find lib -name 'NDoc*.dll' | xargs rm

# Remove NUnit1 support and fix build with system NUnit.
# Based on Debian's 004-nant-nunit_2.4.dpatch
find lib -iname 'nunit*' | xargs rm

# Remove SharpCvsLib support
find lib -name "*SharpCvsLib*.dll" | xargs rm
find lib -name "scvs.exe" | xargs rm

# Use system SharpZipLib which is older than the one bundled with nant
# https://bugzilla.novell.com/show_bug.cgi?id=426065
find lib -name "*SharpZipLib*.dll" | xargs rm


find . -type d -exec chmod 755 {} \;
find . -type f -exec chmod 644 {} \;
sed -i 's/\r//' doc/license.html
sed -i 's/\r//' COPYING.txt
sed -i 's/\r//' README.txt
sed -i 's/\r//' doc/releasenotes.html

%build
%make

%install
%make install prefix=%_prefix DESTDIR=%buildroot

find examples -name \*.dll -o -name \*.exe|xargs rm -f
rm -rf %buildroot%_datadir/NAnt/doc

mkdir -p %buildroot/%_libdir/pkgconfig
test "%_libdir" = "%_prefix/lib" || mv %buildroot/%_prefix/lib/pkgconfig/* %buildroot/%_libdir/pkgconfig

## Fix script
#cat <<EOF > %buildroot%_bindir/nant
##!/bin/sh
#mono /usr/lib/NAnt/NAnt.exe "\$@"
#EOF
#chmod 755 %buildroot%_bindir/nant

%files
%_bindir/nant
#%_monogacdir/*
#%_libexecdir/NAnt
%_prefix/lib/NAnt

%files doc
%doc doc web examples

%files devel
%_pkgconfigdir/*.pc

%changelog
