%define _name nautilus2
%define ver_major 3.8
%define api_ver 3.0

%def_enable exempi
%def_disable packagekit
%def_enable tracker
%def_enable introspection
%def_enable selinux

Name: nautilus
Version: %ver_major.1
Release: alt1

Summary: Nautilus is a network user environment
License: GPLv2+
Group: Graphical desktop/GNOME
URL: http://gnome.org
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

# http://bugzilla.gnome.org/show_bug.cgi?id=519743 
Patch17: %name-filetype-symlink-fix.patch

# (fc) 2.22.2-2mdv auto-unmount ejected medias when mount points are in fstab (Mdv bug #39540) 
Patch35: %name-2.22.1-umountfstab.patch

Obsoletes: %_name <= 2.14.1
Provides: %_name = %version-%release
Obsoletes: gnome-volume-manager
Provides: gnome-volume-manager

%define pkgconfig_ver 0.8
%define icon_theme_ver 2.10.0
%define desktop_file_utils_ver 0.8

# From configure.in
%define glib_ver 2.35.3
%define desktop_ver 3.3.3
%define pango_ver 1.28.3
%define gtk_ver 3.5.5
%define libxml2_ver 2.4.7
%define exif_ver 0.5.12
%define exempi_ver 2.1.0
%define gir_ver 0.10.2
%define notify_ver 0.7.0
%define tracker_ver 0.12

PreReq: lib%name = %version-%release
PreReq: gnome-icon-theme >= %icon_theme_ver

Requires: shared-mime-info
Requires: common-licenses
Requires: gvfs >= 1.9.1

BuildPreReq: pkgconfig >= %pkgconfig_ver
BuildPreReq: desktop-file-utils >= %desktop_file_utils_ver
BuildPreReq: rpm-build-gnome rpm-build-licenses
# for %%check
BuildPreReq: xvfb-run dbus-tools-gui /proc

# From configure.in
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libgnome-desktop3-devel >= %desktop_ver
BuildPreReq: libpango-devel >= %pango_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: gsettings-desktop-schemas-devel
BuildPreReq: libgail3-devel
BuildPreReq: libxml2-devel >= %libxml2_ver
BuildPreReq: intltool >= 0.40.1
BuildPreReq: libexif-devel >= %exif_ver
BuildPreReq: libnotify-devel >= %notify_ver
BuildRequires: libX11-devel xorg-xproto-devel
BuildRequires: docbook-utils gtk-doc
%{?_enable_exempi:BuildPreReq: libexempi-devel >= %exempi_ver}
%{?_enable_tracker:BuildPreReq: tracker-devel >= %tracker_ver}
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel >= %gir_ver libgtk+3-gir-devel}
%{?_enable_selinux:BuildRequires: libselinux-devel}

%description
Nautilus integrates access to files, applications, media, Internet-based
resources and the Web.  Nautilus delivers a dynamic and rich user
experience.  Nautilus is an free software project developed under the
GNU General Public License and is a core component of the GNOME desktop
project.

%package -n lib%name
Summary: Shared libraries needed to run Nautilus
Group: System/Libraries

%description -n lib%name
This package contains shared libraries needed to run Nautilus and its
components.

%package -n lib%name-devel
Summary: Libraries and include files for developing Nautilus components
Group: Development/GNOME and GTK+
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package provides the necessary development libraries and include
files to allow you to develop Nautilus components.

%package -n lib%name-devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
Conflicts: lib%name-devel < %version-%release
BuildArch: noarch

%description -n lib%name-devel-doc
This package contains development documentation for the %name.

%package -n lib%name-gir
Summary: GObject introspection data for the nautilus-extension library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the nautilus-extension library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the nautilus-extension library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the nautilus-extension library


%define _bonobo_servers_dir %_libdir/bonobo/servers
%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup -q
%patch17 -p0 -b .symlink

rm -f data/*.desktop

# make check using xvfb-run
subst 's@\.\/@xvfb-run -a ./@' eel/check-eel src/check-nautilus

%build
%autoreconf
%configure \
    --disable-update-mimedb \
    --disable-schemas-compile \
    %{subst_enable tracker} \
    %{subst_enable packagekit}

%make_build

%if 0
%check
for d in eel src; do
pushd $d
make check
popd
done
%endif

%install
%make_install install DESTDIR=%buildroot
mkdir -p %buildroot%_libdir/%name-%api_ver/components
bzip2 -9fk NEWS

# The license
ln -sf %_licensedir/LGPL-2 COPYING

%find_lang %name

%files -f %name.lang
%_bindir/*
%_libexecdir/nautilus-convert-metadata
#%_libexecdir/nautilus-shell-search-provider
%dir %_libdir/%name-%api_ver
%dir %_libdir/%name-%api_ver/components
%_datadir/mime/packages/nautilus.xml
%_datadir/applications/*.desktop
%_sysconfdir/xdg/autostart/nautilus-autostart.desktop
%_datadir/%name
%_datadir/dbus-1/services/org.gnome.Nautilus.service
%_datadir/dbus-1/services/org.freedesktop.FileManager1.service
%_datadir/dbus-1/services/org.gnome.Nautilus.SearchProvider.service
%_datadir/gnome-shell/search-providers/nautilus-search-provider.ini
# gsettings schemas
%config %_datadir/glib-2.0/schemas/org.gnome.nautilus.gschema.xml
%_datadir/GConf/gsettings/nautilus.convert
# docs
%doc --no-dereference COPYING
%doc AUTHORS MAINTAINERS NEWS.bz2 README THANKS
%_man1dir/*

%files -n lib%name
%_libdir/libnautilus-extension.so.*
%dir %_libdir/%name/extensions-%api_ver
%_libdir/%name/extensions-%api_ver/libnautilus-sendto.so
%exclude %_libdir/%name/extensions-3.0/libnautilus-sendto.la

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%files -n lib%name-devel-doc
%_gtk_docdir/*
%doc docs/*.{txt,pdf,sxw,html} README.commits

%if_enabled introspection
%files -n lib%name-gir
%_libdir/girepository-1.0/*

%files -n lib%name-gir-devel
%_datadir/gir-1.0/*
%endif


%changelog
