%define ver_major 3.6

%def_enable gtk_doc
%def_with gupnp
%def_without gajim

Name: nautilus-sendto
Version: %ver_major.1
Release: alt2

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Summary: Nautilus Sendto menu item
License: GPL
Group: Graphical desktop/GNOME
Url: http://www.gnome.org

Obsoletes: %name-thunderbird
Obsoletes: %name-sylpheed
Obsoletes: %name-balsa

Source: %name-%version.tar.xz

%define eds_ver 3.5.3

BuildPreReq: rpm-build-gnome
BuildRequires: intltool glib2-devel libgio-devel libgtk+3-devel pidgin-devel libpurple-devel libnautilus-devel
BuildRequires: libdbus-glib-devel libdbus-devel gtk-doc evolution-data-server-devel >= %eds_ver gcc-c++ gnome-common
%{?_with_gajim:BuildRequires: gajim}
%{?_with_gupnp:BuildRequires: libgupnp-devel}

%description
This application provides integration between nautilus and other.
It adds a Nautilus context menu component ("Send To...") and features
a dialog for insert the email or IM account which you want to send
the file/files.

%package evolution
Summary: Send files from nautilus to evolution
Group: Graphical desktop/GNOME
Requires: evolution
Requires: %name = %version
Provides: %name-plugin = %version-%release

%description evolution
This application provides integration between nautilus and evolution.
It adds a Nautilus context menu component ("Send To...") and features
a dialog for insert the email acount which you want to send the
file/files.

%package pidgin
Summary: Send files from nautilus to pidgin
Group: Graphical desktop/GNOME
Requires: pidgin
Requires: %name = %version
Provides: %name-plugin = %version-%release
Provides: nautilus-sendto-gaim
Obsoletes: nautilus-sendto-gaim

%description pidgin
This application provides integration between nautilus and pidgin.  It
adds a Nautilus context menu component ("Send To...") and features a
dialog for insert the IM account which you want to send the file/files.

%package gajim
Summary: Send files from nautilus to gajim
Group: Graphical desktop/GNOME
Requires: gajim
Requires: %name = %version
Provides: %name-plugin = %version-%release

%description gajim
This application provides integration between nautilus and gajim.  It
adds a Nautilus context menu component ("Send To...") and features a
dialog for insert the IM account which you want to send the file/files.

%package removable-devices
Summary: Send files from nautilus to removable devices
Group: Graphical desktop/GNOME
Requires: %name = %version
Provides: %name-plugin = %version-%release

%description removable-devices
This application provides ability for nautilus to send files to
removable devices and shares.

%package nautilus-burn
Summary: Send files to from nautilus to nautilus-cd-burner
Group: Graphical desktop/GNOME
Requires: %name = %version
Provides: %name-plugin = %version-%release
Requires: brasero-nautilus

%description nautilus-burn
This application provides integration between nautilus and Nautilus CD Burner.

%package upnp
Summary: Send files to to UPNP Media Servers
Group: Graphical desktop/GNOME
Requires: %name = %version
Provides: %name-plugin = %version-%release

%description upnp
Plugin to allow sending files to UPNP Media Servers

%package devel
Summary: Development files for %name
Group: Development/C

%description devel
The %name-devel package contains header files for developing
applications that use %name

%package devel-doc
Summary: Development documentation for %name
Group: Development/C
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
The %name-devel-doc package contains documentation needed for developing
applications that use %name

%prep
%setup -q

%build
%autoreconf
%configure \
	--with-plugins="evolution %{?_with_gajim:gajim} nautilus-burn pidgin removable-devices upnp" \
	--disable-schemas-compile \
	%{subst_enable gtk_doc} \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot install

find %buildroot%_libdir -name \*.la -delete

%find_lang %name

%files -f %name.lang
%doc NEWS AUTHORS COPYING ChangeLog*
%_bindir/*
# in nautilus now
%exclude %_libdir/nautilus/extensions-3.0/libnautilus-sendto.so
%dir %_libdir/%name/
%dir %_libdir/%name/plugins
%_datadir/%name
%_datadir/GConf/gsettings/nautilus-sendto-convert
%_datadir/glib-2.0/schemas/*.xml
%_man1dir/*.1*

%files pidgin
%_libdir/%name/plugins/libnstpidgin.so

%if_with gajim
%files gajim
%_libdir/%name/plugins/libnstgajim.so
%endif

%files evolution
%_libdir/%name/plugins/libnstevolution.so

%files nautilus-burn
%_libdir/%name/plugins/libnstburn.so

%files removable-devices
%_libdir/%name/plugins/libnstremovable_devices.so

%if_with gupnp
%files upnp
%_libdir/%name/plugins/libnstupnp.so
%endif

%files devel
%_includedir/%name
%_pkgconfigdir/*.pc

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%else
%exclude %_datadir/gtk-doc/html/*
%endif

%changelog
