%def_disable debug
%def_enable syslog
%def_enable lfs
%def_disable sdp
%def_with gznbd
%def_with setproctitle
%def_without  static_client

Name: nbd
Version: 3.2
Release: alt1
Summary: Network Block Device user space tools
License: GPL
Group: Networking/Other
URL: http://%name.sourceforge.net/
Source: %name-%version.tar

BuildRequires: glib2-devel docbook-utils
%{?_with_setproctitle:BuildRequires: setproctitle-devel}
%{?_with_gznbd:BuildRequires: zlib-devel}
%{?_with_static_client:BuildRequires: dietlibc}
%{?_enable_sdp:BuildRequires: libsdp-devel}

%description
Tools for the Linux Kernel's network block device, allowing you to use
remote block devices over a TCP/IP network.

%package doc
Summary: Network Block Device user space tools documentation
Group: Documentation
BuildArch: noarch

%description doc
This package contains basic documentation for Network Block Device
user space tools.

%package server
Summary: Network Block Device server
Group: Networking/Other
Requires: %name-doc = %version-%release

%description server
This package contains nbd-server - a user space daemon to serve files
for Network Block Devices on remote hosts.

%package client
Summary: Network Block Device client
Group: Networking/Other
Requires: %name-doc = %version-%release

%description client
This package contains nbd-client - a user space tool needed to manage
a Network Block Device.

%if_with static_client
%package client-static
Summary: Network Block Device static client
Group: Networking/Other
Requires: %name-doc = %version-%release

%description client-static
This package contains a statically linked edition of nbd-client.
%endif

%prep
%setup

%build
./autogen.sh
%if_with static_client
%configure \
    %{subst_enable debug} \
    %{subst_enable lfs} \
    --disable-syslog \
    --disable-sdp
make CC="diet -Os %__cc" CFLAGS="%optflags -Os" LDADD="-lcompat" %name-client
mv %name-client{,.static}
%make_build clean
%endif
%configure \
    %{subst_enable debug} \
    %{subst_enable lfs} \
    %{subst_enable syslog} \
    %{subst_enable sdp} \
    %{subst_with setproctitle} \
    #
%make_build
%{?_with_gznbd:%make_build -C gznbd CFLAGS="%optflags -DMY_NAME='\"gznbd\"'"}

%install
%makeinstall_std
%{?_with_static_client:install -pm755 %name-client.static %buildroot%_sbindir/}
%{?_with_gznbd:install -pm755 gznbd/gznbd %buildroot%_bindir/}
install -pD -m755 %name.init %buildroot%_initdir/%name
install -pD -m755 %name.service %buildroot%_unitdir/nbd.service
install -pD -m644 %name.sysconfig %buildroot%_sysconfdir/sysconfig/nbd-server
install -pD %name-server.conf %buildroot%_sysconfdir/%name-server/config

%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir
install -pm644 README simple_test %buildroot%docdir/

%pre server
%_sbindir/groupadd -r -f _nbd
%_sbindir/useradd -r -g _nbd -d /dev/null -s /dev/null -n _nbd > /dev/null 2>&1 ||:

%post server
%post_service %name

%preun server
%preun_service %name

%files doc
%docdir

%files server
%_bindir/*
%config(noreplace) %_sysconfdir/sysconfig/nbd-server
%_man1dir/*
%_man5dir/*
%_initdir/*
%_unitdir/*.service
%defattr(600,root,_nbd,710)
%config(noreplace) %_sysconfdir/%name-server/

%files client
%_sbindir/%name-client
%_man8dir/*

%if_with static_client
%files client-static
%_sbindir/%name-client.static
%endif

%changelog
