Name: ncpfs
Version: 2.2.6
Release: alt9.qa1

Summary: Utilities for the %name filesystem, a NetWare client for Linux
License: GPL
Group: Networking/Other
Packager: Dmitry Lebkov <dlebkov@altlinux.ru>

# ftp://platan.vc.cvut.cz/pub/linux/%name/%name-%version/%name-%version.tar.gz
Source: %name-%version.tar
Source1: mount.ncp
Source2: ncpfs.control

Patch0: ncpfs-2.2.6-alt-makefile.patch
Patch1: ncpfs-2.2.6-alt-compile.patch
Patch2: ncpfs-2.2.6-alt-gcc41-compile.patch
Patch3: ncpfs-2.2.6-alt-warnings.patch

Patch10: ncpfs-2.2.3-fix.patch
Patch11: ncpfs-2.2.3-array.patch
Patch12: ncpfs-2.2.4-pie.patch
Patch13: ncpfs-2.2.6-getuid.patch
Patch15: ncpfs-2.2.6-align.patch
Patch16: ncpfs-2.2.6-rh-mount-issue.patch

Requires: libncp = %version-%release

# Automatically added by buildreq on Mon Jan 15 2007
BuildRequires: libpam-devel control

%define controlled_binaries ncpmount ncpumount slist

#uildPreReq: gcc3.4

%package -n libncp
Summary: Shared library for access the %name filesystem
Group: System/Libraries

%package -n libncp-devel
Summary: Development environmnt for the %name filesystem
Group: Development/C
Requires: libncp = %version-%release

%package -n ipxutils
Summary: Tools for configuring and debugging IPX interfaces and networks
Group: System/Configuration/Networking

%description
Ncpfs is a filesystem which understands the Novell NetWare(TM)
NCP protocol.  Functionally, NCP is used for NetWare the way NFS
is used in the TCP/IP world.  For a Linux system to mount a NetWare
filesystem, it needs a special mount program.  The %name package
contains such a mount program plus other tools for configuring and
using the %name filesystem.

Install the %name package if you need to use the %name filesystem
to use Novell NetWare files or services.

%description -n libncp
Ncpfs is a filesystem which understands the Novell NetWare(TM)
NCP protocol.  Functionally, NCP is used for NetWare the way NFS
is used in the TCP/IP world.  For a Linux system to mount a NetWare
filesystem, it needs a special mount program.  The %name package
contains such a mount program plus other tools for configuring and
using the %name filesystem.

This package contains shared library required to run NCP-based software.

%description -n libncp-devel
Ncpfs is a filesystem which understands the Novell NetWare(TM)
NCP protocol.  Functionally, NCP is used for NetWare the way NFS
is used in the TCP/IP world.  For a Linux system to mount a NetWare
filesystem, it needs a special mount program.  The %name package
contains such a mount program plus other tools for configuring and
using the %name filesystem.

This package contains static library and headers required to develop
NCP-based software.

%description -n ipxutils
The ipxutils package includes utilities (ipx_configure, ipx_internal_net,
ipx_interface, ipx_route) necessary for configuring and debugging IPX
interfaces and networks under Linux. IPX is the low-level protocol used
by Novell's NetWare file server system to transfer data.

Install ipxutils if you need to configure IPX networking on your network.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch15 -p1
%patch16 -p1

%build
%configure \
	--enable-pam \
	--disable-function-sections \
	--disable-mount-v2

%make_build
%make_build -C ipxdump
cp -p ipxdump/README README.ipxdump
cp -p contrib/pam/README README.pam_ncp

%install
mkdir -p %buildroot{/sbin,%_sbindir,/lib/security}
%makeinstall install-dev \
	libsodir=%buildroot/%_libdir \
	libadir=%buildroot/%_libdir \
	LIB_PAM_SECURITY=%buildroot/lib/security

# Move these to permit /usr from NFS
for f in ipx_{configure,internal_net,interface}; do
	mv "%buildroot/%_bindir/$f" "%buildroot/sbin/$f"
done

install -p -m755 ipxdump/ipx{dump,parse} %buildroot/%_bindir

ln -s ..%_bindir/ncpmount %buildroot/sbin/mount.ncp
ln -s mount.ncp %buildroot/sbin/mount.ncpfs

# These could be SUID root, but it's a security hole.
# PS: we'll let local sysadmin control that
chmod a-s %buildroot/%_bindir/*

for n in %controlled_binaries; do
	install -pD -m755 %SOURCE2 "%buildroot%_controldir/$n"
	subst -p "s/@NAME@/$n/" "%buildroot%_controldir/$n"
done

%find_lang %name

%pre
/usr/sbin/groupadd -r -f netadmin &>/dev/null
for n in %controlled_binaries; do
	%pre_control $n
done

%post
for n in %controlled_binaries; do
	%post_control -s restricted $n
done

%files -n libncp
%_libdir/*.so.*

%files -n libncp-devel
%_libdir/*.so
%_libdir/*.*a
%_includedir/*
%_man3dir/*

%files -f %name.lang
/sbin/m*
%_sbindir/*
%_bindir/[nps]*
/lib/security/*
%config %_controldir/*
%_man1dir/*
%_man5dir/*
%_man8dir/n*
%_man8dir/mount.ncp.8*
%doc BUGS Changes ConfigFile INSTALL FAQ README README.pam_ncp

%files -n ipxutils
/sbin/ipx*
%_bindir/ipx*
%_man8dir/ipx*
%doc ipx-1.0/COPYING ipx-1.0/README README.ipxdump

%changelog
