%define _sbinrootdir /sbin

Name: ndiswrapper
Version: 1.58
Release: alt1

Group: System/Configuration/Hardware
Summary: NdisWrapper allows you to use Windows WLAN card drivers
License: GPL
Url: http://ndiswrapper.sourceforge.net/

Packager: Ilya Mashkin <oddity@altlinux.ru>

#Source0: 	http://prdownloads.sourceforge.net/ndiswrapper/%name-%version.tar.gz
Source0: %name-%version.tar.gz
# Mdk:
#Patch0: 	ndiswrapper-1.0-spaces.patch
# analogous to nvidia_glx deps:
#Requires: 	NDISWRAPPER_kernel

%description
Some vendors do not release specifications of the hardware
or provide a linux driver for their wireless network cards.
The NdisWrapper project provides a linux kernel module that
loads and runs Ndis (Windows network driver API) drivers
supplied by the vendors.

This package contains only userspace tools from NdisWrapper.
The kernel module comes in a separte package
(kernel-modules-ndiswrapper...).

%define module_name %name
%define module_version %version

%package -n kernel-source-%module_name-%module_version
Group: Development/Kernel
Summary: Linux %module_name modules sources

%description -n kernel-source-%module_name-%module_version
%module_name modules sources for Linux kernel.

%prep
%setup
#patch0 -p1 -b .spaces

%build
pushd utils
%make_build
popd

%install
pushd utils
#%make_install DESTDIR="$RPM_BUILD_ROOT" \
#	sbindir="$RPM_BUILD_ROOT"%_sbinrootdir \
#	usrsbindir="$RPM_BUILD_ROOT"%_sbindir \
#	mandir="$RPM_BUILD_ROOT"%_mandir \
#	install
make DESTDIR=$RPM_BUILD_ROOT install

popd

%__mkdir_p $RPM_BUILD_ROOT%_sysconfdir/%name

%__mkdir_p $RPM_BUILD_ROOT%_man8dir
%__install -m 644 ndiswrapper.8 $RPM_BUILD_ROOT%_man8dir
%__install -m 644 loadndisdriver.8 $RPM_BUILD_ROOT%_man8dir

# place to store packaged Windows drivers (ndis-driver-* pkgs)
%__mkdir_p $RPM_BUILD_ROOT%_libdir/ndis

# kernel-source install
%__mkdir_p $RPM_BUILD_ROOT%_usrsrc/kernel/sources/
cp %SOURCE0 $RPM_BUILD_ROOT%_usrsrc/kernel/sources/kernel-source-%module_name-%module_version.tar.gz

%post
echo -e "please download binary driver at http://ndiswrapper.sourceforge.net/wiki/index.php/List\nuse ndiswrapper -i <inffile.inf> as root to install driver"

%files
%doc AUTHORS README ChangeLog INSTALL
/sbin/loadndisdriver
%_sbindir/ndiswrapper
%_sbindir/ndiswrapper-buginfo
%dir %_sysconfdir/%name
%_man8dir/*
# place to store packaged Windows drivers (ndis-driver-* pkgs)
%_libdir/ndis

%files -n kernel-source-%module_name-%module_version
%_usrsrc/kernel/sources/*ndis*

%changelog
