%define abiversion 30
%define _name net-snmp
%def_disable mibs
%def_with mysql
%def_with systemd
# XXX tests fail
%def_without test

Name: %_name%abiversion
Version: 5.7.2
Release: alt4.M70P.1

Summary: Tools and servers for the SNMP protocol
License: BSD-like
Group: System/Servers
Url: http://net-snmp.sourceforge.net
Packager: Slava Dubrovskiy <dubrsl@altlinux.ru>

Source0: %name-%version.tar
#git clone git://net-snmp.git.sourceforge.net/gitroot/net-snmp/net-snmp
Source1: %_name.init
Source2: %_name.conf
Source3: %_name.logrotate
Source4: snmptrapd.init
Source9: net-snmp-tmpfs.conf
Source10: snmpd.service
Source11: snmptrapd.service

Patch: %name-%version-%release.patch
Patch6: net-snmp-5.7.2-systemd.patch

%define persistentdir %_localstatedir/%_name

%def_enable static
BuildPreReq: librpm-devel >= 4.0.4 libssl-devel
# Automatically added by buildreq on Wed Oct 13 2010
BuildRequires: libnl-devel librpm-devel libsensors3-devel libwrap-devel pdksh perl-devel python-module-setuptools perl-Tk perl-Term-ReadLine-Gnu perl-libnet perl-XML-Simple
%{?_enable_static:BuildPreReq: glibc-devel-static}
%{?_with_mysql:BuildRequires: libmysqlclient-devel}
%{?_with_systemd:BuildRequires: systemd-devel}
BuildRequires: perl-podlators chrpath

%package -n %_name-common
Summary: Common dirs and files for the SNMP protocol
Group: System/Servers
BuildArch: noarch
Requires: snmp-mibs-std
%if_enabled mibs
Requires: %_name-mibs = %version-%release
%endif

%package -n %_name-config
Summary: net-snmp-config
Group: System/Servers
Requires: lib%_name = %version-%release %_name-common

%package -n %_name
Summary: Virtual package for install snmpd server and clients of the SNMP protocol
Group: System/Servers
BuildArch: noarch
Requires: %_name-snmpd %_name-snmptrapd %_name-clients

%package -n %_name-snmpd
Summary: Snmpd server for the SNMP protocol
Group: System/Servers
PreReq: chkconfig
Requires: lib%_name = %version-%release %_name-common
Obsoletes: cmu-snmp ucd-snmp

%package -n %_name-snmptrapd
Summary: Snmptrapd and server for the SNMP protocol
Group: System/Servers
PreReq: chkconfig
Requires: lib%_name = %version-%release %_name-common
Obsoletes: cmu-snmp ucd-snmp

%package -n %_name-clients
Summary: Tools for use SNMP, from the Net-SNMP project
Group: Networking/Other
Requires: lib%_name = %version-%release %_name-common

%package -n %_name-utils
Summary: Network management utilities using SNMP, from the Net-SNMP project
Group: Networking/Other
BuildArch: noarch
Requires: lib%_name = %version-%release %_name-common perl-SNMP
Obsoletes: cmu-snmp-utils, ucd-snmp-utils

%package -n %_name-bridge-mib
Summary: Provide Linux bridge information via SNMP
Group: Networking/Other
BuildArch: noarch
Requires: %_name-snmpd

%package -n %_name-cert
Summary: Creates, signs, installs and displays X.509 certificates used in the operation of Net-SNMP/(D)TLS
Group: Networking/Other
BuildArch: noarch
Requires: %_name-common %_name-config

%package -n lib%name
Summary: The shared libraries for the Net-SNMP project
Group: System/Libraries
Provides: lib%_name = %version-%release

%package -n lib%name-snmptrapd
Summary: The shared libraries for the Net-SNMP project
Group: System/Libraries
Provides: lib%_name-snmptrapd = %version-%release

%package -n lib%_name-devel
Summary: The development environment for the Net-SNMP project
Group: Development/C
Requires: lib%_name = %version-%release lib%_name-snmptrapd = %version-%release %_name-common %_name-config
Provides: lib%_name-devel = %version-%release lib%name-devel = %version-%release
Requires: libwrap-devel libssl-devel libsensors3-devel libnl-devel

%package -n lib%_name-devel-static
Summary: static libraries for lib%_name
Group: Development/C
Requires: lib%_name-devel = %version-%release

%package -n libucd-snmp%abiversion
Summary: The shared libraries for the UCD-SNMP project
Group: System/Libraries
Provides: libucd-snmp = %version-%release

%package -n libucd-snmp-devel
Summary: The development environment for the UCD-SNMP project
Group: Development/C
Requires: libucd-snmp = %version-%release
Provides: libucd-snmp-devel = %version
Obsoletes: cmu-snmp-devel

%package -n libucd-snmp-devel-static
Summary: static libraries for the UCD-SNMP project
Group: Development/C
Requires: libucd-snmp-devel = %version-%release

%if_enabled mibs
%package -n %_name-mibs
Summary: MIB files from the Net-SNMP project
Group: Networking/Other
%endif

%package -n perl-SNMP
Summary: Perl SNMP Extension Module
Group: Development/Perl
Requires: lib%_name = %version-%release %_name-common

%package -n python-module-netsnmp
Summary: Python SNMP Extension Module
Group: Development/Python
Requires: lib%_name = %version-%release

%description
SNMP (Simple Network Management Protocol) is a protocol used for network
management (hence the name).  The Net-SNMP project includes various SNMP
tools; an extensible agent, an SNMP library, tools for requesting or
setting information from SNMP agents, tools for generating and handling
SNMP traps, a version of the netstat command which uses SNMP, and a
Tk/Perl mib browser.  This package contains the snmpd and snmptrapd
daemons, documentation, etc.

Install the %_name package if you need network management tools.
You will probably also want to install the %_name-utils package, which
contains Net-SNMP utilities.

%description -n %_name-common
SNMP (Simple Network Management Protocol) is a protocol used for network
management (hence the name).  The Net-SNMP project includes various SNMP
tools; an extensible agent, an SNMP library, tools for requesting or
setting information from SNMP agents, tools for generating and handling
SNMP traps, a version of the netstat command which uses SNMP, and a
Tk/Perl mib browser.  This package contains the snmpd and snmptrapd
daemons, documentation, etc.

%_name-common package contain common files and dirs

%description -n %_name-config
SNMP (Simple Network Management Protocol) is a protocol used for network
management (hence the name).  The Net-SNMP project includes various SNMP
tools; an extensible agent, an SNMP library, tools for requesting or
setting information from SNMP agents, tools for generating and handling
SNMP traps, a version of the netstat command which uses SNMP, and a
Tk/Perl mib browser.  This package contains the snmpd and snmptrapd
daemons, documentation, etc.

%_name-common package contain net-snmp-config

%description -n %_name
SNMP (Simple Network Management Protocol) is a protocol used for network
management (hence the name).  The Net-SNMP project includes various SNMP
tools; an extensible agent, an SNMP library, tools for requesting or
setting information from SNMP agents, tools for generating and handling
SNMP traps, a version of the netstat command which uses SNMP, and a
Tk/Perl mib browser.  This package contains the snmpd and snmptrapd
daemons, documentation, etc.

%_name is virtual package for quick install %_name-snmpd %_name-snmptrapd %_name-clients

%description -n %_name-snmpd
SNMP (Simple Network Management Protocol) is a protocol used for network
management (hence the name).  The Net-SNMP project includes various SNMP
tools; an extensible agent, an SNMP library, tools for requesting or
setting information from SNMP agents, tools for generating and handling
SNMP traps, a version of the netstat command which uses SNMP, and a
Tk/Perl mib browser.  This package contains the snmpd and snmptrapd
daemons, documentation, etc.

%_name-snmpd package contain snmpd server

%description -n %_name-snmptrapd
SNMP (Simple Network Management Protocol) is a protocol used for network
management (hence the name).  The Net-SNMP project includes various SNMP
tools; an extensible agent, an SNMP library, tools for requesting or
setting information from SNMP agents, tools for generating and handling
SNMP traps, a version of the netstat command which uses SNMP, and a
Tk/Perl mib browser.  This package contains the snmpd and snmptrapd
daemons, documentation, etc.

%_name-snmptrapd package contain snmptrapd server

%description -n %_name-clients
The %_name-clients package contains various tools for use with the
Net-SNMP network management project.

Install this package if you need utilities for managing your network
using the SNMP protocol.

%description -n %_name-utils
The %_name-utils package contains various utilities for use with the
Net-SNMP network management project.

Install this package if you need utilities for managing your network
using the SNMP protocol.

%description -n %_name-bridge-mib
Provide Linux bridge information via SNMP

%description -n %_name-cert
net-snmp-cert creates, signs, installs and displays X.509
certificates used in the operation of Net-SNMP/(D)TLS

%description -n lib%name
The lib%_name package contains the shared libraries required for
Net-SNMP software.

%description -n lib%name-snmptrapd
The lib%name-snmptrapd package contains the shared libraries required for
Net-SNMP software.

%description -n lib%_name-devel
This package contains include files required for development
applications for use with the Net-SNMP project's network management
tools. You'll also need to have the lib%_name and %_name-utils packages
installed.

%description -n lib%_name-devel-static
This package contains static libraries required for development
statically linked applications for use with the Net-SNMP project's
network management tools. You'll also need to have the lib%_name-devel
package installed.


%if_enabled mibs
%description -n %_name-mibs
The %_name package contains various MIB files for use with the
Net-SNMP network management project.
%endif

%description -n libucd-snmp%abiversion
The libucd-snmp package contains the shared libraries required for
UCD-SNMP software.

%description -n libucd-snmp-devel
This package contains include files required for development
applications for use with the UCD-SNMP project's network management
tools.

%description -n libucd-snmp-devel-static
This package contains static libraries required for development
statically linked applications for use with the UCD-SNMP project's
network management tools. You'll also need to have the libucd-snmp-devel
package installed.

%description -n perl-SNMP
This is the Perl 'SNMP' extension module. The SNMP module provides
a full featured, tri-lingual SNMP (SNMPv3, SNMPv2c, SNMPv1) API.
The SNMP module also provides an interface to the SMI MIB parse-tree
for run-time access to parsed MIB data.

%description -n python-module-netsnmp
This is the Python 'SNMP' extension module. The SNMP module provides
a full featured, tri-lingual SNMP (SNMPv3, SNMPv2c, SNMPv1) API.
The SNMP module also provides an interface to the SMI MIB parse-tree
for run-time access to parsed MIB data.

%prep
%setup
%patch -p1
%patch6 -p0

%__subst "s|LIB_LD_LIBS)|LIB_LD_LIBS) \$\{ADD_HELPER\}|g" agent/Makefile.in
#Fix for compile with lmsensors_v3
%__subst "s|lmsensors_v2|lmsensors_v3|g" agent/mibgroup/hardware/sensors.h
#Fix flnk with mysql
sed -i '/LLIBTRAPD_OBJS/s/USELIBS)/USELIBS) \$(MYSQL_LIBS)/' apps/Makefile.in
#Fix install python
sed -i '/(PYMAKE) install/s/\$dir/\$dir --root \$(DESTDIR)/' Makefile.in
#Fix https://sourceforge.net/tracker/?func=detail&aid=3295407&group_id=12694&atid=112694
sed -i 's/PyInt_AsVoidPtr/PyLong_AsVoidPtr/' python/netsnmp/client_intf.c


%build

%autoreconf
#export NETSNMP_DONT_CHECK_VERSION=1
export LIBS='-lcrypto -lwrap'
%configure %{subst_enable static} \
	--with-defaults \
	--enable-shared \
	--enable-ipv6 \
	--with-sys-location="Just west of Mars" \
	--with-sys-contact="root@localhost" \
	--with-logfile="/var/log/snmpd.log" \
	--with-mib-modules="mibII snmpv3mibs ucd_snmp agent_mibs notification target utilities disman/event disman/schedule host ucd-snmp/diskio ucd-snmp/lmsensorsMib tunnel misc/ipfwacc etherlike-mib mibII/ipv6 ip-mib/ipv4InterfaceTable ip-mib/ipv6InterfaceTable" \
	--with-mibdirs="%_datadir/snmp/mibs:%_datadir/mibs/net-snmp:%_datadir/mibs/iana:%_datadir/mibs/ietf:%_datadir/mibs/tubs:%_datadir/mibs/cisco:%_datadir/pibs/ietf:%_datadir/pibs/tubs:" \
	--with-persistent-directory="%persistentdir" \
	--without-root-access \
	--without-rpm \
	--enable-ucd-snmp-compatibility \
	--enable-mfd-rewrites \
	--with-default-snmp-version="2" \
	--with-libwrap \
	--with-openssl \
	--with-zlib \
	--with-nl \
	--with-security-modules="usm tsm" --with-transports="DTLSUDP TLSTCP UDP TCP UDPIPv6 TCPIPv6 Unix Callback Alias" \
	--enable-as-needed \
	--with-perl-modules="INSTALLDIRS=vendor" \
	--enable-embedded-perl \
	--with-python-modules \
	%{subst_with mysql} \
	%{subst_with systemd}

NPROCS=1
%make_build
rm -f `find ./ -name 'libnetsnmpagent*'`
%make ADD_HELPER="-L$PWD/agent/helpers/.libs -lnetsnmphelpers"


%install
%make DESTDIR=%buildroot install

mkdir -p %buildroot%_initdir
mkdir -p %buildroot%_sysconfdir/sysconfig
mkdir -p %buildroot%persistentdir
mkdir -p %buildroot%_defaultdocdir/perl-SNMP-%version

install -p -m755 -D %SOURCE1 %buildroot%_initdir/snmpd
install -p -m640 -D %SOURCE2 %buildroot%_sysconfdir/snmp/snmpd.conf
install -p -m644 -D %SOURCE3 %buildroot%_sysconfdir/logrotate.d/snmpd
install -p -m755 -D %SOURCE4 %buildroot%_initdir/snmptrapd

# systemd stuff
install -m 755 -d %buildroot%_sysconfdir/tmpfiles.d/
install -m 644 %SOURCE9 %buildroot%_sysconfdir/tmpfiles.d/net-snmp.conf
install -m 755 -d %buildroot%_unitdir
install -m 644 %SOURCE10 %SOURCE11 %buildroot%_unitdir/

# perl loadable objects contain $RPM_BUILD_DIR-dependent RPATH
#hrpath -d `find %buildroot%perl_vendor_autolib -type f -name '*.so'`

cat << EOF > %buildroot%_sysconfdir/sysconfig/snmpd
#OPTIONS="-Ls DAEMON -Lf /dev/null -p /var/run/snmpd.pid -a -u snmp -g snmp"

EOF

bzip2 ChangeLog

#Fix net-snmp-create-v3-user
%__subst "s|ps -acx|ps acx|g" %buildroot%_bindir/net-snmp-create-v3-user
%__subst "s|/usr/share/snmp/snmpd.conf|%_sysconfdir/snmp/snmpd.conf|g" %buildroot%_bindir/net-snmp-create-v3-user


find %buildroot%_datadir/snmp/mibs/ -name "*.txt" -type f | while read file; do mv "$file" "${file%.txt}"; done

#tar MIBS for simle update
tar -cjf net-snmp-mibs.tar.bz2 -C %buildroot%_datadir/snmp mibs/
rm -rf %buildroot%_datadir/snmp/mibs

#Fix rpath
find %buildroot%perl_vendor_autolib/SNMP -type f -name *.so -print0 | xargs -r0 chrpath -d
find %buildroot%perl_vendor_autolib/NetSNMP -type f -name *.so -print0 | xargs -r0 chrpath -d

%check
echo "===== start test ====="
%make test

%pre -n %_name-common
%_sbindir/groupadd -r -f snmp &>/dev/null
%_sbindir/useradd -r -g snmp -d /dev/null -s /dev/null \
        -c "SNMP pseudo user" -M -n snmp &>/dev/null ||:
%_sbindir/usermod -g proc snmp &>/dev/null ||:

%post -n %_name-snmpd
%post_service snmpd

%post -n %_name-snmptrapd
%post_service snmptrapd

%preun -n %_name-snmpd
%preun_service snmpd

%preun -n %_name-snmptrapd
%preun_service snmptrapd

%files -n %_name

%files -n %_name-common
%doc AGENT.txt COPYING ChangeLog.* EXAMPLE.conf FAQ NEWS PORTING README* TODO
%dir %_sysconfdir/snmp
%dir %_datadir/snmp
%attr(0770,snmp,root) %persistentdir

%files -n %_name-config
%_bindir/net-snmp-create-v3-user
%_bindir/net-snmp-config
%_man1dir/net-snmp-config.*

%files -n %_name-snmpd
%config(noreplace) %_sysconfdir/tmpfiles.d/net-snmp.conf
%config(noreplace) %_initdir/snmpd
%config(noreplace) %_unitdir/snmpd.service
%config(noreplace) %_sysconfdir/sysconfig/snmpd
%config(noreplace) %_sysconfdir/logrotate.d/snmpd
%config(noreplace) %attr(0640,snmp,root) %_sysconfdir/snmp/snmpd.conf
%_sbindir/snmpd
%_bindir/encode_keychange
%_man5dir/snmpd.conf.*
%_man5dir/snmpd.examples.*
%_man5dir/snmpd.internal*
%_man5dir/snmp_config.*
%_man5dir/variables.*
%_man8dir/snmpd.*

%files -n %_name-snmptrapd
%config(noreplace) %_initdir/snmptrapd
%config(noreplace) %_unitdir/snmptrapd.service
%_sbindir/snmptrapd
%_man5dir/snmptrapd.conf.*
%_man8dir/snmptrapd.*

%files -n %_name-clients
%_bindir/agentxtrap
%_bindir/snmpbulkget
%_bindir/snmpbulkwalk
%_bindir/snmpdelta
%_bindir/snmpdf
%_bindir/snmpget
%_bindir/snmpgetnext
%_bindir/snmpinform
%_bindir/snmpnetstat
%_bindir/snmpset
%_bindir/snmpstatus
%_bindir/snmptable
%_bindir/snmptest
%_bindir/snmptls
%_bindir/snmptranslate
%_bindir/snmptrap
%_bindir/snmpusm
%_bindir/snmpvacm
%_bindir/snmpwalk

%_man1dir/agentxtrap.*
%_man1dir/encode_keychange*
%_man1dir/net-snmp-create-v3-user.*
%_man1dir/snmpbulkget.*
%_man1dir/snmpbulkwalk.*
%_man1dir/snmpcmd.*
%_man1dir/snmpdelta.*
%_man1dir/snmpdf.*
%_man1dir/snmpget.*
%_man1dir/snmpgetnext.*
%_man1dir/snmpinform.*
%_man1dir/snmpnetstat.*
%_man1dir/snmpset.*
%_man1dir/snmpstatus.*
%_man1dir/snmptable.*
%_man1dir/snmptest.*
%_man1dir/snmptranslate.*
%_man1dir/snmptrap.*
%_man1dir/snmpusm.*
%_man1dir/snmpvacm.*
%_man1dir/snmpwalk.*
%_man5dir/snmp.conf.*

%files -n %_name-utils
%doc local/README.mib2c
%_datadir/snmp/mib2c-data
%_datadir/snmp/mib2c.*.conf
%_datadir/snmp/mib2c.conf
%_datadir/snmp/snmpconf-data

%_bindir/fixproc
#%_bindir/ipf-mod.pl
%_bindir/mib2c
%_bindir/mib2c-update
%_bindir/snmpcheck
%_bindir/snmpconf
%_bindir/tkmib
%_bindir/traptoemail

%_man1dir/fixproc.*
%_man1dir/mib2c*
%_man1dir/snmpconf.*
%_man1dir/tkmib.*
%_man1dir/traptoemail.*
%_man5dir/mib2c.*

%files -n %_name-bridge-mib
%_bindir/snmp-bridge-mib
%_man1dir/snmp-bridge-mib.*

%files -n %_name-cert
%_bindir/net-snmp-cert

%files -n lib%name
%_libdir/libnetsnmp.so.*
%_libdir/libnetsnmpagent.so.*
%_libdir/libnetsnmphelpers.so.*
%_libdir/libnetsnmpmibs.so.*

%files -n lib%name-snmptrapd
%_libdir/libnetsnmptrapd.so.*

%files -n lib%_name-devel
%doc net-snmp-mibs.tar.bz2
%_libdir/libnetsnmp.so
%_libdir/libnetsnmpagent.so
%_libdir/libnetsnmphelpers.so
%_libdir/libnetsnmpmibs.so
%_libdir/libnetsnmptrapd.so
%_includedir/%_name
%_man3dir/*

%if_enabled static
%files -n lib%_name-devel-static
%_libdir/libnetsnmp.a
%_libdir/libnetsnmpagent.a
%_libdir/libnetsnmphelpers.a
%_libdir/libnetsnmpmibs.a
%_libdir/libnetsnmptrapd.a
%endif

%files -n libucd-snmp%abiversion
%_libdir/libsnmp.so.*

%files -n libucd-snmp-devel
%_libdir/libsnmp.so
%_includedir/ucd-snmp

%if_enabled static
%files -n libucd-snmp-devel-static
%_libdir/libsnmp.a
%endif

%if_enabled mibs
%files -n %_name-mibs
%_datadir/snmp/mibs
%endif

%files -n perl-SNMP
%doc perl/SNMP/{examples,README,BUG,TODO}
%_datadir/snmp/snmp_perl.pl
%_datadir/snmp/snmp_perl_trapd.pl
%perl_vendor_archlib/SNMP*
%perl_vendor_autolib/SNMP*
%perl_vendor_archlib/NetSNMP*
%perl_vendor_autolib/NetSNMP*

%files -n python-module-netsnmp
%python_sitelibdir/netsnmp*
%doc python/README

%changelog
