# This spec is backported to ALTLinux p7 automatically by rpmbph script from etersoft-build-utils.
#
Name: netdata
Version: 1.4.0
Release: alt1.M70P.2

Summary: Real-time performance monitoring, done right!

License: GPLv3+
Group: File tools
Url: http://netdata.firehol.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-git: https://github.com/firehol/netdata.git
Source: %name-%version.tar

# manually removed: python-module-google python-module-mwlib python3-dev python3-module-yieldfrom python3-module-zope ruby ruby-stdlibs 
# Automatically added by buildreq on Fri Aug 05 2016
# optimized out: perl pkg-config python-base python-modules python3 python3-base
BuildRequires: rpm-build-intro libuuid-devel zlib-devel

# FIXME: wait for new rpm-build-intro in p8
%define _localstatedir /var

%if_with nfacct
BuildRequires: libmnl-devel
BuildRequires: libnetfilter_acct-devel
%endif

%add_findreq_skiplist %_libexecdir/%name/plugins.d/*.plugin
%add_findreq_skiplist %_libexecdir/%name/charts.d/*.sh

%description
netdata is the fastest way to visualize metrics. It is a resource
efficient, highly optimized system for collecting and visualizing any
type of realtime timeseries data, from CPU usage, disk activity, SQL
queries, API calls, web site visitors, etc.

netdata tries to visualize the truth of now, in its greatest detail,
so that you can get insights of what is happening now and what just
happened, on your systems and applications.

%prep
%setup

%build
%autoreconf
%configure \
	--docdir=%_docdir/%name-%version \
	--with-zlib \
	--with-math \
	%{?with_nfacct:--enable-plugin-nfacct} \
	--with-user=netdata
%make_build

%install
%makeinstall_std
rm -rf %buildroot%_libexecdir/netdata/python.d/python_modules/pyyaml{2,3}

mkdir -p %buildroot%_sysconfdir/%name/
install -m 644 -p system/netdata.conf %buildroot%_sysconfdir/%name/netdata.conf

mkdir -p %buildroot%_sysconfdir/logrotate.d/
install -m 644 -p system/netdata.logrotate %buildroot%_sysconfdir/logrotate.d/%name

find %buildroot -name .keep | xargs rm

install -d %buildroot%_unitdir/
install -m 644 -p system/netdata.service %buildroot%_unitdir/netdata.service

%pre
getent group netdata > /dev/null || groupadd -r netdata
getent passwd netdata > /dev/null || useradd -r -g netdata -c netdata -s /sbin/nologin -d / netdata

%files
%attr(0700,netdata,netdata) %dir %_localstatedir/cache/%name/
%attr(0700,netdata,netdata) %dir %_localstatedir/log/%name/
%attr(0700,netdata,netdata) %dir %_localstatedir/lib/%name/
%dir %_sysconfdir/%name/
#config(noreplace) %_sysconfdir/%name/netdata.conf
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/%name/*.conf
%dir %_sysconfdir/%name/health.d/
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/%name/health.d/*.conf
%dir %_sysconfdir/%name/python.d/
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/%name/python.d/*.conf
%config(noreplace) %_logrotatedir/%name
%_sbindir/%name
%_unitdir/netdata.service
%dir %_libexecdir/%name/
%_libexecdir/%name/charts.d/
%_libexecdir/%name/node.d/
%_libexecdir/%name/plugins.d/
%_libexecdir/%name/python.d/
%dir %_datadir/%name

# override defattr for web files (see netdata.conf for web access user/group)
%defattr(644,root,netdata,755)
%_datadir/%name/web/

%changelog
