%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl

Name: netgen
Version: 5.1
Release: alt1.svn20130203
Summary: Automatic 3d tetrahedral mesh generator
License: LGPL
Group: Graphics
Url: http://www.hpfem.jku.at/netgen/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar
Source1: demoapp.tar
Source2: dropsexport.tar

Requires: lib%name = %version-%release tcl-tix
BuildRequires(pre): rpm-build-tcl
BuildPreReq: %mpiimpl-devel libjpeg-devel libavcodec-devel tcl-devel tk-devel
BuildPreReq: tcl-togl-devel libGL-devel libGLU-devel libparmetis-devel
BuildPreReq: libavformat-devel libswscale-devel bzlib-devel zlib-devel
BuildPreReq: libopencascade-devel
BuildPreReq: libXmu-devel chrpath

%description
NETGEN is an automatic 3d tetrahedral mesh generator. It accepts input
from constructive solid geometry (CSG) or boundary representation (BRep)
from STL file format. The connection to a geometry kernel allows the
handling of IGES and STEP files. NETGEN contains modules for mesh
optimization and hierarchical mesh refinement.

%package -n lib%name
Summary: Shared library of NETGEN
Group: System/Libraries

%description -n lib%name
NETGEN is an automatic 3d tetrahedral mesh generator. It accepts input
from constructive solid geometry (CSG) or boundary representation (BRep)
from STL file format. The connection to a geometry kernel allows the
handling of IGES and STEP files. NETGEN contains modules for mesh
optimization and hierarchical mesh refinement.

This package contains shared library of NETGEN.

%package -n lib%name-devel
Summary: Development files of NETGEN
Group: Development/C++
Requires: lib%name = %version-%release

%description -n lib%name-devel
NETGEN is an automatic 3d tetrahedral mesh generator. It accepts input
from constructive solid geometry (CSG) or boundary representation (BRep)
from STL file format. The connection to a geometry kernel allows the
handling of IGES and STEP files. NETGEN contains modules for mesh
optimization and hierarchical mesh refinement.

This package contains development files of NETGEN.

%package doc
Summary: Documentation for NETGEN
Group: Documentation
BuildArch: noarch

%description doc
NETGEN is an automatic 3d tetrahedral mesh generator. It accepts input
from constructive solid geometry (CSG) or boundary representation (BRep)
from STL file format. The connection to a geometry kernel allows the
handling of IGES and STEP files. NETGEN contains modules for mesh
optimization and hierarchical mesh refinement.

This package contains documentation for NETGEN.

%package tutorials
Summary: Tutorials for NETGEN
Group: Documentation
BuildArch: noarch

%description tutorials
NETGEN is an automatic 3d tetrahedral mesh generator. It accepts input
from constructive solid geometry (CSG) or boundary representation (BRep)
from STL file format. The connection to a geometry kernel allows the
handling of IGES and STEP files. NETGEN contains modules for mesh
optimization and hierarchical mesh refinement.

This package contains tutorials for NETGEN.

%package demo
Summary: Demo for NETGEN
Group: Graphics
BuildArch: noarch
Requires: %name = %version-%release

%description demo
NETGEN is an automatic 3d tetrahedral mesh generator. It accepts input
from constructive solid geometry (CSG) or boundary representation (BRep)
from STL file format. The connection to a geometry kernel allows the
handling of IGES and STEP files. NETGEN contains modules for mesh
optimization and hierarchical mesh refinement.

This package contains demo for NETGEN.

%prep
%setup
%ifarch x86_64
sed -i "s|@UINT64_C@|UL|" ng/ngpkg.cpp
%else
sed -i "s|@UINT64_C@|ULL|" ng/ngpkg.cpp
%endif

tar -xf %SOURCE1
tar -xf %SOURCE2

%build
mpi-selector --set %mpiimpl
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"
source %mpidir/bin/mpivars.sh
export MPIDIR=%mpidir

sed -i 's|@MPIDIR@|%mpidir|g' configure.ac
PARS="-DPARALLEL -DOMPI_IGNORE_CXX_SEEK -DMETIS -DHAVE_IOMANIP"
PARS="$PARS -DGLX_GLXEXT_PROTOTYPES -I%mpidir/include"
%add_optflags $PARS -DJPEGLIB -DFFMPEG -DHAVE_IOSTREAM -DHAVE_LIMITS

%autoreconf
%configure \
	--enable-occ \
	--enable-nglib \
	--enable-parallel \
	--enable-jpeglib \
	--enable-ffmpeg \
	--with-tcl=%_libdir \
	--with-togl=%_tcllibdir \
	--with-tk=%_libdir
#sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build TCLLIBDIR=%_tcllibdir
# for complete linking of libraries
for i in csg stlgeom meshing interface geom2d
do
	pushd libsrc/$i
	%make clean
	popd
	%make_build TCLLIBDIR=%_tcllibdir \
		NGLIB=$PWD/nglib/libnglib.la TOPDIR=$PWD
done

%install
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"
export MPIDIR=%mpidir
%makeinstall_std TCLLIBDIR=%_tcllibdir TOPDIR=$PWD

pushd dropsexport
%autoreconf
%configure \
	--enable-static=no \
	--with-netgen=%buildroot \
	--with-netgensrc=$PWD/..
%make_build
%makeinstall_std
popd

for i in %buildroot%_libdir/*.so %buildroot%_bindir/*; do
	chrpath -r %mpidir/lib:%_tcllibdir $i ||:
done

%files
%doc AUTHORS
%_bindir/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*

%files doc
%_docdir/%name

%files tutorials
%_datadir/%name

%files demo
%doc demoapp

%changelog
