%define abiversion 52
%define main_version 0.%abiversion.14
%define _name newt

Name: %_name%abiversion
Version: %main_version
Release: alt1

%def_enable tk
 
Summary: A development library for text mode user interfaces.
License: LGPL
Group: System/Libraries
Url: https://fedorahosted.org/releases/n/e/newt/
Packager: Slava Dubrovskiy <dubrsl@altlinux.ru>

Source: %url/%name-%version.tar
Patch: %name-%version-%release.patch

Requires: slang, lib%name = %version-%release
Provides: snack = %version-%release

# Automatically added by buildreq on Tue Oct 22 2002
BuildRequires: libpopt-devel libslang2-devel python-devel docbook-utils
%if_enabled tk
BuildRequires: tkinter
%endif

%package -n lib%name
Summary: Newt windowing toolkit development files library.
Group: System/Libraries
Provides: lib%_name = %version-%release

%package -n python-module-%name
Summary: Python files for the %name.
Version: %{main_version}_%_python_version
Group: System/Libraries
Requires: python = %_python_version, lib%name = %{main_version}-%release
Provides: python-module-%_name = %version-%release

%package -n lib%_name-devel
Summary: Newt windowing toolkit development files.
Group: Development/C
Version: %main_version
Requires: lib%name = %version-%release, libslang2-devel
Provides: lib%_name-devel = %version-%release lib%name-devel = %version-%release
Obsoletes: %_name-devel

%package -n lib%_name-devel-static
Summary: Newt windowing toolkit development files.
Group: Development/C
Requires: lib%name-devel = %version-%release
Provides: lib%_name-devel-static = %version-%release lib%name-devel-static = %version-%release

%description
Newt is a programming library for color text mode, widget based user
interfaces.  Newt can be used to add stacked windows, entry widgets,
checkboxes, radio buttons, labels, plain text fields, scrollbars,
etc., to text mode user interfaces.  This package contains a
/usr/bin/dialog replacement called whiptail.
Newt is based on the slang library.

%description -n lib%name
Newt is a programming library for color text mode, widget based user
interfaces.  Newt can be used to add stacked windows, entry widgets,
checkboxes, radio buttons, labels, plain text fields, scrollbars,
etc., to text mode user interfaces.  This package contains the
shared library needed by programs built with %name.
Newt is based on the slang library.

%description -n python-module-%name
python stuff for the %name

%description -n lib%_name-devel
The lib%name-devel package contains the header files and libraries
necessary for developing applications which use %name. Newt is
a development library for text mode user interfaces.
Newt is based on the slang library.

Install lib%name-devel if you want to develop applications which will
use %name.

%description -n lib%_name-devel-static
Static libraries for  lib%name-devel 

%prep
%setup
%patch -p1

subst s/^PYTHONVERS.*/PYTHONVERS=python%_python_version/ Makefile.in

%build
./autogen.sh
%configure --with-gpm-support 
# NO SMP
%make PYTHON_LIBS="-lpython%_python_version"
docbook2html -u tutorial.sgml

%install
%makeinstall 

%find_lang --with-gnome %_name

%files -n lib%name -f %_name.lang
%_libdir/*.so.*

%files 
%_bindir/*
%doc CHANGES
%_man1dir/*

%files -n python-module-%name
%_libdir/python%_python_version/*/*.py*
%_libdir/python%_python_version/*/*.so

%files -n lib%_name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
%doc tutorial.html

%files -n lib%_name-devel-static
%_libdir/*.*a

%changelog
