Name: nfdump
Version: 1.6.15
Release: alt1
Summary: collect and process netflow data

Group: Monitoring
License: %bsd
Url: http://sourceforge.net/projects/nfdump/

Source: %name-%version.tar
Source2: nfcapd.init
Source3: nfcapd.sysconfig
Source4: nfcapd.service
Source5: %name.tmpfiles
Source6: sfcapd.init
Source7: sfcapd.sysconfig
Source8: sfcapd.service

Packager: Vladimir Lettiev <crux@altlinux.ru>

BuildRequires: rpm-build-licenses

BuildRequires: librrd-devel libpcap-devel flex bison zlib-devel bzlib-devel

%description
Nfdump is a set of tools to collect and process netflow data.
It's fast and has a powerful filter pcap like syntax. Nfdump
supports netflow versions v5, v7, v9 and IPFIX as well as a
limited set of sflow and is IPv6 compatible.

%package nfprofile
Summary: nfprofile - netflow profiler
Group: Monitoring

%description nfprofile
nfprofile is the netflow profiler program for NfSen. It reads
the netflow data from the files stored by nfcapd and creates
the corresponding output files for every channel required.
This program is run only by NfSen.

%package nftrack
Summary: nftrack - Port tracking decoder for NfSen plugin PortTracker.
Group: Monitoring

%description nftrack
nftrack - Port tracking decoder for NfSen plugin PortTracker.

%package -n libnfdump
Summary: nfdump shared library
Group: System/Libraries

%description -n libnfdump
nfdump shared library

%package -n libnfdump-devel
Summary: nfdump development files
Group: Development/C

%description -n libnfdump-devel
nfdump development files

%prep
%setup -q

%build
%autoreconf
%configure \
	--disable-static \
	--enable-nfprofile \
	--enable-nftrack \
	--enable-sflow \
	--enable-readpcap \
	--enable-nfpcapd \
	--enable-nsel \
	--enable-compat15

%make_build

%install
%makeinstall_std
mkdir -p %buildroot{%_cachedir/{nfcapd,sfcapd},%_sysconfdir/sysconfig,%_initdir,%_unitdir,%_tmpfilesdir,%_runtimedir/{nfcapd,sfcapd}}

install -m0755 %SOURCE2 %buildroot%_initdir/nfcapd
install -m0644 %SOURCE3 %buildroot%_sysconfdir/sysconfig/nfcapd
install -m0644 %SOURCE4 %buildroot%_unitdir/nfcapd.service
install -m0644 %SOURCE5 %buildroot%_tmpfilesdir/%name.conf
install -m0755 %SOURCE6 %buildroot%_initdir/sfcapd
install -m0644 %SOURCE7 %buildroot%_sysconfdir/sysconfig/sfcapd
install -m0644 %SOURCE8 %buildroot%_unitdir/sfcapd.service

%pre
%_sbindir/groupadd -r -f nfcapd
%_sbindir/useradd -r -n -g nfcapd -d %_cachedir/nfcapd -s /bin/false nfcapd >/dev/null 2>&1 ||:

%_sbindir/groupadd -r -f sfcapd
%_sbindir/useradd -r -n -g sfcapd -d %_cachedir/sfcapd -s /bin/false sfcapd >/dev/null 2>&1 ||:

%post
%post_service nfcapd
%post_service sfcapd

%preun
%preun_service nfcapd
%preun_service sfcapd

%files
%exclude %_bindir/nfprofile
%exclude %_man1dir/nfprofile.1.*
%exclude %_bindir/nftrack
%_bindir/*
%_man1dir/*
%_initdir/*
%_unitdir/*
%_tmpfilesdir/*
%config(noreplace) %_sysconfdir/sysconfig/*
%attr(770,root,nfcapd) %dir %_cachedir/nfcapd
%attr(775,root,nfcapd) %dir %_runtimedir/nfcapd
%attr(770,root,sfcapd) %dir %_cachedir/sfcapd
%attr(775,root,sfcapd) %dir %_runtimedir/sfcapd
%doc README NEWS AUTHORS ChangeLog COPYING

%files nfprofile
%_bindir/nfprofile
%_man1dir/nfprofile.1.*

%files nftrack
%_bindir/nftrack

%files -n libnfdump
%_libdir/libnfdump-%version.so

%files -n libnfdump-devel
%_libdir/libnfdump.so

%changelog
