Name: nfs
Version: 1.2.8
Release: alt1
Epoch: 1

Summary: The Linux NFS clients, utilities and server
License: GPL
Group: Networking/Other
Url: http://nfs.sourceforge.net/

Source0: %name-%version-%release.tar

BuildRequires: libblkid-devel libevent-devel libnfsidmap-devel >= 0.23 libwrap-devel
BuildRequires: libkrb5-devel librpcsecgss-devel >= 0.19 libsqlite3-devel
BuildRequires: libcap-devel libtirpc-devel libkeyutils-devel libmount-devel
BuildRequires: libdevmapper-devel

%package clients
Summary: The Linux NFS client
Group: Networking/Other

PreReq: shadow-utils
PreReq: %name-utils = %epoch:%version-%release
Requires(post): %post_service
Requires(preun): %preun_service
Requires: keyutils >= 1.4-alt2
Conflicts: libnfsidmap < 0.23

%package server
Summary: The Linux NFS server
Group: Networking/Other

PreReq: %name-clients = %epoch:%version-%release
Requires(post): %post_service
Requires(preun): %preun_service

%package utils
Summary: The Linux NFS services utilities
Group: Networking/Other

PreReq: control
Requires: rpcbind >= 0.2.0-alt1
Conflicts: mount < 2.12r-alt2
Conflicts: nfs-clients = 1:1.0.10-alt2

%package stats
Summary: The Linux NFS stats utilities
Group: Networking/Other
Conflicts: nfs-utils < 1:1.2.4-alt0.4

%description
This package provides the Linux NFS utilities and server.
This package replaces the old knfsd package.

%description clients
This package provides the Linux NFS clients.

%description server
This package provides the Linux NFS server.

%description utils
This package provides the Linux NFS utilities,
including mount.nfs helper.

%description stats
This package provides the Linux NFS stats utilities.

%prep
%setup

%build
[ -f ./autogen.sh ] && sh ./autogen.sh
%configure \
    --enable-mount \
    --enable-libmount-mount \
    --enable-gss \
    --enable-tirpc \
    --enable-ipv6 \
    --with-statduser=rpcuser \
    --with-statdpath=%_localstatedir/nfs/statd \
    #
sed -i 's/#define[[:blank:]]\+START_STATD.\+$/#undef START_STATD/' support/include/config.h
%make_build

%install
%make_install DESTDIR=%buildroot install

cp -a altlinux/* %buildroot

mkdir -p %buildroot/sbin
mv  %buildroot%_sbindir/rpc.{idmapd,statd,gssd} \
    %buildroot%_sbindir/blkmapd \
    %buildroot%_sbindir/nfsidmap \
    %buildroot%_sbindir/sm-notify %buildroot/sbin/

mkdir -p %buildroot%_localstatedir/nfs/{rpc_pipefs,v4recovery}

#-------------------------------------------------------------------------------
%pre clients
%_sbindir/groupadd -r -f rpcuser &> /dev/null
%_sbindir/useradd -r -g rpcuser -d %_localstatedir/nfs -s /dev/null -c 'RPC Service User' -n rpcuser &> /dev/null ||:
%_sbindir/groupadd -r -f nfsuser &> /dev/null
%_sbindir/useradd -r -g nfsuser -d /dev/null -s /dev/null -c 'NFS Service User' -n nfsuser &> /dev/null ||:

%pre utils
[ $1 -eq 1 ] || /usr/sbin/control-dump nfsmount

%post clients
%post_service nfslock
%post_service blkmapd
%post_service idmapd
%post_service gssd

%post utils
[ $1 -eq 1 ] || /usr/sbin/control-restore nfsmount

%preun clients
%preun_service nfslock
%preun_service blkmapd
%preun_service idmapd
%preun_service gssd

%post server
%post_service nfs
%post_service svcgssd

%preun server
%preun_service nfs
%preun_service svcgssd

%triggerpostun -- nfs-server <= 1.2.5-alt1
. /etc/init.d/functions
SourceIfNotEmpty /etc/sysconfig/nfs
is_yes "$SECURE_NFS" || exit 0
touch /var/lock/subsys/rpc.svcgssd
/sbin/chkconfig svcgssd on
/sbin/service svcgssd condrestart

#-------------------------------------------------------------------------------
%files server
%_initdir/nfs
%_initdir/svcgssd
%systemd_unitdir/nfs.target
%systemd_unitdir/nfs.service
%systemd_unitdir/rquotad.service
%systemd_unitdir/mountd.service
%systemd_unitdir/svcgssd.service
%systemd_unitdir/proc-fs-nfsd.mount

%_sbindir/exportfs
%_sbindir/nfsstat
%_sbindir/nfsdcltrack
%_sbindir/rpc.mountd
%_sbindir/rpc.nfsd
%_sbindir/rpc.svcgssd

%_man5dir/exports.*
%_man7dir/nfsd.*
%_man8dir/exportfs.*
%_man8dir/nfsstat.*
%_man8dir/nfsdcltrack.*
%_man8dir/mountd.*
%_man8dir/rpc.mountd.*
%_man8dir/nfsd.*
%_man8dir/rpc.nfsd.*
%_man8dir/svcgssd.*
%_man8dir/rpc.svcgssd.*

%config(noreplace) %_localstatedir/nfs/xtab
%config(noreplace) %_localstatedir/nfs/etab
%config(noreplace) %_localstatedir/nfs/rmtab
%dir %_localstatedir/nfs/v4recovery

#-------------------------------------------------------------------------------
%files clients
%doc README
%dir %_localstatedir/nfs
%dir %_localstatedir/nfs/rpc_pipefs
%dir %attr(700,rpcuser,rpcuser) %_localstatedir/nfs/statd
%dir %attr(700,rpcuser,rpcuser) %_localstatedir/nfs/statd/sm
%dir %attr(700,rpcuser,rpcuser) %_localstatedir/nfs/statd/sm.bak
%ghost %attr(700,rpcuser,rpcuser) %_localstatedir/nfs/statd/state

%config(noreplace) %_sysconfdir/sysconfig/nfs

%_initdir/blkmapd
%_initdir/idmapd
%_initdir/nfslock
%_initdir/gssd
%systemd_unitdir/blkmap.service
%systemd_unitdir/blkmapd.service
%systemd_unitdir/idmapd.service
%systemd_unitdir/nfslock.service
%systemd_unitdir/gssd.service
%systemd_unitdir/var-lib-nfs-rpc_pipefs.mount

/sbin/rpc.gssd
/sbin/rpc.idmapd
/sbin/rpc.statd
/sbin/sm-notify
/sbin/blkmapd
/sbin/nfsidmap

%_man8dir/gssd.*
%_man8dir/rpc.gssd*
%_man8dir/blkmapd.*
%_man8dir/idmapd.*
%_man8dir/rpc.idmapd.*
%_man8dir/statd.*
%_man8dir/rpc.statd.*
%_man8dir/sm-notify.*
%_man8dir/rpc.sm-notify.*
%_man8dir/nfsidmap.*

#-------------------------------------------------------------------------------
%files utils
%config %_sysconfdir/control.d/facilities/nfsmount
%attr(700,root,root) /sbin/mount.nfs
/sbin/mount.nfs4
/sbin/umount.*
/sbin/osd_login
%_bindir/showmount
%_sbindir/rpcdebug
%_sbindir/gss_clnt_send_err
%_sbindir/gss_destroy_creds

%_man5dir/nfs.*
%_man8dir/rpcdebug.*
%_man8dir/showmount.*
%_man8dir/mount.nfs.*
%_man8dir/umount.nfs.*

%files stats
%_sbindir/mountstats
%_sbindir/nfsiostat
%_man8dir/mountstats.*
%_man8dir/nfsiostat.*

%changelog
