%define pcre_version 4.5

%def_with perl
%def_with aio
%def_with aio
%def_with ipv6
%def_without syslog
%def_without image_filter
%def_without xslt
%def_without debug
%def_with geoip
%def_enable cache_purge
%def_enable ctpp2
# If you want to update rtmp module -- use rtmp-update.sh
%def_enable rtmp

Name: nginx
Version: 1.8.1
Release: alt0.M70P.1

Summary: Fast HTTP server
License: BSD
Group: System/Servers

Url: http://sysoev.ru/nginx
Source: %url/%name-%version.tar
Source1: %name.conf.in
Source2: %name.init
Source3: %name.logrotate.in
Source5: %name.sysconfig
Source6: default.conf
Source7: cache_purge.tar
Source8: ngx_ctpp2.tar
Source9: %name.service
Source10: nginx-rtmp-module.tar
Source11: mime.types
Source100: %name.watch

Patch1: nginx-0.8-syslog.patch

Packager: Denis Smirnov <mithraen@altlinux.ru>

# Automatically added by buildreq on Mon May 07 2007
BuildRequires: libpcre-devel libssl-devel perl-devel zlib-devel

%if_with geoip
BuildRequires: libGeoIP-devel
Requires: GeoIP-Lite-City GeoIP-Lite-Country
%endif

%if_with image_filter
BuildRequires: libgd2-devel
%endif

%if_with xslt
BuildRequires: libxml2-devel libxslt-devel
%endif

%if_with debug
BuildRequires: google-perftools-devel
%endif

%if_enabled ctpp2
BuildRequires: libctpp-devel gcc-c++
%endif

Requires(pre): shadow-utils
Requires(post): sed

Provides: webserver

%define nginx_user _nginx
%define nginx_group _nginx
%define nginx_etc %_sysconfdir/%name
%define nginx_spool %_spooldir/%name
%define nginx_log %_logdir/%name

%define configs %buildroot{%_unitdir/%name.service,%_sysconfdir/logrotate.d/%name,%nginx_etc/{%name.conf,sites-available.d/default.conf}}

%description
Fast HTTP server, extremely useful as an Apache frontend

%prep
%setup -a 7 -a 8 -a 10
%if_with syslog
%patch1 -p2
%endif

sed -i 's/INSTALLSITEMAN3DIR=.*/INSTALLDIRS=vendor/' auto/lib/perl/make
cp -f %SOURCE11 conf/mime.types

%build
%ifarch i686
	CPU="-mtune=pentiumpro" \
%else # pentium4 athlon
	CPU="-mtune=%_arch" \
%endif
%ifarch i586
	CPU="" \
%endif
%ifnarch %ix86
	CPU="" \
%endif # for x86_64 TODO for amd64/nocona
# FIXME: %%configure?
CFLAGS="%optflags $CPU" ./configure \
	--prefix=/ \
	--conf-path=%nginx_etc/nginx.conf \
	--sbin-path=%_sbindir \
	--error-log-path=%nginx_log/nginx.error.log \
	--http-log-path=%nginx_log/nginx.log \
	--http-client-body-temp-path=%nginx_spool/tmp/client \
	--http-proxy-temp-path=%nginx_spool/tmp/proxy \
	--http-fastcgi-temp-path=%nginx_spool/tmp/fastcgi \
	--http-uwsgi-temp-path=%nginx_spool/tmp/uwsgi \
	--http-scgi-temp-path=%nginx_spool/tmp/scgi \
	--pid-path=%_var/run/nginx.pid \
	--user=%nginx_user \
	--group=%nginx_group \
	--with-http_ssl_module \
	--with-cc-opt="-I %_includedir/pcre/" \
	--with-rtsig_module	\
	--with-select_module    \
	--with-poll_module      \
%if_with aio
	--with-aio_module	\
	--with-file-aio		\
%endif
%if_with ipv6
        --with-ipv6 \
%endif
	--with-mail \
	--with-mail_ssl_module \
	--with-imap \
	--with-imap_ssl_module \
	--with-md5=%_libdir \
	--with-http_ssl_module  \
%if_enabled cache_purge
	--add-module=cache_purge \
%endif
%if_enabled ctpp2
	--add-module=ngx_ctpp2 \
%endif
%if_enabled rtmp
	--add-module=nginx-rtmp-module \
%endif
	--with-http_mp4_module \
	--with-http_realip_module \
	--with-http_addition_module \
	--with-http_sub_module \
	--with-http_dav_module \
	--with-http_flv_module \
	--with-http_gzip_static_module \
	--with-http_stub_status_module \
	--with-http_secure_link_module \
        --with-http_spdy_module \
%if_with geoip
	--with-http_geoip_module \
%endif
%if_with image_filter
	--with-http_image_filter_module \
%endif
%if_with xslt
	--with-http_xslt_module \
%endif
%if_with debug
	--with-google_perftools_module \
%endif
%if_with perl	
	--with-http_perl_module \
%endif
%if_with syslog
	--with-syslog \
%endif


subst s!%buildroot!!g objs/*.h
%make_build DESTDIR=%buildroot

%install
mkdir -p %buildroot{%nginx_etc,%_sysconfdir/logrotate.d,%_sbindir,%nginx_spool/tmp,%nginx_log}
mkdir -p %buildroot%_spooldir/nginx/tmp/{client,proxy,fastcgi,scgi,uwsgi}
mkdir -p %buildroot%_lockdir/%name
mkdir -p %buildroot%nginx_etc/sites-enabled.d
mkdir -p %buildroot%nginx_etc/sites-available.d
mkdir -p %buildroot%nginx_etc/conf-enabled.d
mkdir -p %buildroot%nginx_etc/conf-available.d

%makeinstall DESTDIR=%buildroot

rm -f %buildroot%nginx_etc/%name.conf
install -pD -m644 %SOURCE1 %buildroot%nginx_etc/%name.conf
install -pD -m755 %SOURCE2 %buildroot%_initdir/%name
install -pD -m644 %SOURCE3 %buildroot%_sysconfdir/logrotate.d/%name
install -pD -m644 %SOURCE5 %buildroot%_sysconfdir/sysconfig/%name
install -pD -m644 %SOURCE6 %buildroot%nginx_etc/sites-available.d/default.conf
install -pD -m644 %SOURCE9 %buildroot%_unitdir/%name.service
install -pD -m644 nginx-rtmp-module/stat.xsl %buildroot%nginx_etc/stat.xsl

subst s!@nginx_user@!%nginx_user!g %configs
subst s!@nginx_etc@!%nginx_etc!g %configs
subst s!@nginx_spool@!%nginx_spool!g %configs
subst s!@nginx_log@!%nginx_log!g %configs

mkdir -p %buildroot%_docdir/%name-%version
cp -a CHANGES CHANGES.ru %buildroot%_docdir/%name-%version/

%if_with uwsgi
install -pD -m644 uwsgi/uwsgi_params %buildroot%nginx_etc/
%endif

rm -rf %buildroot/html/

%files
%_initdir/*
%_sbindir/*
%dir %nginx_etc
%dir %nginx_etc/sites-enabled.d
%dir %nginx_etc/sites-available.d
%dir %nginx_etc/conf-enabled.d
%dir %nginx_etc/conf-available.d

%config(noreplace) %nginx_etc/sites-available.d/default.conf

%if_enabled rtmp
%nginx_etc/stat.xsl
%endif

# these are private; should also confirm to SPP (#12647)
%attr(0700,root,root) %dir %_lockdir/%name
%attr(1770,root,%nginx_group) %dir %nginx_spool/tmp
%attr(1770,root,%nginx_group) %dir %nginx_spool/tmp/client
%attr(1770,root,%nginx_group) %dir %nginx_spool/tmp/proxy
%attr(1770,root,%nginx_group) %dir %nginx_spool/tmp/fastcgi
%attr(1770,root,%nginx_group) %dir %nginx_spool/tmp/scgi
%attr(1770,root,%nginx_group) %dir %nginx_spool/tmp/uwsgi
%attr(1770,root,%nginx_group) %dir %nginx_spool
%attr(1770,root,%nginx_group) %dir %nginx_log
%config(noreplace) %nginx_etc/mime.types
%config(noreplace) %nginx_etc/nginx.conf
%config(noreplace) %nginx_etc/fastcgi.conf
%config(noreplace) %nginx_etc/scgi_params
%config(noreplace) %nginx_etc/uwsgi_params
%config(noreplace) %nginx_etc/fastcgi_params
%config(noreplace) %_sysconfdir/logrotate.d/%name
%config(noreplace) %_sysconfdir/sysconfig/%name
%config %_unitdir/%name.service
%nginx_etc/*.default
%nginx_etc/koi-win
%nginx_etc/koi-utf
%nginx_etc/win-utf
%_docdir/%name-%version
%if_with perl
%perl_vendor_archlib/nginx.pm
%perl_vendor_autolib/nginx
%endif
%if_with uwsgi
%config(noreplace) %nginx_etc/uwsgi_params
%endif

%pre
%_sbindir/groupadd -r -f %nginx_group ||:
%_sbindir/groupadd -r -f _webserver ||:
%_sbindir/useradd -r -g %nginx_group -G _webserver -d /dev/null -s /dev/null -n %nginx_user \
	2> /dev/null > /dev/null ||:

%post
sed -i 's/\(types_hash_bucket_size[[:space:]]*\)[[:space:]]32[[:space:]]*;[[:space:]]*$/\1 64;/' /etc/nginx/nginx.conf ||:
%post_service %name

%preun
%preun_service %name

%changelog
