# Disable tests because we can not increase build limits
%def_without tests

Name:           ninja-build
Version:        1.5.1
Release:        alt0.M70P.1
Summary:        A small build system with a focus on speed

Group:          Development/Tools
License:        ASL 2.0
URL:            http://martine.github.com/ninja/
#VCS:           git://github.com/martine/ninja.git
Source0:        %name-%{version}.tar
Source1:        ninja.vim

BuildRequires:  gcc-c++
BuildRequires:  re2c
BuildRequires:  asciidoc
BuildRequires:  xsltproc
BuildRequires:  docbook-style-xsl
BuildRequires:  libgtest-devel

%description
Ninja is a small build system with a focus on speed. It differs from
other build systems in two major respects: it is designed to have its
input files generated by a higher-level build system, and it is designed
to run builds as fast as possible.

%prep
%setup

%build
#CFLAGS="%{optflags}"
#export CFLAGS
./bootstrap.py --verbose -- --debug
./ninja -v manual
./ninja -v ninja_test

%check
%if_with tests
# workaround possible too low default limits
ulimit -n 2048
ulimit -u 2048
./ninja_test
%endif

%install
# TODO: Install ninja_syntax.py?
install -Dpm 755 ninja %buildroot%_bindir/ninja-build
install -Dpm 644 misc/bash-completion %buildroot%_sysconfdir/bash_completion.d/ninja-bash-completion
install -Dpm 644 misc/ninja-mode.el %buildroot%_datadir/emacs/site-lisp/ninja-mode.el
install -Dpm 644 misc/ninja.vim %buildroot%_datadir/vim/vimfiles/syntax/ninja.vim
install -Dpm 644 %SOURCE1 %buildroot%_datadir/vim/vimfiles/ftdetect/ninja.vim
install -Dpm 644 misc/zsh-completion %buildroot%_datadir/zsh/site-functions/_ninja


%files
%doc COPYING README doc/manual.html
%_bindir/ninja-build
# bash-completion does not own this
%_sysconfdir/bash_completion.d/
%_datadir/emacs/site-lisp/ninja-mode.el
%_datadir/vim/vimfiles/syntax/ninja.vim
%_datadir/vim/vimfiles/ftdetect/ninja.vim
# zsh does not have a -filesystem package
%_datadir/zsh/


%changelog
