Name: nmap
Version: 5.51
Release: alt1.1
Epoch: 20020501

Summary: Network exploration tool and security scanner
License: GPLv2
Group: Monitoring
Url: http://nmap.org/

%define srcname nmap-%version
# http://nmap.org/dist/%srcname.tar.bz2
Source: %srcname.tar
Source1: zenmap.pamd
Source2: zenmap.security

Patch0: nmap-5.51-owl-nse_ldflags.patch
Patch1: nmap-5.51-alt-owl-autoheader.patch
Patch2: nmap-5.51-alt-nsock-autoheader.patch
Patch3: nmap-5.51-alt-owl-drop-priv.patch
Patch4: nmap-5.51-alt-owl-dot-dir.patch
Patch5: nmap-5.51-alt-owl-fileexistsandisreadable.patch
Patch6: nmap-5.51-owl-warnings.patch
Patch7: nmap-5.51-owl-build.patch
Patch8: nmap-5.51-owl-nping-drop-priv.patch
Patch9: nmap-5.51-owl-nping-autoheader.patch
Patch10: nmap-5.51-alt-sctp_chunkhdr.patch
Patch11: nmap-5.51-alt-ncat-certs.patch
Patch12: nmap-5.51-alt-libdnet.patch
Patch13: nmap-5.51-alt-zenmap-desktop.patch
Patch14: nmap-5.51-rh-zenmap-locale.patch

%def_with liblua
%def_with ncat
%def_with ndiff
%def_with nping
%def_with zenmap

Requires: chrooted-resolv, libdnet >= 0:1.12-alt1
BuildRequires: gcc-c++, libcap-devel, libdnet-devel >= 0:1.12-alt1
BuildRequires: libpcap-devel >= 2:0.8, libpcre-devel, libssl-devel
%{?_with_liblua:BuildRequires: liblua5-devel}
%{?_with_ndiff:BuildRequires: python-devel}
%{?_with_zenmap:BuildRequires: libpam-devel python-devel}

%description
Nmap is an utility for network exploration or security auditing.
It supports ping scanning (determine which hosts are up), many port
scanning techniques, version detection (determine service protocols and
application versions listening behind ports), and TCP/IP fingerprinting
(remote host OS or device identification).  Nmap also offers flexible
target and port specification, decoy/stealth scanning, Sun RPC scanning,
and more.

%package -n zenmap
Summary: The GTK+ frontend for Nmap
Group: Monitoring
BuildArch: noarch
%_python_set_noarch
Requires: %name = %epoch:%version-%release

%description -n zenmap
This package includes zenmap, a GTK+ frontend for Nmap.

%prep
%setup -n %srcname
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
rm -r libdnet-stripped liblua libpcap libpcre
bzip2 -9 CHANGELOG

%build
for d in . nping; do
	pushd $d
	aclocal
	autoheader
	autoconf
	popd
done

export ac_cv_header_libiberty_h=no
%configure \
	%{subst_with liblua} \
	%{subst_with ncat} \
	%{subst_with ndiff} \
	%{subst_with nping} \
	%{subst_with zenmap} \
	--with-libdnet=/usr \
	--with-user=nmapuser \
	--with-chroot-empty=/var/empty \
	--with-chroot-resolv=/var/resolv \
	#
%make_build

%install
%makeinstall_std STRIP=:

rm %buildroot%_mandir/*/man1/nmap.*

%if_with zenmap
ln -s $(relative %_libexecdir/consolehelper/helper %_bindir/) \
	%buildroot%_bindir/zenmap-root
install -pD -m640 %_sourcedir/zenmap.pamd \
	%buildroot%_sysconfdir/pam.d/zenmap-root
install -pD -m640 %_sourcedir/zenmap.security \
	%buildroot%_sysconfdir/security/console.apps/zenmap-root
mkdir -p %buildroot%_liconsdir
ln -s ../../../../zenmap/pixmaps/zenmap.png %buildroot%_liconsdir/
%find_lang zenmap
rm %buildroot%_bindir/{nmapfe,uninstall_zenmap,xnmap}
rm %buildroot%_datadir/zenmap/su-to-zenmap.sh
%endif

%pre
/usr/sbin/groupadd -r -f nmapuser
/usr/sbin/useradd -r -g nmapuser -d /dev/null -s /dev/null -n nmapuser >/dev/null 2>&1 ||:

%files
%_bindir/nmap
%_datadir/nmap
%_man1dir/nmap.*
%if_with ncat
%_bindir/ncat
%_man1dir/ncat.*
%endif
%if_with ndiff
%_bindir/ndiff
%_man1dir/ndiff.*
%endif
%if_with nping
%_bindir/nping
%_man1dir/nping.*
%endif
%doc COPYING* CHANGELOG.bz2 docs/{README,nmap*.txt}

%if_with zenmap
%files -n zenmap -f zenmap.lang
%config(noreplace) %_sysconfdir/pam.d/zenmap-root
%config(noreplace) %_sysconfdir/security/console.apps/zenmap-root
%_bindir/zenmap*
%_datadir/zenmap
%_man1dir/zenmap.*
%_liconsdir/*
%_desktopdir/zenmap*.desktop
%python_sitelibdir/*
%endif

%changelog
