%define node_name      node
%define node_version  0.10.16
%define node_release   alt1
%define npmver 1.3.8

#we need ABI virtual provides where SONAMEs aren't enough/not present so deps
#break when binary compatibility is broken
%global nodejs_abi 0.10
# V8 presently breaks ABI at least every x.y release while never bumping SONAME,
# so we need to be more explicit until spot fixes that
%global v8_abi 3.15

%def_disable check

Name: %node_name
Version: %node_version
Release: %node_release
Summary: Evented I/O for V8 Javascript
Group: Development/Tools
License: MIT License
Url: http://nodejs.org/
Source: %name-%version.tar
Source7: nodejs_native.req.files
Patch: addon.gypi-alt-linkage-fixes.patch

BuildRequires: python-devel gcc-c++ openssl-devel zlib-devel libv8-3.15-devel libcares-devel gyp
BuildRequires: curl openssl
Provides: nodejs(engine) = %version
Provides: nodejs = %version-%release
Provides: node.js = %version-%release
Obsoletes: nodejs < %version-%release
Obsoletes: node.js < %version-%release

Provides: nodejs(abi) = %{nodejs_abi}
Provides: nodejs(v8-abi) = %{v8_abi}

%add_python_req_skip TestCommon
%add_findreq_skiplist %{_datadir}/node/sources/*

%description
Node.js is a server-side JavaScript environment that uses an asynchronous
event-driven model.  Node's goal is to provide an easy way to build scalable
network programs.

%package devel
Summary:        Devel package for Node.js
Group:          Development/Other
License:        GPL
BuildArch:      noarch
Provides:	nodejs-devel = %version-%release
Requires:	%node_name = %node_version
Requires:       gcc-c++ openssl-devel zlib-devel libv8-devel = %{v8_abi} libcares-devel
Conflicts:      libuv-devel

%description devel
Node.js header and build tools

%package -n npm
Version: 	%npmver
Group:		Development/Tools
Summary:	A package manager for node
License:	MIT License
Requires:	node
BuildArch:	noarch
#Requires:	%node_name-devel = %node_version-%node_release
Requires:	%node_name = %node_version-%node_release

%description -n npm
npm is a package manager for node. You can use it to install and publish your
node programs. It manages dependencies and does other cool stuff.

%prep
%setup -q
%patch -p1

%build
./configure --no-ssl2 \
    --prefix=%_prefix \
    --shared-zlib \
    --shared-openssl \
    --shared-openssl-includes=%_includedir \
    --shared-v8 \
    --shared-v8-includes=%_includedir

mkdir -p ./tools/doc/node_modules/.bin
ln -s ../marked/bin/marked ./tools/doc/node_modules/.bin/marked

%make_build CXXFLAGS="%{optflags}" CFLAGS="%{optflags}"
%make doc
#%make jslint

%check
%make_build test

%install
%makeinstall_std
install -d %buildroot%_sysconfdir/profile.d
echo 'export NODE_PATH="%{_libexecdir}/node_modules;%{_libexecdir}/node_altmodules"' >%buildroot%_sysconfdir/profile.d/node.sh
echo 'setenv NODE_PATH %{_libexecdir}/node_modules;%{_libexecdir}/node_altmodules' >%buildroot%_sysconfdir/profile.d/node.csh
chmod 0755 %buildroot%_sysconfdir/profile.d/*

#install development headers
mkdir -p %{buildroot}%{_includedir}/node/{uv-private,}
cp -p src/*.h %{buildroot}%{_includedir}/node
cp -p deps/uv/include/*.h %{buildroot}%{_includedir}/node
cp -p deps/uv/include/uv-private/*.h %{buildroot}%{_includedir}/node/uv-private

#node-gyp needs common.gypi too
mkdir -p %{buildroot}%{_datadir}/node
cp -p common.gypi %{buildroot}%{_datadir}/node
#tar -xf %{SOURCE0} --directory=%{buildroot}%{_datadir}/node/sources

# ensure Requires are added to every native module that match the Provides from
# the nodejs build in the buildroot
install -Dpm0755 %{SOURCE7} %buildroot%_rpmlibdir/nodejs_native.req.files
cat << EOF > %buildroot%_rpmlibdir/nodejs_native.req
#!/bin/sh
echo 'nodejs(abi) = %nodejs_abi'
echo 'nodejs(v8-abi) = %v8_abi'
EOF
chmod 0755 %buildroot%_rpmlibdir/nodejs_native.req

%files
%doc AUTHORS ChangeLog LICENSE README.md out/doc
%_bindir/node
%dir %_libexecdir/node_modules/
%dir %_datadir/node
%_man1dir/*
%_sysconfdir/profile.d/*

%files devel
%_includedir/node
%_datadir/node/common.gypi
%_rpmlibdir/nodejs_native.req*
#%_datadir/node/sources

%files -n npm
%_bindir/npm
%_libexecdir/node_modules/npm
%exclude %_libexecdir/node_modules/npm/node_modules/node-gyp/gyp/tools/emacs

%changelog
