Name: nsd
Version: 3.2.10
Release: alt1

Summary: Fast and lean authoritative DNS Name Server
License: BSD
Group: System/Servers

URL: http://www.nlnetlabs.nl/projects/nsd/
Source: http://www.nlnetlabs.nl/downloads/nsd/nsd-%version.tar.gz
Source1: nsd.conf
Source2: nsd.init

# Automatically added by buildreq on Sat Nov 26 2011
BuildRequires: flex libssl-devel libwrap-devel

%description
NSD is a complete implementation of an authoritative DNS name server.

%prep
%setup

%build
%configure --enable-bind8-stats --enable-checking --enable-nsec3 \
	--with-user=_nsd \
	--with-pidfile=%_runtimedir/nsd/nsd.pid \
	--with-difffile=%_localstatedir/nsd/ixfr.db \
	--with-dbfile=%_localstatedir/nsd/nsd.db \
	--with-xfrdfile=%_localstatedir/nsd/xfrd.state

%make_build

%install
%makeinstall_std
install -pDm644 %SOURCE1 %buildroot/etc/nsd/nsd.conf
install -pDm755 %SOURCE2 %buildroot%_initdir/nsd
install -d %buildroot/var/run/nsd
install -d %buildroot%_localstatedir/nsd


%pre
/usr/sbin/groupadd -r -f _nsd
/usr/sbin/useradd -r -g _nsd -d /etc/nsd -s /sbin/nologin -n -c "Domain Name Server" _nsd >/dev/null 2>&1 ||:

%preun
%preun_service nsd

%post
%post_service nsd

%files
%dir /etc/nsd
%config(noreplace) /etc/nsd/nsd.conf
%config %_initdir/nsd
%_sbindir/*
%attr(0755,_nsd,_nsd) %dir /var/run/nsd
%attr(0755,_nsd,_nsd) %dir %_localstatedir/nsd
%_man5dir/*
%_man8dir/*
%exclude /etc/nsd/nsd.conf.sample
%doc nsd.conf.sample doc/{CREDITS,ChangeLog,LICENSE,NSD*,README,RELNOTES}

%changelog
