Summary:	Netscape Network Security Services(NSS) (compat with chromium)
Name:		nss-compat
Version:	3.20.1
Release:	alt0.M70P.2
License:	MPL/GPL/LGPL
Group:		System/Libraries
Url:		http://www.mozilla.org/projects/security/pki/nss
Packager:	Andrey Cherepanov <cas@altlinux.org>

Source0:	nss-%version.tar
Source1:	nss.pc.in
Source2:	nss-config.in
Source3:	nss-alt-ssl-addon-certs.txt
Source4:	nss-db-%version.tar
Source5:	setup-nsssysinit.sh
Source6:	system-pkcs11.txt
Source7:	nss-pem-%version.tar

Patch0:		nss_with_system_nspr.patch
Patch2:		nss-no-rpath.patch
Patch3:		nss-use-sqlite.patch
Patch4:		nss-use-mozsqlite.patch
Patch5:		nss-fix-objdir.patch

# Fedora patches
Patch10:	nss-enable-pem.patch

BuildRequires:	chrpath zlib-devel libsqlite3-devel
BuildRequires:	libnspr-devel >= 4.10.8
Requires:	libnspr       >= 4.10.8
# Use nss-db from nss
Requires:	libnss

%description
Network Security Services (NSS) is a set of libraries designed
to support cross-platform development of security-enabled server
applications. Applications built with NSS can support SSL v2
and v3, TLS, PKCS #5, PKCS #7, PKCS #11, PKCS #12, S/MIME,
X.509 v3 certificates, and other security standards.  See:
http://www.mozilla.org/projects/security/pki/nss/overview.html

%package -n lib%name
Summary:	Netscape Network Security Services(NSS) (compat with chromium)
Group:		System/Libraries

Provides:	%name = %version-%release

%description -n lib%name
Network Security Services (NSS) is a set of libraries designed
to support cross-platform development of security-enabled server
applications. Applications built with NSS can support SSL v2
and v3, TLS, PKCS #5, PKCS #7, PKCS #11, PKCS #12, S/MIME,
X.509 v3 certificates, and other security standards.  See:
http://www.mozilla.org/projects/security/pki/nss/overview.html
(compat with chromium)

%package -n lib%name-devel
Summary:	NSS development kit (compat with chromium)
Group:		Development/C
Requires:	lib%name = %version-%release

Provides:	%name-devel        = %version-%release
Provides:	%name-pkcs11-devel = %version-%release

%description -n lib%name-devel
NSS development kit (compat with chromium)

%prep
%setup -q -n nss-%version
tar xf %SOURCE7
#patch0 -p0
%patch2 -p0
#patch3 -p0
#patch4 -p0
%patch5 -p0

%patch10 -p0

%build
export BUILD_OPT=1 
export NS_USE_GCC=1
export NSS_ENABLE_ECC=1
export NSS_USE_SYSTEM_SQLITE=1
export USE_SYSTEM_ZLIB=1
export PKG_CONFIG_ALLOW_SYSTEM_LIBS=1
export PKG_CONFIG_ALLOW_SYSTEM_CFLAGS=1
export NSPR_INCLUDE_DIR=/usr/include/nspr
export NSPR_LIB_DIR=%_libdir

# Generate symbolic info for debuggers
export XCFLAGS=$RPM_OPT_FLAGS

%ifarch x86_64 aarch64
export USE_64=1
%endif

# additional CA certificates
cat %SOURCE3 >> nss/lib/ckfw/builtins/certdata.txt

make -C nss/coreconf
make -C nss/coreconf platform 2>/dev/null |grep '^Linux' >destdir
make -C nss/lib/dbm
make -C nss

%install
mkdir -p %buildroot{%_libdir/%name,%_libdir/pkgconfig,%_includedir/%name}

# Get some variables
DESTDIR="$(head -1 destdir)"
NSPR_VERSION="$(nspr-config --version)"
nss_h="nss/lib/nss/nss.h"
NSS_VMAJOR="$(sed -ne 's,^#define[[:space:]]\+NSS_VMAJOR[[:space:]]\+,,p' "$nss_h")"
NSS_VMINOR="$(sed -ne 's,^#define[[:space:]]\+NSS_VMINOR[[:space:]]\+,,p' "$nss_h")"
NSS_VPATCH="$(sed -ne 's,^#define[[:space:]]\+NSS_VPATCH[[:space:]]\+,,p' "$nss_h")"

# Install NSS libraries 
cd dist
cp -aL "$DESTDIR"/lib/*.so* "$DESTDIR"/lib/*.chk %buildroot%_libdir/%name

# Install NSS headers
cd public
cp -aL nss/* %buildroot%_includedir/%name

# Install NSS utils
sed -e "s,@libdir@,%_libdir/%name,g" \
    -e "s,@prefix@,%_prefix,g" \
    -e "s,@exec_prefix@,%_prefix,g" \
    -e "s,@includedir@,%_includedir/%name,g" \
    -e "s,@NSPR_VERSION@,$NSPR_VERSION,g" \
    -e "s,@NSS_VERSION@,%version,g" \
    -e "s,^Libs: ,Libs: -Wl\,-rpath=\${libdir} -L\${libdir} ,g" \
	%SOURCE1 > %buildroot/%_libdir/pkgconfig/%name.pc

# Add real RPATH
find "%buildroot%_bindir" "%buildroot%_libdir" -type f | 
while read f; do
  file "$f" | grep -qs ELF || continue
  if chrpath -l "$f" | fgrep -qs "RPATH="; then
    chrpath -d "$f"
  fi
done

%files -n lib%name
%_libdir/%name/*.so*
%_libdir/%name/*.chk

%files -n lib%name-devel
%dir %_includedir/%name
%_includedir/%name
%_libdir/pkgconfig/%name.pc

%changelog
