%define _unpackaged_files_terminate_build 1
%define soversion 10

Name: ntfsprogs
Version: 2.0.0
Release: alt8.1.qa1

Summary: NTFS filesystem utilities
License: GPLv2+
Group: System/Kernel and hardware

Url: http://linux-ntfs.org/
Source0: %name-%version.tar
Patch1: %name-2.0.0-alt-libgnutls-pkg-config.patch
Patch2: %name-1.13.1-pld-stdarg_h-required.patch

Packager: Andrey Rahmatullin <wrar@altlinux.ru>

BuildPreReq: gcc-c++ libfuse-devel >= 2.6.1 libuuid-devel pkgconfig
# crypto
BuildPreReq: libgnutls-devel >= 1.4.4 libgcrypt-devel >= 1.2.2 libconfig-devel >= 1.0.1

%description
The goals of the Linux-NTFS project are to develop reliable and full
feature access to NTFS by the Linux kernel driver, and by a user space
filesystem (ntfsmount), and to provide a wide collection of NTFS
utilities (ntfsprogs) and a developer's library (libntfs) for other
GPLed programs.

This package contains the following utilities:

   mkntfs : create an NTFS file system
   ntfscat : print NTFS files and streams on the standard output
   ntfsclone : efficiently clone, image, restore or rescue an NTFS
   ntfscluster : identify files in a specified region of an NTFS volume
   ntfscmp : compare two NTFS filesystems and tell the differences
   ntfscp : copy file to an NTFS volume
   ntfsfix : fix common errors and force Windows to check NTFS
   ntfsinfo : dump a file's attributes
   ntfslabel : display/change the label on an ntfs file system
   ntfsls : list directory contents on an NTFS filesystem
   ntfsresize : resize an NTFS filesystem without data loss
   ntfsundelete : recover a deleted file from an NTFS volume

%package -n fuse-ntfs
Summary: NTFS FUSE mount module
Group: System/Kernel and hardware
Conflicts: ntfsprogs = 1.11.0-alt1
%description -n fuse-ntfs
The goals of the Linux-NTFS project are to develop reliable and full
feature access to NTFS by the Linux kernel driver, and by a user space
filesystem (ntfsmount), and to provide a wide collection of NTFS
utilities (ntfsprogs) and a developer's library (libntfs) for other
GPLed programs.

This package contains NTFS FUSE mount module and ntfsmount helper.

%package -n libntfs%soversion
Summary: NTFS filesystem libraries
Group: System/Libraries
Provides: libntfs = %version-%release
%description -n libntfs%soversion
The goals of the Linux-NTFS project are to develop reliable and full
feature access to NTFS by the Linux kernel driver, and by a user space
filesystem (ntfsmount), and to provide a wide collection of NTFS
utilities (ntfsprogs) and a developer's library (libntfs) for other
GPLed programs.

This package contains NTFS filesystem libraries.

%package -n libntfs-devel
Summary: NTFS filesystem header files
Group: Development/C
Requires: libntfs%soversion = %version-%release
%description -n libntfs-devel
The goals of the Linux-NTFS project are to develop reliable and full
feature access to NTFS by the Linux kernel driver, and by a user space
filesystem (ntfsmount), and to provide a wide collection of NTFS
utilities (ntfsprogs) and a developer's library (libntfs) for other
GPLed programs.

This package contains NTFS filesystem header files.

%prep
%setup
%patch1 -p2
%patch2 -p1
%autoreconf

%build
%configure \
	--disable-static \
	--disable-gnome-vfs

sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build

%install
%makeinstall_std
rm -f doc/Makefile*
rm -f %buildroot%_includedir/ntfs/gnome-vfs*.h
rm -f %buildroot%_man8dir/libntfs-gnomevfs.*

%files
%_bindir/ntfscat
%_bindir/ntfscluster
%_bindir/ntfscmp
%_bindir/ntfsfix
%_bindir/ntfsinfo
%_bindir/ntfsls
%_sbindir/mkntfs
%_sbindir/ntfsclone
%_sbindir/ntfscp
%_sbindir/ntfslabel
%_sbindir/ntfsresize
%_sbindir/ntfsundelete
/sbin/mkfs.ntfs
%_man8dir/libntfs.*
%_man8dir/mkfs.ntfs.*
%_man8dir/mkntfs.*
%_man8dir/ntfscat.*
%_man8dir/ntfscmp.*
%_man8dir/ntfsclone.*
%_man8dir/ntfscluster.*
%_man8dir/ntfscp.*
%_man8dir/ntfsfix.*
%_man8dir/ntfsinfo.*
%_man8dir/ntfslabel.*
%_man8dir/ntfsls.*
%_man8dir/ntfsprogs.*
%_man8dir/ntfsresize.*
%_man8dir/ntfsundelete.*
%doc AUTHORS CREDITS ChangeLog NEWS README TODO.* doc/

%files -n libntfs%soversion
%_libdir/libntfs.so.*

%files -n fuse-ntfs
%_bindir/ntfsmount
/sbin/mount.fuse.ntfs
/sbin/mount.ntfs-fuse
%_man8dir/ntfsmount.*
%_man8dir/mount.fuse.ntfs.*
%_man8dir/mount.ntfs-fuse.*

%files -n libntfs-devel
%_libdir/libntfs.so
%dir %_includedir/ntfs
%_includedir/ntfs/*.h


%changelog
