%add_findreq_skiplist %_bindir/nvidia-bug-report.sh

%define tbname         NVIDIA-Linux-x86
%ifarch x86_64
%define tbname         NVIDIA-Linux-x86_64
%endif
%define virtual_pkg_name NVIDIA_GLX
%define bin_pkg_name     nvidia_glx
%define module_name    nvidia
%define tbsuffix pkg0

# version-release
%define nv_version 96
%define nv_release 43
%define nv_minor 23
%define pkg_rel alt51
%define set_gl_nvidia_ver 0.6.5
%def_enable kernelsource

%define verrel %{nv_version}.%{nv_release}.%{nv_minor}
%define module_version	%nv_version%nv_release%nv_minor
%define module_release	%pkg_rel

%define myGroup System/Kernel and hardware
%define mySummary NVIDIA drivers and OpenGL libraries for XOrg X-server
%define mySummaryRu Драйверы NVIDIA и библиотеки OpenGL для Х-сервера XOrg
%define myUrl http://www.nvidia.com
%define myVendor NVIDIA Corp.
%define myLicense NVIDIA

%define mods /modules
%define exts /modules/extensions
%define drvs /modules/drivers
%define lib_sym_dir %_sysconfdir/X11/%_lib
%define nv_lib_sym_dir %{lib_sym_dir}_nvidia
%define nv_lib32_sym_dir %_sysconfdir/X11/lib_nvidia
%define xdrv_d /usr/libexec/X11/drv.d
%define xdrv_d_old /usr/X11R6/lib/drv.d
%define xdrv_pre_d /usr/libexec/X11/drvpre.d
%define xdrv_pre_d_old /usr/X11R6/lib/drvpre.d

%define xinf_dir %_datadir/hwdatabase/videoaliases/
%define nv_workdirdir %_localstatedir/nvidia
%define tls_lib_dir %_libdir
%define x11_lib_dir %_libdir
%define x11_lib_old /usr/X11R6/lib
%define x11_mod_dir /usr/%_lib/X11%mods
%define x11_mod_old /usr/X11R6/%_lib%mods
%define x11_drv_dir /usr/%_lib/X11%drvs
%define x11_drv_old /usr/%_lib/X11%drvs
%define x11_ext_dir /usr/%_lib/X11%exts
%define x11_ext_old /usr/X11R6/%_lib%exts
%define nv_lib_dir_prefix %_libdir/nvidia_
%define nv_lib_dir_prefix_old /usr/X11R6/%_lib/nvidia_
%define nv_lib_dir %nv_lib_dir_prefix%nv_version.%nv_release.%nv_minor
%add_findprov_lib_path %nv_lib_dir/*
%add_findreq_skiplist %_libdir/*
%add_findreq_skiplist %x11_lib_dir/*
%add_findreq_skiplist %x11_lib_old/*


Name: %{bin_pkg_name}_src_%{nv_version}.%{nv_release}.%{nv_minor}
Version: %nv_version.%nv_release.%nv_minor
Release: %pkg_rel

Source0: null
Source201: ftp://download.nvidia.com/XFree86/Linux-x86/%verrel/NVIDIA-Linux-x86-%verrel-%tbsuffix.run
Source202: ftp://download.nvidia.com/XFree86/Linux-x86_64/%verrel/NVIDIA-Linux-x86_64-%verrel-%tbsuffix.run

Source1: set_gl_nvidia-%set_gl_nvidia_ver.tar.bz2
Source2: nvidia.xinf
Source100: nvidia_create_xinf

BuildRequires: kernel-build-tools libsysfs-devel
ExclusiveArch: %ix86 x86_64
#ExcludeArch: ppc64 x86_64 ppc s390 s390x ia64



Group: %myGroup
Summary: %mySummary
Summary(ru_RU.UTF-8): %mySummaryRu
Url: %myUrl
License: %myLicense
%description
Sources for %{bin_pkg_name}_%{version} package



%package -n %{bin_pkg_name}_common
Conflicts: xorg-x11-mesagl <= 6.8.2-alt7
Requires(post): x11presetdrv
#
Group: %myGroup
Summary: This is common package for usability NVIDIA drivers.
Summary(ru_RU.UTF-8): Пакет для совместимости драйверов NVIDIA.
Url: %myUrl
License: %myLicense
# old
Conflicts: nvidia_glx_100.14.19-100.14.19 <= alt40
Conflicts: nvidia_glx_169.07-169.07 <= alt40
Conflicts: nvidia_glx_169.09-169.09 <= alt41
Conflicts: nvidia_glx_71.86.01-71.86.01 <= alt36
Conflicts: nvidia_glx_96.43.01-96.43.01 <= alt36
#
Conflicts: nvidia_glx_71.86.04-71.86.04 <= alt37
Conflicts: nvidia_glx_71.86.06-71.86.06 <= alt38
Conflicts: nvidia_glx_96.43.05-96.43.05 <= alt37
Conflicts: nvidia_glx_96.43.07-96.43.07 <= alt38
Conflicts: nvidia_glx_169.12-169.12 <= alt44
Conflicts: nvidia_glx_173.14.12-173.14.12 <= alt47
#
%description -n %{bin_pkg_name}_common
This is common package for NVIDIA drivers.
#
%description -n %{bin_pkg_name}_common -l ru_RU.UTF-8
Этот пакет нужен для совместимости при отсутствии
одной из компонент драйверов для NVIDIA.



%package -n %{bin_pkg_name}_%{version}
PreReq: %{bin_pkg_name}_common >= %version
Requires(post): x11presetdrv
#Requires: libGLwrapper
#Provides: libGL
Provides: %virtual_pkg_name = %version-%release
#Provides: x11-driver-nvidia = %version-%release
Obsoletes: %virtual_pkg_name < %version-%release
#
Group: %myGroup
Summary: %mySummary
Summary(ru_RU.UTF-8): %mySummaryRu
Url: %myUrl
License: %myLicense
#
%description -n %{bin_pkg_name}_%{version}
NVIDIA XFree86 4.x server drivers and OpenGL libraries for GeForce/Quadro
based video cards. Older RIVA 128 and RIVA TNT/TNT2 based video cards are
supported by the server module shipping with XOrg, nv_drv.so. You
should install this package if you have one of the newer cards.

You must also install the NVIDIA_kernel package for your current kernel
if you want NVIDIA module and OpenGL libraries for XOrg X server.
#
%description -n %{bin_pkg_name}_%{version} -l ru_RU.UTF-8
Драйверы и OpenGL-библиотеки для Х-сервера X11 и видеокарт NVIDIA на базе
GeForce/Quadro. Более ранние версии видеокарт на базе RIVA 128 и RIVA TNT/TNT2
поддерживаются модулем nv_drv.so, входящим в состав сервера XOrg.
Если вы имеете одну из этих новых видеокарт, то вам желательно установить данный
пакет.

Если вы желаете использовать модули NVIDIA и библиотеки OpenGL для Х-сервера XOrg,
то вы должны также установить пакет NVIDIA_kernel для текущего ядра.

%package -n kernel-source-%module_name-%module_version
Group: Development/Kernel
Summary: Linux %module_name modules sources
License: %myLicense
Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>
#
%description -n kernel-source-%module_name-%module_version
%module_name modules sources for Linux kernel

%package -n %{bin_pkg_name}-devel
Group: Development/C
Summary: Development files for NVIDIA OpenGL
License: %myLicense
#
%description -n %{bin_pkg_name}-devel
Development files for NVIDIA OpenGL

%prep
%setup -T -c -n %tbname-%verrel-%tbsuffix
rm -rf %_builddir/%tbname-%verrel-%tbsuffix
cd %_builddir
%ifarch x86_64
sh %SOURCE202 -x
%else
sh %SOURCE201 -x
%endif
cd %tbname-%verrel-%tbsuffix
tar xvfj %SOURCE1
pushd set_gl_nvidia*
cp settings.h.in settings.h
subst "s|@DEFAULT_VERSION@|%version|" settings.h
subst "s|@LIB_SYML_DIR@|%lib_sym_dir|" settings.h
subst "s|@NV_LIB_SYML_DIR@|%nv_lib_sym_dir|" settings.h
subst "s|@TLS_LIB_DIR@|%tls_lib_dir|" settings.h

subst "s|@XLIB_DIR@|%x11_lib_dir|" settings.h
subst "s|@XLIB_DIR_OLD@|%x11_lib_old|" settings.h

subst "s|@XMOD_DIR@|%x11_mod_dir|" settings.h
subst "s|@XMOD_DIR_OLD@|%x11_mod_old|" settings.h

subst "s|@XDRV_DIR@|%x11_drv_dir|" settings.h
subst "s|@XDRV_DIR_OLD@|%x11_drv_old|" settings.h

subst "s|@XEXT_DIR@|%x11_ext_dir|" settings.h
subst "s|@XEXT_DIR_OLD@|%x11_ext_old|" settings.h

subst "s|@NV_DRV_DIR_PREFIX@|%nv_lib_dir_prefix|" settings.h
subst "s|@NV_DRV_DIR_PREFIX_OLD@|%nv_lib_dir_prefix_old|" settings.h

subst "s|@XINF_DIR@|%xinf_dir|" settings.h
popd

pushd usr/src/nv/
rm -rf precompiled
popd


%build
#make OPTFLAGS="%optflags -Wl,--hash-style=sysv" -C set_gl_nvidia*
make OPTFLAGS="%optflags" -C set_gl_nvidia*
strip set_gl_nvidia*/nvidia
strip set_gl_nvidia*/nvidia_preset
>nvidianull.c
gcc %optflags -c nvidianull.c -o nvidianull.o
#ld --hash-style=sysv --shared nvidianull.o -o libnvidianull.so
ld --shared nvidianull.o -o libnvidianull.so
strip libnvidianull.so


%install
%set_verify_elf_method textrel=relaxed
%brp_strip_none %_libdir/*
%brp_strip_none %nv_lib_dir/*

soname()
{
    readelf -a $1| grep SONAME| sed 's/.*\[//'| sed 's/\].*//'
}

%__mkdir_p %buildroot/%_sbindir
%__mkdir_p %buildroot/%tls_lib_dir
%__mkdir_p %buildroot/%nv_lib_dir
%__mkdir_p %buildroot/%x11_mod_dir
#%__mkdir_p %buildroot/%x11_mod_old
%__mkdir_p %buildroot/%x11_drv_dir
#%__mkdir_p %buildroot/%x11_drv_old
%__mkdir_p %buildroot/%x11_ext_dir
#%__mkdir_p %buildroot/%x11_ext_old
%__mkdir_p %buildroot/%lib_sym_dir
%__mkdir_p %buildroot/%nv_lib_sym_dir
%__mkdir_p %buildroot/%nv_lib32_sym_dir
%__mkdir_p %buildroot/%xdrv_d
#%__mkdir_p %buildroot/%xdrv_d_old
%__mkdir_p %buildroot/%xdrv_pre_d
%__mkdir_p %buildroot/%xinf_dir
%__mkdir_p %buildroot/%nv_workdirdir


%__install -m 0755 set_gl_nvidia*/nvidia %buildroot/%xdrv_d/nvidia
#%__ln_s ../../../..%xdrv_d/nvidia %buildroot/%xdrv_d_old/nvidia

%__install -m 0755 set_gl_nvidia*/nvidia_preset %buildroot/%xdrv_pre_d/nvidia

%__install -m 0755 libnvidianull.so %buildroot/%x11_lib_dir/

%__ln_s %nv_lib_dir/nvidia.xinf %buildroot/%nv_lib_sym_dir/nvidia.xinf
%__ln_s %nv_lib_dir/nvidia.xinf %buildroot/%xinf_dir/nvidia-%version.xinf
%__install -m 0644 %SOURCE2 %buildroot/%nv_lib_dir/nvidia.xinf

[ -f usr/X11R6/lib/%drvs/nvidia_drv.o ] && \
%__install -m 0644 usr/X11R6/lib/%drvs/nvidia_drv.o      %buildroot/%nv_lib_dir/
[ -f usr/X11R6/lib/%drvs/nvidia_drv.so ] && \
%__install -m 0644 usr/X11R6/lib/%drvs/nvidia_drv.so      %buildroot/%nv_lib_dir/

[ -f usr/X11R6/lib/%mods/libnvidia-wfb.so.%version ] && \
%__install -m 0644 usr/X11R6/lib/%mods/libnvidia-wfb.so.%version %buildroot/%nv_lib_dir/libwfb.so

%__install -m 0644 usr/X11R6/lib/%exts/libglx.so.%version %buildroot/%nv_lib_dir/libglx.so
%__ln_s libglx.so %buildroot/%nv_lib_dir/libglx.a

%__install -m 0644 usr/lib/libGL.so.%version  %buildroot/%nv_lib_dir/libGL.so

%__install -m 0644 usr/lib/libGLcore.so.%version %buildroot/%nv_lib_dir/libGLcore.so

%__install -m 0644 usr/X11R6/lib/libXvMCNVIDIA.so.%version %buildroot/%nv_lib_dir/libXvMCNVIDIA.so
%__ln_s libXvMCNVIDIA.so %buildroot/%nv_lib_dir/libNVIDIAXvMC.so

%__install -m 0644 usr/lib/libnvidia-cfg.so.%version %buildroot/%nv_lib_dir/libnvidia-cfg.so
%__install -m 0644 usr/lib/libnvidia-tls.so.%version %buildroot/%nv_lib_dir/libnvidia-tls.so
%__install -m 0644 usr/bin/tls_test %buildroot/%nv_lib_dir/tls_test
%__install -m 0644 usr/bin/tls_test_dso.so %buildroot/%nv_lib_dir/tls_test_dso.so
/sbin/ldconfig -n %buildroot/%nv_lib_dir
%__install -m 0644 usr/lib/tls/libnvidia-tls.so.%version %buildroot/%nv_lib_dir/libnvidia-tls-tls.so
%__ln_s libnvidia-tls-tls.so %buildroot/%nv_lib_dir/libnvidia-tls-tls.so.1

[ -f usr/X11R6/lib/%drvs/nvidia_drv.o ] && \
%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_lib_sym_dir/nvidia_drv.o
[ -f usr/X11R6/lib/%drvs/nvidia_drv.so ] && \
%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_lib_sym_dir/nvidia_drv.so
%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_lib_sym_dir/`soname %buildroot/%nv_lib_dir/libGLcore.so`
%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_lib_sym_dir/`soname %buildroot/%nv_lib_dir/libNVIDIAXvMC.so`
%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_lib_sym_dir/libNVIDIAXvMC.so
%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_lib_sym_dir/`soname %buildroot/%nv_lib_dir/libnvidia-tls.so`
%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_lib_sym_dir/`soname %buildroot/%nv_lib_dir/libnvidia-cfg.so`
%if "%_lib" == "lib64"
%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_lib32_sym_dir/`soname %buildroot/%nv_lib_dir/libGLcore.so`
%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_lib32_sym_dir/`soname %buildroot/%nv_lib_dir/libNVIDIAXvMC.so`
%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_lib32_sym_dir/libNVIDIAXvMC.so
%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_lib32_sym_dir/`soname %buildroot/%nv_lib_dir/libnvidia-tls.so`
%endif

if [ -f usr/X11R6/lib/%drvs/nvidia_drv.o ] ; then
%__ln_s ../../../../..%nv_lib_sym_dir/nvidia_drv.o %buildroot/%x11_drv_dir/nvidia_drv.o
#%__ln_s ../../../../..%nv_lib_sym_dir/nvidia_drv.o %buildroot/%x11_drv_old/nvidia_drv.o
fi
if [ -f usr/X11R6/lib/%drvs/nvidia_drv.so ] ; then
%__ln_s ../../../../..%nv_lib_sym_dir/nvidia_drv.so %buildroot/%x11_drv_dir/nvidia_drv.so
#%__ln_s ../../../../..%nv_lib_sym_dir/nvidia_drv.so %buildroot/%x11_drv_old/nvidia_drv.so
fi
%__ln_s ../..%nv_lib_sym_dir/`soname %buildroot/%nv_lib_dir/libGLcore.so` \
    %buildroot/%x11_lib_dir/`soname %buildroot/%nv_lib_dir/libGLcore.so`
%__ln_s ../..%nv_lib_sym_dir/`soname %buildroot/%nv_lib_dir/libNVIDIAXvMC.so` \
    %buildroot/%x11_lib_dir/`soname %buildroot/%nv_lib_dir/libNVIDIAXvMC.so`
%__ln_s ../..%nv_lib_sym_dir/libNVIDIAXvMC.so \
    %buildroot/%x11_lib_dir/libNVIDIAXvMC.so
SONAME=`soname %buildroot/%nv_lib_dir/libnvidia-cfg.so`
%__ln_s ../..%nv_lib_sym_dir/$SONAME %buildroot/%x11_lib_dir/$SONAME
SONAME=`soname %buildroot/%nv_lib_dir/libnvidia-tls.so`
%__ln_s ../..%nv_lib_sym_dir/$SONAME %buildroot/%tls_lib_dir/$SONAME

# kernel-source install
%__rm -rf kernel-source-%module_name-%module_version/
%__mkdir_p %buildroot/%_usrsrc/kernel/sources/ kernel-source-%module_name-%module_version/
%__cp -ar usr/src/nv/* kernel-source-%module_name-%module_version/
%__cp LICENSE kernel-source-%module_name-%module_version/
tar -c kernel-source-%module_name-%module_version | bzip2 -c > \
    %buildroot%_usrsrc/kernel/sources/kernel-source-%module_name-%module_version.tar.bz2

# install headers
%__mkdir_p %buildroot/%_includedir/nvidia
%__cp -ar usr/include/GL %buildroot/%_includedir/nvidia

# install scripts
mkdir -p %buildroot/%_bindir
install -m 0755 usr/bin/nvidia-bug-report.sh %buildroot/%_bindir/


%post -n %{bin_pkg_name}_%{version}
# switch nvidia driver and libraries
if [ -z "$DURING_INSTALL" ]; then
    X11PRESETDRV=`which x11presetdrv 2>/dev/null`
    if [ -n "$X11PRESETDRV" ]; then
	$X11PRESETDRV ||:
    else
	echo "Warning! x11presetdrv program not found!" >&2
    fi
    X11SETUPDRV=`which x11setupdrv 2>/dev/null`
    if [ -n "$X11SETUPDRV" ]; then
	$X11SETUPDRV ||:
    fi
fi

%postun -n %{bin_pkg_name}_%{version}
X11SETUPDRV=`which x11setupdrv 2>/dev/null`
if [ -n "$X11SETUPDRV" ]; then
    $X11SETUPDRV ||:
fi

%post -n %{bin_pkg_name}_common
if [ -z "$DURING_INSTALL" ]; then
    X11PRESETDRV=`which x11presetdrv 2>/dev/null`
    if [ -n "$X11PRESETDRV" ]; then
	$X11PRESETDRV ||:
    else
	echo "Warning! x11presetdrv program not found!" >&2
    fi
    X11SETUPDRV=`which x11setupdrv 2>/dev/null`
    if [ -n "$X11SETUPDRV" ]; then
	$X11SETUPDRV ||:
    fi
fi


%files -n %{bin_pkg_name}_%{version}
%doc LICENSE
%doc usr/share/doc/*
#
%dir %nv_lib_dir
%nv_lib_dir/nvidia_drv.*
%nv_lib_dir/libglx.*
%nv_lib_dir/libGL.so*
%nv_lib_dir/libGLcore.so*
%nv_lib_dir/lib*XvMC*.so*
%nv_lib_dir/libnvidia-tls.so*
%nv_lib_dir/libnvidia-tls-tls.so*
%nv_lib_dir/libnvidia-cfg.so*
%attr(0755,root,root) %nv_lib_dir/tls_test
%nv_lib_dir/tls_test*.so
#%nv_lib_dir/libwfb.so
#%nv_lib_dir/libnvidia-wfb.so*
%nv_lib_dir/nvidia.xinf
%xinf_dir/nvidia-%version.xinf

%if 0
%files -n %{bin_pkg_name}_common
%_bindir/nvidia-bug-report.sh
%xdrv_pre_d/nvidia
%xdrv_d/nvidia
#%xdrv_d_old/nvidia
%x11_lib_dir/libnvidianull.so
%dir %nv_lib_sym_dir/
#
%nv_lib_sym_dir/nvidia_drv.*
%x11_drv_dir/nvidia_drv.*
#%ghost %x11_drv_old/nvidia_drv.*
#
%nv_workdirdir
%nv_lib_sym_dir/libGLcore.so.?
%nv_lib_sym_dir/libXvMCNVIDIA_dynamic.so.?
%nv_lib_sym_dir/libNVIDIAXvMC.so
%nv_lib_sym_dir/libnvidia-tls.so.?
%nv_lib_sym_dir/libnvidia-cfg.so.?
#%nv_lib_sym_dir/nvidia.xinf
%if "%_lib" == "lib64"
%dir %nv_lib32_sym_dir/
%nv_lib32_sym_dir/libGLcore.so.?
%nv_lib32_sym_dir/libXvMCNVIDIA_dynamic.so.?
%nv_lib32_sym_dir/libNVIDIAXvMC.so
%nv_lib32_sym_dir/libnvidia-tls.so.?
%endif
#
%x11_lib_dir/libGLcore.so.?
%x11_lib_dir/libXvMCNVIDIA_dynamic.so.?
%x11_lib_dir/libNVIDIAXvMC.so
%tls_lib_dir/libnvidia-tls.so.?
%x11_lib_dir/libnvidia-cfg.so.?

%files -n %{bin_pkg_name}-devel
%_includedir/nvidia
%endif

%if_enabled kernelsource
%files -n kernel-source-%module_name-%module_version
%_usrsrc/*
%endif

%changelog
