BuildRequires: desktop-file-utils
%define ver 3.5.0
%define subver 7

Name: nxclient
Version: %ver.%subver
Release: alt5

Summary: NoMachine.com's NX client

License: Proprietary
Group: Networking/Remote access
Url: http://www.nomachine.com

Source0: %name-%ver-%subver.i386.tar
Source1: %name-desktop.tar
Source2: %name-mime.tar
Source10: %name-%ver-%subver.x86_64.tar

Packager: Boris Savelev <boris@altlinux.org>

#BuildRequires: nx = %ver
BuildRequires: nx
BuildRequires: libXft-devel fontconfig-devel libfreetype-devel libcups-devel
BuildRequires: chrpath
BuildRequires: libpng12

Requires: nx >= %ver
#BuildRequires: desktop-file-utils

%description
NXClient is a X11/VNC/NXServer client especially tuned for using remote
desktops over low-bandwidth links such as the Internet

%prep
%ifarch %ix86
%setup -b0 -n NX
%else
%setup -b10 -n NX
%endif

tar xf %SOURCE1
tar xf %SOURCE2

%install
mkdir -p %buildroot%_bindir/
mkdir -p %buildroot%_libdir/%name/bin/
mkdir -p %buildroot%_libdir/%name/lib/
mkdir -p %buildroot%_datadir/%name/

# bin
chrpath -d bin/%name
cp -ap bin/%name %buildroot%_libdir/%name/bin/
cp -ap bin/nxprint %buildroot%_libdir/%name/bin/

cat >> %buildroot%_libdir/%name/bin/%name.cfg << EOF
<!DOCTYPE NXClientSettings>
<NXClientSettings application="nxclient" version="1.3" >
<group name="General" >
<option key="System NX dir" value="%_libdir/%name" />
</group>
</NXClientSettings>
EOF

for f in nxesd nxssh nxservice ; do
    ln -s %_bindir/$f %buildroot%_libdir/%name/bin/$f
done

ln -s %_libdir/%name/bin/%name %buildroot%_bindir/%name

# lib
ln -s %_libdir/libXcomp.so.%ver %buildroot%_libdir/%name/lib/libXcomp.so

# share
cp -ap share/* %buildroot%_datadir/%name
ln -s %_datadir/%name %buildroot%_libdir/%name/share

# desktop
mkdir -p %buildroot%_desktopdir/
install -m644 %name-desktop/* %buildroot%_desktopdir/

# mime
mkdir -p %buildroot%_datadir/mimelnk/application/
mkdir -p %buildroot%_datadir/mime/application/
install -m644 %name-mime/*.desktop %buildroot%_datadir/mimelnk/application/
install -m644 %name-mime/*.xml %buildroot%_datadir/mime/application/

# Only one system tuning? (breaks CentOS 5 build)
%if 0
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Application \
	--add-category=RemoteAccess \
	%buildroot%_desktopdir/nxclient-wizard.desktop
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Application \
	--add-category=RemoteAccess \
	%buildroot%_desktopdir/nxclient.desktop
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Application \
	--add-category=RemoteAccess \
	%buildroot%_desktopdir/nxclient-help.desktop
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Application \
	--add-category=RemoteAccess \
	%buildroot%_desktopdir/nxclient-admin.desktop
%endif
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=RemoteAccess \
	%buildroot%_desktopdir/nxclient-help.desktop
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=RemoteAccess \
	%buildroot%_desktopdir/nxclient-wizard.desktop
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=RemoteAccess \
	%buildroot%_desktopdir/nxclient.desktop
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=RemoteAccess \
	%buildroot%_desktopdir/nxclient-admin.desktop

%files
%_bindir/%name
%_libdir/%name/
%_datadir/%name/
%_datadir/mime/application/*
%_datadir/mimelnk/application/*
%_desktopdir/*

%changelog
