%def_enable perl
%def_enable python
%def_enable ruby
%def_enable tcl
%def_disable static
%def_disable swig

%if_enabled perl
%force_enable swig
%endif
%if_enabled python
%force_enable swig
%endif
%if_enabled ruby
%force_enable swig
%endif
%if_enabled tcl
%force_enable swig
%endif

Summary: ObexFTP implements the Object Exchange (OBEX) protocols file transfer.
Name: obexftp
Version: 0.23
Release: alt4.git76127.1

License: GPL
Group: Communications
URL: http://triq.net/gsm.html

Source: http://triq.net/obex/%name-%version.tar
Patch: %name-%version-%release.patch

Requires: lib%name = %version-%release

BuildRequires: gcc-c++ libopenobex-devel libgsm-devel libbluez-devel libusb-compat-devel libfuse-devel autoconf-archive asciidoc xmlto

BuildPreReq: chrpath

%if_enabled swig
BuildRequires: swig
%endif
%if_enabled perl
BuildRequires: perl-devel
%endif
%if_enabled python
BuildRequires: python-devel
%endif
%if_enabled ruby
BuildRequires: ruby libruby-devel
%endif
%if_enabled tcl
BuildRequires: tcl-devel tcl
%endif

%package -n lib%name
Summary: obexftp libraries
Group: System/Libraries

%package devel
Summary: Development files of obexftp
Group: Development/C
Requires: lib%name = %version-%release

%if_enabled static
%package devel-static
Summary: Static develop path of obexftp
Group: Development/C
Requires: lib%name-devel = %version-%release
%endif

%if_enabled python
%package -n python-module-obexftp
Summary: Python bindings for obexftp
Group: Development/Python
%endif

%if_enabled perl
%package -n perl-obexftp
Summary: Perl bindings for obexftp
Group: Development/Perl
%endif

%if_enabled tcl
%package -n tcl-obexftp
Summary: Tcl bindings for obexftp
Group: Development/Tcl
Requires: tcl
%endif

%if_enabled ruby
%package -n ruby-obexftp
Summary: Ruby bindings for obexftp
Group: Development/Ruby
Requires: ruby
%endif

%description
This package contains some command line tools and the ObexFTP library.
Using OpenOBEX it enables you to transfer data via IrDA, BlueTooth
as well as some custom (Siemens, Ericsson) serial port protocols.
Authors: Christian W. Zuckschwerdt <zany@triq.net>

%description -n lib%name
Libraries for obexftp

%description devel
This package contains some command line tools and the ObexFTP library.
Using OpenOBEX it enables you to transfer data via IrDA, BlueTooth
as well as some custom (Siemens, Ericsson) serial port protocols.

%if_enabled static
%description devel-static
Static development files for obexftp.
%endif

%if_enabled python
%description -n python-module-obexftp
Python bindings for obexftp.
%endif

%if_enabled perl
%description -n perl-obexftp
Perl bindings for obexftp.
%endif

%if_enabled tcl
%description -n tcl-obexftp
Tcl bindings for obexftp.
%endif

%if_enabled ruby
%description -n ruby-obexftp
Ruby bindings for obexftp.
%endif

%prep
%setup
%patch -p1

%build
mkdir m4
touch config.rpath
libtoolize --copy --force
%autoreconf -I m4

%configure \
    --enable-bluetooth \
    --enable-builddocs \
    --enable-swig \
    --disable-rpath \
    %{subst_enable tcl} \
    %{subst_enable perl} \
    %{subst_enable python} \
    %{subst_enable ruby} \
    --disable-fuse \
    %{subst_enable static}
%if_enabled swig
rm -f swig/*/*_wrap.c
%endif
%make_build RUBY="ruby -rvendor-specific"

%install

%make_install noinstdir=`pwd`/docs DESTDIR="%buildroot" INSTALLDIRS=vendor install

for i in obexmv obexls obexget obexput obexrm ; do
	ln -s obexftp %buildroot%_bindir/$i
done

%if_enabled tcl
mkdir -p %buildroot%_tcllibdir
mv %buildroot%_libdir/obexftp.so* %buildroot%_tcllibdir/
LD_LIBRARY_PATH=%buildroot%_libdir %tea_makeindex -C %buildroot%_tcldatadir/obexftp
%endif

%if_enabled python
mv %buildroot%python_sitelibdir/obexftp/_*.so* %buildroot%python_sitelibdir
%endif

chrpath -d %buildroot%perl_vendor_autolib/OBEXFTP/OBEXFTP.so

%files
%doc AUTHORS ChangeLog NEWS README* THANKS TODO
%_bindir/*
%_man1dir/*

%files -n lib%name
%_libdir/lib*.so.*

%files devel
%dir %_includedir/bfb
%dir %_includedir/multicobex
%dir %_includedir/obexftp
%_includedir/*/*
%_libdir/*.so
%_pkgconfigdir/obexftp.pc
%if_enabled tcl
%_tcldatadir/*
%endif

%if_enabled static
%files devel-static
%_libdir/lib*.a
%endif

%if_enabled perl
%files -n perl-obexftp
%perl_vendor_archlib/OBEXFTP*
%perl_vendor_autolib/OBEXFTP*
%endif

%if_enabled python
%files -n python-module-obexftp
%python_sitelibdir/*
%endif

%if_enabled tcl
%files -n tcl-obexftp
%_tcllibdir/*
%_tcldatadir/*
%endif

%if_enabled ruby
%files -n ruby-obexftp
%ruby_sitearchdir/*
%endif

%changelog
