Name: octave
Version: 3.6.4
Release: alt1

%define docdir %_defaultdocdir/%name-%version

Summary: GNU Octave -- a high-level language for numerical computations
License: GPLv3
Group: Sciences/Mathematics
Url: http://www.octave.org
Packager: Paul Wolneykien <manowar@altlinux.ru>

BuildRequires: flex gcc-c++ gcc-fortran libcurl-devel libfftw3-devel libglpk-devel
BuildRequires: libhdf5-devel liblapack-devel libncurses-devel libpcre-devel
BuildRequires: libreadline-devel libstdc++-devel libtinfo-devel libX11-devel libXext-devel
BuildRequires: libSM-devel libICE-devel liblcms-devel bzlib-devel libltdl-devel
BuildRequires: libGraphicsMagick-c++-devel libGL-devel libGLU-devel libfreetype-devel
BuildRequires: libftgl-devel zlib-devel desktop-file-utils gnuplot less
BuildRequires: texlive-base-bin texlive-generic-recommended
BuildPreReq: libqhull-devel fontconfig-devel libfltk-devel
BuildPreReq: libqrupdate-devel libsuitesparse-devel gperf libXft-devel
BuildPreReq: libpixman-devel libcairo-devel libXinerama-devel

Source0: %name-%version-%release.tar
Source1: octave.filetrigger

Patch0: octave-include-pcre.patch
Patch1: octave-3.4.0-alt-gcc4.6.patch
Patch2: octave-3.4.0-alt-suitesparse.patch

Requires: gnuplot

%package devel
Summary: GNU Octave -- development part
Group: Development/C
Requires: %name = %version-%release

%package doc
Summary: GNU Octave -- documentation
Group: Development/Other
BuildArch: noarch

%description
GNU Octave is a high-level language, primarily intended for numerical
computations. It provides a convenient command line interface for
solving linear and nonlinear problems numerically, and for performing
other numerical experiments using a language that is mostly compatible
with Matlab. It may also be used as a batch-oriented language.

Octave has extensive tools for solving common numerical linear algebra
problems, finding the roots of nonlinear equations, integrating
ordinary functions, manipulating polynomials, and integrating ordinary
differential and differential-algebraic equations. It is easily
extensible and customizable via user-defined functions written in
Octave's own language, or using dynamically loaded modules written in
C++, C, Fortran, or other languages.

%description devel
GNU Octave is a high-level language, primarily intended for numerical
computations. It provides a convenient command line interface for
solving linear and nonlinear problems numerically, and for performing
other numerical experiments using a language that is mostly compatible
with Matlab. It may also be used as a batch-oriented language.

This package contains development libraries and header files.

%description doc
GNU Octave is a high-level language, primarily intended for numerical
computations. It provides a convenient command line interface for
solving linear and nonlinear problems numerically, and for performing
other numerical experiments using a language that is mostly compatible
with Matlab. It may also be used as a batch-oriented language.

This package contains extra documentation for GNU Octave.

%define _libexecdir %_libdir

%prep
%setup
%patch0 -p2
%patch1 -p1
%patch2 -p1

%build
%add_optflags $(pkg-config hdf5-seq --cflags) $(pcre-config --cflags)
%add_optflags $(pkg-config fontconfig --cflags) -fpermissive
%autoreconf
%configure --with-blas=openblas \
    --enable-dl --enable-shared \
    --disable-static --disable-rpath \
    --enable-lite-kernel --enable-picky-flags
#smp-unaware
%make

%install
%makeinstall

mkdir -p %buildroot%_datadir/octave/packages %buildroot%_libdir/octave/packages

pushd doc
mkdir -p %buildroot%docdir
find interpreter/octave.html liboctave/liboctave.html -type f | cpio -pmdv %buildroot%docdir
install -pm0644 faq/OctaveFAQ.pdf interpreter/octave.pdf \
    liboctave/liboctave.pdf refcard/refcard-a4.pdf %buildroot%docdir
popd
gzip -c ChangeLog > %buildroot%docdir/ChangeLog.gz
install -pm0644 BUGS COPYING NEWS* README %buildroot%docdir

# Install the filetrigger for packages:
install -pm0755 -D %SOURCE1 %buildroot%_rpmlibdir/%name.filetrigger

#check
#make_build check

%files
%dir %docdir
%docdir/BUGS
%docdir/COPYING
%docdir/NEWS*
%docdir/README
%docdir/ChangeLog.gz

%_bindir/octave
%_bindir/octave-%version
%_bindir/octave-config
%_bindir/octave-config-%version

%_datadir/%name
%_libdir/%name/%version/*.so*
%exclude %_libdir/%name/%version/*.la*
%_libexecdir/%name

%_infodir/octave.info*
%_infodir/OctaveFAQ.info*
%_infodir/liboctave.info*

%_man1dir/*

%_desktopdir/*.desktop

%_rpmlibdir/%name.filetrigger

%files devel
%_includedir/%name-%version
%_bindir/mkoctfile
%_bindir/mkoctfile-%version

%files doc
%docdir/*.pdf
%docdir/interpreter
%docdir/liboctave

%changelog
