%define Name iSCSI
%define bname iscsi
Name: open-%bname
%define module_name %name
Version: 2.0.871
License: %gpl2plus
Release: alt6.M70P.1
Summary: Utils to operate with %Name
Group: System/Kernel and hardware
Packager: Slava Dubrovskiy <dubrsl@altlinux.ru>
URL: http://%name.org
Source: http://www.%name.org/bits/%name-%version.tar
Source1: iscsi-gen-initiatorname.sh
Patch: %name-%version-%release.patch
Patch1: %name-2.0.871-alt-glibc-2.16.patch
Conflicts: linux-iscsi

# Automatically added by buildreq on Fri Jun 08 2007 (-bi)
BuildRequires: glibc-devel-static
BuildRequires: rpm-build-licenses

%description
%Name is an internet storage protocol, originally developed by CISCO
systems.
This is a Linux implementation of user-space utils to access %bname
storages.


%package -n kernel-source-%module_name
Summary: Linux %module_name modules sources
Group: Development/Kernel

%description -n kernel-source-%module_name
This package contains sources for %module_name kernel modules.

%prep
%setup -n %name-%version
%patch -p1
%patch1 -p0

%build
for d in utils/fwparam_ibft utils usr; do
    %make_build -C $d
done

install -d -m 0755 kernel-source-%module_name-%version/include
install -m 0644 include/* kernel-source-%module_name-%version/include/
install -m 0644 kernel/* kernel-source-%module_name-%version/

%install
%make_install DESTDIR=%buildroot initddir=%_initdir \
    install_programs install_initd_alt install_etc install_doc

install -m 0755 %SOURCE1 %buildroot/sbin/iscsi-gen-initiatorname

install -d -m 0755 %buildroot%_usrsrc/kernel/sources
tar -c kernel-source-%module_name-%version | bzip2 --best --stdout > \
    %buildroot%_usrsrc/kernel/sources/kernel-source-%module_name-%version.tar.bz2

%post
if [ ! -f /etc/iscsi/initiatorname.iscsi ] ; then
    /sbin/iscsi-gen-initiatorname
fi
%post_service %name

%preun
%preun_service %name


%files
%doc README THANKS etc/iface.example
%dir %_sysconfdir/%bname
%config(noreplace) %_sysconfdir/%bname/%{bname}d.conf
%_initdir/*
/sbin/*
%_man8dir/*

%files -n kernel-source-%module_name
%_usrsrc/kernel/sources/*.tar.bz2

%changelog
