Name: openais
Summary: The openais Standards-Based Cluster Framework executive and APIs
Version: 1.1.4
Release: alt1
License: BSD
Group: System/Base
Url: http://developer.osdl.org/dev/%name/
Source0: http://devresources.linuxfoundation.org/dev/%name/downloads/%name-%version/%name-%version.tar.gz
Patch0: openais-1.1.4-alt1-fix-lcrso-linking.patch

# Setup/build bits
BuildRequires: libcorosync-devel >= 1.0.0
BuildRequires: autoconf automake

%description
This package contains the openais service handlers, default configuration
files and init script.

%package -n libopenais
Summary: The openais Standards-Based Cluster Framework libraries
Group: System/Libraries
Requires: %name = %version-%release

%description -n libopenais
This package contains openais libraries.

%package -n libopenais-devel
Summary: The openais Standards-Based Cluster Framework libraries
Group: Development/C

%description -n libopenais-devel
This package contains the include files used to develop using openais APIs.

%prep
%setup -n %name-%version
%patch0 -p2

%build
./autogen.sh

%configure \
	--with-initddir=%_initddir

%make

%install
make install DESTDIR=%buildroot

## tree fixup
# drop static libs
rm -f %buildroot%_libdir/*.a
# drop docs and html docs for now
rm -rf %buildroot%_docdir/*

%post
%post_service openais

%preun
%preun_service openais

%files
%doc LICENSE README.amf
%dir %_sysconfdir/corosync
%config(noreplace) %_sysconfdir/corosync/amf.conf.example
%_initdir/openais
%dir %_libexecdir/lcrso
%_libexecdir/lcrso/openaisserviceenable.lcrso
%_libexecdir/lcrso/service_amf.lcrso
%_libexecdir/lcrso/service_ckpt.lcrso
%_libexecdir/lcrso/service_clm.lcrso
%_libexecdir/lcrso/service_evt.lcrso
%_libexecdir/lcrso/service_lck.lcrso
%_libexecdir/lcrso/service_msg.lcrso
%_libexecdir/lcrso/service_tmr.lcrso
%_mandir/man8/openais_overview.8*
%_mandir/man5/openais.conf.5*
%_mandir/man5/amf.conf.5*
%_sbindir/aisexec
%_sbindir/openais-instantiate

%files -n libopenais
%_libdir/libSaAmf.so.*
%_libdir/libSaCkpt.so.*
%_libdir/libSaClm.so.*
%_libdir/libSaEvt.so.*
%_libdir/libSaLck.so.*
%_libdir/libSaMsg.so.*
%_libdir/libSaTmr.so.*

%files -n libopenais-devel
%dir %_includedir/openais/
%_includedir/openais/saAis.h
%_includedir/openais/saAmf.h
%_includedir/openais/saCkpt.h
%_includedir/openais/saClm.h
%_includedir/openais/saEvt.h
%_includedir/openais/saLck.h
%_includedir/openais/saMsg.h
%_includedir/openais/saTmr.h
%_libdir/libSaAmf.so
%_libdir/libSaCkpt.so
%_libdir/libSaClm.so
%_libdir/libSaEvt.so
%_libdir/libSaLck.so
%_libdir/libSaMsg.so
%_libdir/libSaTmr.so
%_libdir/pkgconfig/*.pc

%changelog
