Name: openbox
Version: 3.5.0
Release: alt4.M70P.1

Summary: Openbox is a standards compliant, fast, light-weight, extensible window manager
Summary(ru_RU.UTF-8): Openbox это следующий стандартам, быстрый, лёгкий, расширяемый оконный менеджер
License: GPLv2+
Group: Graphical desktop/Other
Url: http://openbox.org/

Packager: Igor Zubkov <icesik@altlinux.org>

Source0: %name-%version.tar.gz
Source2: %name-icons.tar.bz2
Source3: %name.menu
Source4: %name.menu-method
Source5: %name.wmsession
Source6: %name-kde.wmsession
Source7: %name-gnome.wmsession

# Debian
Source11: kdetrayproxy.pod
Source12: gnome-panel-control.pod
Source13: menu.xml

# ALT Linux
Patch2: openbox-alt-menu-rc.xml.in.patch
Patch3: openbox-3.3.1-alt-TheBear-theme.patch
Patch4: openbox-3.4.4-alt-TheBear-theme-2.patch
Patch5: openbox-3.4.9-alt-desktop-file.patch

Requires: lib%name = %version-%release
# for menu "Run" item
Requires: Xdialog

Requires: %name-base = %version-%release

Conflicts: openbox-extras

BuildPreReq: gettext >= 0.15

# Automatically added by buildreq on Tue Jan 12 2010 (-bi)
BuildRequires: cvs gnome-session imake kdebase-wm libSM-devel libXau-devel libXcursor-devel libXext-devel libXinerama-devel libXrandr-devel libpango-devel libstartup-notification-devel libxml2-devel xorg-cf-files
BuildRequires: perl-podlators

%description
Openbox is a standards compliant, fast, light-weight, extensible window manager.
Openbox works with your applications, and makes your desktop easier to manage.
This is because the approach to its development was the opposite of what seems
to be the general case for window managers. Openbox was written first to comply
with standards and to work properly. Only when that was in place did the team
turn to the visual interface.
Openbox is fully functional as a stand-alone working environment, or can be
usedas a drop-in replacement for the default window manager in the GNOME or KDE
desktop environments.

%package -n lib%name
Summary: Openbox libraries
Group: System/Libraries

%description -n lib%name
This package contains libraries for Openbox window manager:
libobparser - Openbox config file parsing library,
libobrender - Openbox Render Library.

%package -n lib%name-devel
Summary: Development files for Openbox
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains the header files and libraries for
developing with Openbox window manager.

%package -n lib%name-devel-static
Summary: Development static library for Openbox
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package contains static libraries for developing with
Openbox window manager.

%package base
Summary: Openbox pure WM
Group: Graphical desktop/Other

%description base
Openbox pure WM.

%package kde
Summary: Run KDE with Openbox as the WM
Group: Graphical desktop/Other
BuildArch: noarch
Requires: %name-base = %version-%release

%description kde
Run KDE with Openbox as the WM.

%package gnome
Summary: Run GNOME with Openbox as the WM
Group: Graphical desktop/Other
Requires: %name-base = %version-%release

%description gnome
Run GNOME with Openbox as the WM.

%package autostart
Summary: XDG support for Openbox
Group: Graphical desktop/Other
BuildArch: noarch
Requires: %name-base = %version-%release
Requires: python-module-pyxdg

%description autostart
XDG support for Openbox.

%prep
%setup -q -a2
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
sed -i '/^obrender_libobrender_la_LIBADD/ a\\tobt/libobt.la \\' Makefile.am

%build
%autoreconf
%configure \
	--disable-rpath \
	--disable-static
%make_build

cp %SOURCE11 .
cp %SOURCE12 .

pod2man --section=1 --release=%version --center "Openbox documentation" kdetrayproxy.pod > kdetrayproxy.1
pod2man --section=1 --release=%version --center "Openbox documentation" gnome-panel-control.pod > gnome-panel-control.1

%install
%make_install DESTDIR=%buildroot install

rm -rf %buildroot%_datadir/doc/

# manual pages
mkdir -p %buildroot%_man1dir/
install -pD -m 644 kdetrayproxy.1 %buildroot%_man1dir/
install -pD -m 644 gnome-panel-control.1 %buildroot%_man1dir/

# icons
install -pD -m 644 %name-64.xpm %buildroot%_iconsdir/hicolor/64x64/apps/OpenBox.xpm
install -pD -m 644 %name-48.xpm %buildroot%_liconsdir/%name.xpm
install -pD -m 644 %name-32.xpm %buildroot%_niconsdir/%name.xpm
install -pD -m 644 %name-16.xpm %buildroot%_miconsdir/%name.xpm

# Menu isn't cooked yet, because it's hard to implement menu-method
# for Openbox XML based menu
install -pD -m 755 %SOURCE4 %buildroot%_sysconfdir/menu-methods/%name
install -pD -m 644 %SOURCE5 %buildroot%_sysconfdir/X11/wmsession.d/09%name
install -pD -m 644 %SOURCE6 %buildroot%_sysconfdir/X11/wmsession.d/10%name-kde
install -pD -m 644 %SOURCE7 %buildroot%_sysconfdir/X11/wmsession.d/11%name-gnome

mkdir -p %buildroot%_sysconfdir/xdg/openbox/

install -pD -m 644 %SOURCE13 %buildroot%_sysconfdir/xdg/openbox/

%find_lang --output=%name.lang %name

%files
%config %_sysconfdir/X11/wmsession.d/09openbox
%_datadir/xsessions/openbox.desktop

%files base -f %name.lang
%doc AUTHORS CHANGELOG COMPLIANCE README
%doc data/menu.xsd doc/rc-mouse-focus.xml data/rc.xsd data/xbm
%_sysconfdir/xdg/openbox/*
%config(noreplace) %_sysconfdir/menu-methods/*
%_bindir/*
%exclude %_bindir/openbox-kde-session
%exclude %_bindir/openbox-gnome-session
%exclude %_bindir/gdm-control
%exclude %_bindir/gnome-panel-control
%_man1dir/*
%exclude %_man1dir/openbox-kde-session.*
%exclude %_man1dir/openbox-gnome-session.*
%exclude %_man1dir/gnome-panel-control.*
%_datadir/gnome/wm-properties/*
%_datadir/pixmaps/*
%_datadir/themes/*
%_liconsdir/%name.xpm
%_niconsdir/%name.xpm
%_iconsdir/hicolor/64x64/apps/OpenBox.xpm
%_miconsdir/%name.xpm
%_datadir/applications/openbox.desktop

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_pkgconfigdir/*
%_libdir/*.so
%_includedir/*

%files kde
%config %_sysconfdir/X11/wmsession.d/10openbox-kde
%_bindir/openbox-kde-session
%_datadir/xsessions/openbox-kde.desktop
%_man1dir/openbox-kde-session.*

%files gnome
%config %_sysconfdir/X11/wmsession.d/11openbox-gnome
%_bindir/openbox-gnome-session
%_bindir/gdm-control
%_bindir/gnome-panel-control
%_datadir/xsessions/openbox-gnome.desktop
%_man1dir/openbox-gnome-session.*
%_man1dir/gnome-panel-control.*

%files autostart
%_libexecdir/openbox-xdg-autostart
%_libexecdir/openbox-autostart

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
