%def_disable static
%define _customdocdir %_docdir/%name-%version

Name: openct
Version: 0.6.20
Release: alt4

Group: System/Servers
Summary: OpenCT Library for Smart Card Readers
License: LGPL
Url: http://www.opensc-project.org/

Requires: lib%name = %version-%release

Source: %name-%version.tar
Patch1: %name-0.12.2-alt-automake-1.11.4.patch

Source10: openct.startup

# Automatically added by buildreq on Thu Sep 10 2009
BuildRequires: doxygen libltdl7-devel libpcsclite-devel libusb-compat-devel xsltproc

%if_enabled static
BuildRequires: libpcsclite-devel-static libusb-devel-static
%endif

%define ifddir %(pkg-config libpcsclite --variable=usbdropdir)

%description
OpenCT implements drivers for several smart card readers.
It comes as driver in ifdhandler format for PC/SC-Lite, as CT-API
driver, or as a small and lean middleware, so applications can use
it with minimal overhead.  OpenCT also has a primitive mechanism
to export smart card readers to remote machines via tcp/ip.

%package -n lib%name
Group: System/Libraries
Summary: Library for accessing Smartcards

%description -n lib%name
These are the shared libraries for the smartcard terminal middleware
OpenCT.
If you want to compile applications using this library, you also need
the %name-devel package.

%package -n lib%name-devel
Requires: lib%name = %version
Group: System/Libraries
Summary: Supplementary files for developing %name applications
Requires: lib%name = %version-%release

%description -n lib%name-devel
Header files and documentation for %name.

%package -n lib%name-devel-static
Requires: lib%name = %version
Group: System/Libraries
Summary: Supplementary files for developing %name applications
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
static libraries for %name.

%package -n pcsc-lite-openct
License: BSD 3-Clause; LGPL v2.1 or later
Group: System/Libraries
Requires: pcsc-lite
Summary: PC/SC IFD Handler for OpenCT Smart Card Drivers

Provides: pcsc-openct = %version-%release
Obsoletes: pcsc-openct < %version-%release

%description -n pcsc-lite-openct
PC/SC Connector for OpenCT. It allows to use any of OpenCT Smart Card
drivers with the PCSC-Lite daemon from the pcsc-lite package.

OpenCT is a set of library and tools to talk to smart card readers.
OpenCT is used by the OpenSC Smart Card library.

%prep
%setup
%patch1 -p2

%build
%autoreconf
%add_optflags %optflags_shared
%configure \
        %{subst_enable static} \
        %{subst_enable debug} \
        --enable-pcsc \
        --with-bundle=%ifddir \
        --with-ifddir=%ifddir \
        --localstatedir=%_var \
        --disable-doc \
        --enable-api-doc \
        --enable-usb \
        --enable-pcsc \
        --docdir=%_docdir/%name-%version \
        --with-udev=/lib/udev
%make_build

%check
%make_build -k check

%install
%make install DESTDIR=%buildroot

##
# Create local state dir:
#
install -d %buildroot%_var/run/openct

##
# Install init script:
#
install -d %buildroot%_initdir
install -m 755 %SOURCE10 %buildroot%_initdir/%name

mkdir -p %buildroot/lib/udev/rules.d/
install -p etc/openct.udev %buildroot/lib/udev/rules.d/60-openct.rules

##
# HAL stuff
#
#mkdir -p %buildroot%_datadir/hal/fdi/{information,policy}/20thirdparty
#install -p etc/openct.fdi %buildroot%_datadir/hal/fdi/information/20thirdparty/10-usb-openct.fdi
#install -p etc/openct-policy.fdi %buildroot%_datadir/hal/fdi/policy/20thirdparty/10-usb-openct.fdi

#mkdir -p %buildroot%_usr/libexec/hal
#install -p -m755 etc/openct.hald %buildroot%_usr/libexec/hal/hald-addon-openct

mkdir -p %buildroot%_sysconfdir/tmpfiles.d/
cat >> %buildroot%_sysconfdir/tmpfiles.d/%{name}.conf <<@@@
d /var/run/openct 0755 root root -
@@@

%post
%post_service %name

%preun
%preun_service %name

%files
%dir %_docdir/%name-%version
%doc %_docdir/%name-%version/NEWS
%doc TODO
%exclude %_docdir/%name-%version/api
%_man1dir/*.*
%_bindir/*
%_sbindir/*
%config(noreplace) %_sysconfdir/openct.conf
#%_datadir/hal/fdi/information/20thirdparty/10-usb-openct.fdi
#%_datadir/hal/fdi/policy/20thirdparty/10-usb-openct.fdi
#%_usr/libexec/hal/hald-addon-openct
%_initdir/%name
# copy documentation from %_builddir
%dir %_var/run/openct
%_sysconfdir/tmpfiles.d/%{name}.conf
/lib/udev/openct_pcmcia
/lib/udev/openct_serial
/lib/udev/openct_usb
/lib/udev/rules.d/60-openct.rules

%files -n lib%name
%_libdir/libopenctapi.so
%_libdir/libopenct.so.*

%files -n lib%name-devel
%dir %_docdir/%name-%version
%doc %_docdir/%name-%version/api
%_libdir/libopenct.so
%_libdir/pkgconfig/libopenct.pc
%dir %_includedir/%name
%_includedir/%name/*.h

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%files -n pcsc-lite-openct
%_libdir/openct-ifd.so
%ifddir/openct-ifd.bundle

%changelog
