%define _sover 2.4
%define _bname openldap
### Build switches for enable or disable fiture ###
%def_enable doc
%def_enable sql
%def_enable perl
%def_disable shell
%def_enable sasl
### Disable, because while build by rpm is not passed
%def_disable debug
%def_disable slapi
%def_enable slp
%def_enable overlay
%def_enable aci 
%def_enable yielding
%def_disable aacls
%def_enable ntlm

Name: openldap
Version: %_sover.42
Release: alt0.M70P.1

Provides: openldap2.4 = %version-%release
Obsoletes: openldap2.4 < %version-%release

%define so_maj %_sover
%define ldap_ssl_dir %_sysconfdir/%name/ssl
%define ssl_dir %_localstatedir/ssl/certs

Summary: LDAP libraries and sample clients
License: OpenLDAP Public License
Group: System/Servers
Url: http://www.openldap.org/

Packager: OpenLDAP Maintainers Team <openldap@packages.altlinux.org>

# ftp://ftp.openldap.org/pub/OpenLDAP/openldap-release/
Source: %name-%version.tar

# Docs for this products
#Source2: %name-README.upgrading
Source3: %_bname-README.ALT
Source4: %_bname-config-README.ALT

# System Specific source
Source11: %_bname.sysconfig
Source12: %_bname-slapd.init
Source13: %_bname.logrotate
Source14: %_bname-slapd.service

## Chroot config
Source15: %_bname-ldap.all
Source16: %_bname-ldap.conf
Source17: %_bname-ldap.lib
#This file we need to build from original dynamic
Source18: %_bname-slapd.conf
Source19: %_bname-bdb-DB_CONFIG
Source20: %_bname-slapd-access.conf
Source21: %_bname-slapd-hdb-db01.conf
Source22: %_bname-slapd-hdb-db02.conf

# Extended OpenLDAP schemas
Source50: %_bname-addon-schemas.tar
Source51: %_bname-ALT-rootdse.ldif

%if_enabled aacls
## AACLS patch
Source60: %_bname-aacls-patch-1.6a.tgz
%endif

### PATCHES
## This path for chrooting ldap
Patch1: %_bname-2.3.12-alt-servers-path.patch

## Patch created by Alexander Bokovoy <ab@altlinux.ru>
Patch2: %_bname-2.3.34-alt-pid.patch
Patch3: %_bname-2.3.12-autoconf-2.5-alt.patch

Patch4: %_bname-2.3.20-alt-makefile.patch
Patch5: %_bname-2.3.20-alt-ldapconf.patch
Patch6: %_bname-2.3.34-alt-defaults.patch

Patch7: %_bname-2.3.34-alt-meta-backend.patch

Patch8: %_bname-2.3.37-alt-ntlm.patch

Patch11: %_bname-2.3.43-fix-ucred.patch

Patch13: %_bname-2.4.25-rh-ldaprc-currentdir.patch
Patch14: %_bname-2.4.25-rh-reentrant-gethostby.patch
Patch18: %_bname-2.4.31-rh-nss-allow-ca-dbdir-pemfile.patch
Patch19: %_bname-2.4.31-rh-tls-unbind-shutdown-order.patch
Patch20: %_bname-2.4.31-rh-nss-dont-overwrite-verify-cert-error.patch
Patch21: %_bname-2.4.31-rh-nss-clean-memory-for-token-pin.patch
Patch22: %_bname-2.4.31-rh-cve-nss-cipher-suite-ignored.patch
Patch23: %_bname-2.4.31-rh-nss-default-cipher-suite-always-selected.patch
Patch24: %_bname-2.4.31-rh-nss-multiple-tls-contexts.patch
Patch25: openldap-2.4.32-alt-gcc5.1.patch
Patch26: openldap-2.4.42-CVE-2015-6908.patch

### REQUIRE Section

%if_enabled doc
# For compile documentations need "sdf".
BuildPreReq: sdf >= 2
%endif
%if_enabled sasl
# due to SASL_AUXPROP_PLUG_VERSION
BuildPreReq: libsasl2-devel >= 2.1.24-alt1.cvs.20090508
%endif
%if_enabled sql
BuildPreReq: libunixODBC-devel
%endif
%if_enabled perl
BuildPreReq: perl-devel
%endif
%if_enabled slp
BuildPreReq: libopenslp-devel
%endif

# Automatically added by buildreq on Tue Oct 18 2011 (-bi)
BuildRequires: chrooted groff-base libdb4-devel libltdl-devel libssl-devel libwrap-devel shtool

%package -n libldap
Summary: OpenLDAP libraries
Group: System/Libraries
Provides: libldap2.4 = %version-%release
Obsoletes: libldap2.4 < %version-%release

%package -n libldap-devel
Summary: OpenLDAP development libraries and header files
Group: Development/C
Requires: libldap = %version-%release

Provides: openldap-devel = %version-%release
Obsoletes: openldap-devel < %version-%release

%package -n libldap-devel-static
Summary: OpenLDAP development static libraries
Group: Development/C
Requires: libldap-devel = %version-%release
Provides: openldap-devel-static = %version-%release
Obsoletes: openldap-devel-static < %version-%release

%package servers
Summary: LDAP servers
Group: System/Servers
PreReq: libldap = %version-%release, %name = %version-%release

Provides: openldap2.4-servers = %version-%release
Obsoletes: openldap2.4-servers < %version-%release

%package clients
Summary: LDAP utilities, tools and sample clients
Group: Networking/Remote access
PreReq: libldap = %version-%release, %name = %version-%release

Provides: openldap2.4-clients = %version-%release
Obsoletes: openldap2.4-clients < %version-%release

%if_enabled doc
%package -n %_bname-doc
Summary: OpenLDAP administration guide
Group: Books/Computer books
BuildArch: noarch

Provides: openldap2.4-doc = %version-%release
Obsoletes: openldap2.4-doc < %version-%release

%endif

%description
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

Install %_bname if you need to run LDAP-based applications and tools.

%description -n libldap
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

This package contains shared libraries needed for make works %_bname-based softare.

%description -n libldap-devel
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

This package includes the development libraries and header files needed
for developing applications that use LDAP internals. Install this package
only if you plan to develop or will need to compile customized LDAP clients.

%description -n libldap-devel-static
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

This package includes the static libraries needed for developing statically
linked applications that use LDAP internals.

%description servers
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

Install %_bname-servers if you need LDAP servers.

%description clients
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools.  LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet.  The suite includes a stand-alone LDAP server
(slapd), libraries for implementing the LDAP protocol, utilities, 
tools, and sample clients.

Install %_bname-client if you need LDAP applications and tools.

%if_enabled doc
%description -n %_bname-doc
OpenLDAP Administration Guide
HTML and TXT versions
%endif

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
#%%patch7 -p1

%if_enabled ntlm
%patch8 -p1 -b .ntlm
%endif

%patch11 -p1

%patch13 -p1
%patch14 -p1

#%patch25 -p2
%patch26 -p1

### Extract AACLS patch
%if_enabled aacls
tar -zxf %SOURCE60 
%__patch -p1 < ./patch-0.6/patch-2.2.11
%endif

# Add some more schema for the sake of migration scripts and others
pushd servers/slapd
tar -xf %SOURCE50
popd


%build

# Options -lresolv in line below need for some bad configure scripts like in auth_ldap package
#export LDFLAGS="$LDFLAGS -lresolv"
export CPPFLAGS="$CPPFLAGS -DLOG_DAEMON=1"

shtoolize all
aclocal
autoconf
libtoolize --force --install

%configure \
	--enable-syslog \
	--enable-proctitle \
	--enable-dynamic \
	--with-tls=openssl \
	--with-threads \
	--enable-slapd \
	--enable-lmpasswd \
	--enable-crypt \
	--enable-cleartext \
	--enable-modules \
	--enable-rewrite \
	--enable-wrappers \
	--enable-bdb=mod \
	--enable-hdb=mod \
	--enable-dnssrv=mod \
	--enable-ldap=mod \
    --enable-relay=mod \
    	--enable-memberof=mod \
	--enable-meta=mod \
	--enable-monitor=mod \
	--enable-null=mod \
	--enable-passwd=mod \
	\
%if_enabled yielding
	--with-yielding-select \
%else
	--without-yielding-select \
%endif
%if_enabled aci
	--enable-aci \
%else
	--disable-aci \
%endif
%if_enabled slapi
	--enable-slapi \
%else
	--disable-slapi \
%endif
%if_enabled slp
	--enable-slp \
%else
	--disable-slp \
%endif
%if_enabled shell
	--enable-shell=mod	\
	  --without-threads \
%else
	--disable-shell \
	  --with-threads \
%endif
%if_enabled sql
	--enable-sql=mod \
%else
	--disable-sql \
%endif
%if_enabled sasl
	--with-cyrus-sasl \
	  --enable-spasswd \
%else
	--without-cyrus-sasl \
%endif
%if_enabled perl
	--enable-perl=mod \
%else
	--disable-perl \
%endif
%if_enabled overlay
     --enable-accesslog=mod \
     --enable-auditlog=mod \
	 --enable-dyngroup=mod \
     --enable-dynlist=mod \
     --enable-ppolicy=mod \
	 --enable-proxycache=mod \
     --enable-refint=mod \
     --enable-retcode=mod \
     --enable-rwm=mod \
     --enable-syncprov=mod \
     --enable-translucent=mod \
     --enable-unique=mod \
     --enable-valsort=mod \
%else
    --disable-accesslog \
    --disable-auditlog \
	--disable-dyngroup \
    --disable-dynlist \
    --disable-ppolicy \
	--disable-proxycache \
    --disable-refint \
    --disable-retcode \
    --disable-rwm \
    --disable-syncprov \
    --disable-translucent \
    --disable-unique \
    --disable-valsort \
%endif
%if_enabled debug
	--enable-debug \
%endif
%if_enabled aacls
	--enable-aacls \
%endif

%__subst 's/^AC_CFLAGS.*/& %optflags_shared/' libraries/librewrite/Makefile

%make depend
export NPROCS=1
%make_build

pushd libraries/liblutil
rm -f libldif.la
MOD_LIBS="-L../liblber/.libs/ -L../libldap/.libs/ -llber -lldap" make
popd

%if_enabled doc
# Build Administrator Guide in html and text mode
pushd doc/guide/admin
sdf -2topics index.sdf
sdf -2txt guide.sdf
popd
%endif

%check
# TODO!!!
if [ %release != alt2.1.1 ]; then
%make_build test
fi

%install

%make DESTDIR=%buildroot install

###
## Install all slapd's file
###

# Create the /var/lib data directory and chroot enviroment.
%__mkdir_p -m750 %buildroot/%_localstatedir/ldap
#__mkdir_p -m750 %buildroot/%_localstatedir/ldap/bases
%__mkdir_p -m770 %buildroot/%_localstatedir/ldap/dblogs
#__mkdir_p -m750 %buildroot/%_localstatedir/ldap/replica
%__mkdir_p -m755 %buildroot/%_localstatedir/ldap/dev
%__mkdir_p -m750 %buildroot/%_localstatedir/ldap/%_sysconfdir/ssl
%__mkdir_p -m750 %buildroot/%_localstatedir/ldap/%_sysconfdir/schema
%__ln_s . %buildroot/%_localstatedir/ldap/%_sysconfdir/%_bname
%__mkdir_p -m775 %buildroot/%_localstatedir/ldap/lib
%__ln_s lib %buildroot/%_localstatedir/ldap/lib64
%__mkdir_p -m755 %buildroot/%_localstatedir/ldap/usr/lib/%_bname
%__mkdir_p -m755 %buildroot/%_localstatedir/ldap/usr/lib/sasl2
%__ln_s lib %buildroot/%_localstatedir/ldap/usr/lib64
%__mkdir_p -m775 %buildroot/%_localstatedir/ldap/var/run
%__mkdir_p -m775 %buildroot/%_localstatedir/ldap/%_localstatedir/ldap
%__ln_s ../../../bases %buildroot/%_localstatedir/ldap/%_localstatedir/ldap/
%__ln_s ../../../dblogs %buildroot/%_localstatedir/ldap/%_localstatedir/ldap/
mksock %buildroot%_localstatedir/ldap/dev/log

# Install init scripts.
%__install -pD -m644 %SOURCE11 %buildroot/%_sysconfdir/sysconfig/ldap
%__install -pD -m755 %SOURCE12 %buildroot/%_initdir/slapd
%__mkdir_p -m750 %buildroot/%_sysconfdir/chroot.d
%__install -pD -m750 %SOURCE15 %buildroot/%_sysconfdir/chroot.d/ldap.all
%__install -pD -m750 %SOURCE16 %buildroot/%_sysconfdir/chroot.d/ldap.conf
%__install -pD -m750 %SOURCE17 %buildroot/%_sysconfdir/chroot.d/ldap.lib
%__install -pD -m644 %SOURCE14 %buildroot/%systemd_unitdir/slapd.service

# log repository and logrotate config
#__mkdir_p -m750 %buildroot/%_logdir/ldap
#__install -pD -m644 %SOURCE13 %buildroot/%_sysconfdir/logrotate.d/ldap

# syslog.d
mkdir -pm700 %buildroot%_sysconfdir/syslog.d
ln -s %_localstatedir/ldap/dev/log %buildroot%_sysconfdir/syslog.d/ldap


# config files
%__mkdir_p -m750 %buildroot/%_sysconfdir/%_bname/ssl
%__install -pD -m640 %SOURCE18 %buildroot/%_sysconfdir/%_bname/slapd.conf
%__install -pD -m640 %SOURCE19 %buildroot/%_localstatedir/ldap/bases/DB_CONFIG
%__install -pD -m640 %SOURCE20 %buildroot/%_sysconfdir/%_bname/slapd-access.conf
%__install -pD -m640 %SOURCE21 %buildroot/%_sysconfdir/%_bname/slapd-hdb-db01.conf
%__install -pD -m640 %SOURCE22 %buildroot/%_sysconfdir/%_bname/slapd-hdb-db02.conf
%__install -pD -m644 %SOURCE51 %buildroot/%_sysconfdir/%_bname/rootdse.ldif

# We don't need the default files - let's move it.
%__mkdir_p %buildroot/%_docdir/%_bname-servers-%version/default
%__mv %buildroot/%_sysconfdir/%_bname/*.default \
	%buildroot/%_docdir/%_bname-servers-%version/default/
%__mv %buildroot/%_sysconfdir/%_bname/*.example \
	%buildroot/%_docdir/%_bname-servers-%version/
rm -f %buildroot/%_localstatedir/ldap/bases/*.example

# Documentations for servers
%__mkdir_p %buildroot/%_docdir/%_bname-servers-%version/{back-{null,perl,sql},schema,slapi,overlays}/
%__install -D -m644 servers/slapd/back-ldap/TODO.proxy \
	%buildroot/%_docdir/%_bname-servers-%version/back-ldap/TODO.proxy
%__install -D -m644 servers/slapd/back-monitor/README \
	%buildroot/%_docdir/%_bname-servers-%version/back-monitor/README
%__install -D -m644 servers/slapd/back-null/README \
	%buildroot/%_docdir/%_bname-servers-%version/back-null/README
%if_enabled perl
%__install -D -m644 servers/slapd/back-perl/{README,SampleLDAP.pm} \
	%buildroot/%_docdir/%_bname-servers-%version/back-perl/
%endif
%if_enabled shell
%__install -D -m644 servers/slapd/back-shell/searchexample.{conf,sh} \
	%buildroot/%_docdir/%_bname-servers-%version/back-shell/
%endif

%if_enabled sql
%__install -D -m644 servers/slapd/back-sql/docs/* \
	%buildroot/%_docdir/%_bname-servers-%version/back-sql/
%__cp -r servers/slapd/back-sql/rdbms_depend \
	%buildroot/%_docdir/%_bname-servers-%version/back-sql/
%endif

%if_enabled slapi
%__install -pD -m644 servers/slapd/slapi/TODO \
        %buildroot/%_docdir/%_bname-servers-%version/slapi/TODO
%endif

%if_enabled overlay
%__install -pD -m644 servers/slapd/overlays/README \
        %buildroot/%_docdir/%_bname-servers-%version/overlays/README
%__install -pD -m644 servers/slapd/overlays/slapover.txt \
        %buildroot/%_docdir/%_bname-servers-%version/overlays/slapover.txt
%endif

%__install -p -m644 servers/slapd/schema/README \
	%buildroot/%_docdir/%_bname-servers-%version/schema/README
##slapd
%__install -p -m644 %SOURCE3 \
	%buildroot/%_docdir/%_bname-servers-%version/README.ALT
%__install -p -m644 %SOURCE4 \
	%buildroot/%_docdir/%_bname-servers-%version/config-README.ALT

%if_enabled doc
## Install Administration Guide 
%__mkdir_p %buildroot/%_docdir/%_bname-doc-%version/images
%__install -pD -m644 doc/guide/images/*.gif \
	%buildroot/%_docdir/%_bname-doc-%version/images
%__mkdir_p %buildroot/%_docdir/%_bname-doc-%version/admin-guide
#%__install -pD -m644 doc/guide/admin/*.gif \
#	%buildroot/%_docdir/%_bname-doc-%version/admin-guide/
%__install -pD -m644 doc/guide/admin/*.html \
	%buildroot/%_docdir/%_bname-doc-%version/admin-guide/
%__install -p -m644 doc/guide/admin/guide.txt \
	%buildroot/%_docdir/%_bname-doc-%version/
%endif

# Purge dependency_libs from .la files.
%__subst -p 's/^\(dependency_libs=\).*/\1'\'\'/ \
	%buildroot/%_libexecdir/%_bname/*.la

#======
# Relocate some shared libraries from %_libdir/ to /%_lib/.
%__mkdir_p %buildroot/%_lib
for n in ldap lber; do
	for f in %buildroot/%_libdir/lib$n.so; do
		t=`objdump -p "$f" |awk '/SONAME/ {print $2}'`
		[ -n "$t" ]
		%__ln_s -nf ../../%_lib/"$t" "$f"
	done
    %__mv %buildroot/%_libdir/lib$n-*.so.* %buildroot/%_lib/
done

%pre servers
# Take care to only do ownership-changing if we're adding the user.
/usr/sbin/groupadd -rf ldap
/usr/sbin/useradd  -rM -c "LDAP User" -g ldap -u 55 -s /dev/null -d %_localstatedir/ldap ldap &>/dev/null
if [ -d %_localstatedir/ldap/bases ]; then
	chown -R ldap:ldap %_localstatedir/ldap/bases
fi
if [ -d "$ldap_ssl_dir" -a ! -L "$ldap_ssl_dir" ]; then
	echo "Your certificates are moved to $ldap_ssl_dir.rpmsave, please CHECK!"
	%__mv "$ldap_ssl_dir" "$ldap_ssl_dir".rpmsave
fi	

%post servers
# remove old libs from chroot
rm -f /var/lib/ldap/%_libdir/openldap/*
rm -f /var/lib/ldap/%_libdir/sasl2/*
rm -f /var/lib/ldap/%_libdir/*.so*
rm -f /var/lib/ldap/%_lib/*.so*

%post_service slapd


%preun servers
%preun_service slapd


%files -n libldap
/%_lib/*.so.*
%_libdir/*.so.*

%files -n libldap-devel
%_libdir/*.so
%_includedir/*
%_man3dir/*
%doc doc/{drafts,rfc,devel}

%files -n libldap-devel-static
%_libdir/*.a

%files
%doc ANNOUNCEMENT CHANGES COPYRIGHT LICENSE README
%dir %_sysconfdir/%_bname
%config(noreplace) %_sysconfdir/%_bname/ldap.conf

%files servers
%_sysconfdir/chroot.d/ldap.all
%_sysconfdir/chroot.d/ldap.conf
%_sysconfdir/chroot.d/ldap.lib
%_sysconfdir/syslog.d/ldap
#config(noreplace) %_sysconfdir/logrotate.d/ldap

%dir %_sysconfdir/%_bname/schema
%_sysconfdir/%_bname/schema
%attr(750,root,ldap) %dir %_sysconfdir/%_bname/ssl

%config(noreplace) %_sysconfdir/%_bname/rootdse.ldif
%attr(-,root,ldap)%config(noreplace) %_sysconfdir/%_bname/slapd-access.conf
%attr(-,root,ldap)%config(noreplace) %_sysconfdir/%_bname/slapd-hdb-db01.conf
%attr(-,root,ldap)%config(noreplace) %_sysconfdir/%_bname/slapd-hdb-db02.conf
%attr(-,root,ldap)%config(noreplace) %_sysconfdir/%_bname/slapd.conf

%_initdir/slapd
%systemd_unitdir/slapd.service
%config(noreplace) %_sysconfdir/sysconfig/ldap

%_sbindir/slapacl
%_sbindir/slapadd
%_sbindir/slapauth
%_sbindir/slapcat
%_sbindir/slapd
%_sbindir/slapdn
%_sbindir/slapindex
%_sbindir/slappasswd
%_sbindir/slaptest
%_sbindir/slapschema

%_libexecdir/%_bname

%_man5dir/*
%_man8dir/*

%doc %_docdir/%_bname-servers-%version
#attr(0775,root,ldap) %dir %_logdir/ldap

%attr(0750,root,ldap) %dir %_localstatedir/ldap
%attr(1770,root,ldap) %dir %_localstatedir/ldap/bases
%attr(0640,root,ldap) %_localstatedir/ldap/bases/DB_CONFIG
%attr(1770,root,ldap) %_localstatedir/ldap/dblogs
%attr(0775,root,ldap) %_localstatedir/ldap/dev
%attr(0755,root,ldap) %_localstatedir/ldap/etc
%attr(0750,root,ldap) %_localstatedir/ldap/lib
%_localstatedir/ldap/lib64
%_localstatedir/ldap/usr
%_localstatedir/ldap/var
%attr(0775,root,ldap) %dir %_localstatedir/ldap/var/run

##### CLIENTS
%files clients
%_bindir/ldapadd
%_bindir/ldapcompare
%_bindir/ldapdelete
%_bindir/ldapmodify
%_bindir/ldapmodrdn
%_bindir/ldappasswd
%_bindir/ldapsearch
%_bindir/ldapwhoami
%_bindir/ldapexop
%_bindir/ldapurl
%_man1dir/*

%if_enabled doc
##### GUIDE
%files -n %_bname-doc
%_docdir/%_bname-doc-%version/*
%dir %_docdir/%_bname-doc-%version/
%endif

###
# TODO for 2.2.x
#
#[global] correct install all docs to %_docdir
#[global] Correct build with SASL(+++) Need tests
#[FR] Translate Admin Guide
#[FR] Translate LDAP Tools and add working in LOCALE Run-Time envirement.
#[FR] Make load modules correctly by dlopen without *.la files
#[global] Copy or not in back-meta/data directory (may be need to copy this data to Docs dir).
#[NeedBugFix] Remove TEXTREL from back-{modules}
#[global] What is back-tcl ?? man is here, but back modules isn't.
#[global] Generate slapd.conf according slapd.conf in source and man pages back-*
#[global] Create new config shema
#[FR] Import, may be, backup shema from MDK
#[global] Work on SSL/TLS cert dir!(+++) Need tests. 
#[FR] Correct patch for aacls for latest version
#[FR] Create separate package with OpenLDAP test for ALT Specific chroot env
#[FR] Create chroot-scripts dynamic while build package 

%changelog
