%def_disable static

Name: opensc
Version: 0.12.2
Release: alt2.1

Group: System/Configuration/Hardware
Summary: OpenSC library - for accessing SmartCard devices using PC/SC Lite
Url: http://www.opensc-project.org/
License: LGPL

Requires: lib%name = %version-%release

Source: %name-%version.tar
Patch1: opensc-0.12.2-alt-automake-1.11.4.patch
Patch2: opensc-0.12.2-alt-DSO.patch

BuildRequires: browser-plugins-npapi-devel

# Automatically added by buildreq on Sun Feb 07 2010
BuildRequires: db2latex-xsl docbook-dtds docbook-style-xsl libXt-devel libassuan0-devel libltdl7-devel libpcsclite-devel libreadline-devel libssl-devel xsltproc zlib-devel

%package -n lib%name
Group: System/Libraries
Summary: OpenSC library - for accessing SmartCard devices using PC/SC Lite
Requires: browser-plugins-npapi

%package -n lib%name-devel
Group: Development/Other
Summary: OpenSC development files
Requires: lib%name = %version-%release

%package -n lib%name-devel-static
Group: Development/Other
Summary: Static OpenSC libraries
Requires: lib%name-devel = %version-%release

%package -n pam_opensc
Group: System/Base
Summary: OpenSC module for PAM
License: GPL
Requires: lib%name = %version-%release

%description
libopensc is a library for accessing SmartCard devices using PC/SC
Lite middleware package. It is also the core library of the OpenSC
project. Basic functionality (e.g. SELECT FILE, READ BINARY) should
work on any ISO 7816-4 compatible SmartCard. Encryption and decryption
using private keys on the SmartCard is at the moment possible only
with PKCS#15 compatible cards, such as the FINEID (Finnish Electronic
IDentity) card manufactured by Setec.

%description -n lib%name
libopensc is a library for accessing SmartCard devices using PC/SC
Lite middleware package. It is also the core library of the OpenSC
project. Basic functionality (e.g. SELECT FILE, READ BINARY) should
work on any ISO 7816-4 compatible SmartCard. Encryption and decryption
using private keys on the SmartCard is at the moment possible only
with PKCS#15 compatible cards, such as the FINEID (Finnish Electronic
IDentity) card manufactured by Setec.

%description -n lib%name-devel
OpenSC development files.

%description -n lib%name-devel-static
Static OpenSC libraries.

%description -n pam_opensc
OpenSC module for PAM.

%prep
%setup
%patch1 -p2
%patch2 -p2

%build
%autoreconf
%add_optflags %optflags_shared
PCSC_SONAME="$(objdump -p "%_libdir/libpcsclite.so"| awk '/SONAME/ {print $2}')"
%configure \
     %{subst_enable static} \
    --enable-shared \
    --enable-pcsc \
    --with-pcsc-provider="%_libdir/$PCSC_SONAME" \
    --enable-nsplugin \
    --with-plugindir=%browser_plugins_path \
    --with-xsl-stylesheetsdir=/usr/share/xml/docbook/xsl-stylesheets \
    --with-pcsc-provider=libpcsclite.so.1 \
    --disable-assert

%make_build

%install
%makeinstall_std

mkdir -p %buildroot/%_sysconfdir/
install -p -m644 etc/opensc.conf %buildroot/%_sysconfdir/opensc.conf

pushd %buildroot/%_libdir
ln -s pkcs11/opensc-pkcs11.so .
ln -s pkcs11/pkcs11-spy.so .
ln -s pkcs11/onepin-opensc-pkcs11.so .
popd

%files
# %doc doc/nonpersistent/ChangeLog 
#%doc doc/nonpersistent/wiki.out
#%doc doc/html.out/tools.html
%doc NEWS README

%config(noreplace) %_sysconfdir/opensc.conf
%_bindir/opensc-tool
%_bindir/pkcs15-init
#%_bindir/rutoken-tool
#%_bindir/cardos-info
%_bindir/cardos-tool
%_bindir/pkcs15-tool
%_bindir/eidenv
%_bindir/opensc-explorer
%_bindir/netkey-tool
%_bindir/cryptoflex-tool
%_bindir/pkcs11-tool
%_bindir/piv-tool
%_bindir/pkcs15-crypt
%_bindir/westcos-tool
%doc %_mandir/*/*

%files -n lib%name
%_libdir/lib*.so.*
%_libdir/opensc-pkcs11.so*
%_libdir/pkcs11-spy.so*
%_libdir/onepin-opensc-pkcs11.so*
%dir %_libdir/pkcs11
%_libdir/pkcs11/pkcs11-spy.so
%_libdir/pkcs11/opensc-pkcs11.so
%_libdir/pkcs11/onepin-opensc-pkcs11.so
%dir %_datadir/opensc
%_datadir/opensc/*.profile
#%browser_plugins_path/opensc-signer.so
#%_libdir/opensc-signer.so*

%files -n lib%name-devel
#%doc doc/html.out/api.html
#%_libdir/pkgconfig/libopensc.pc
#%_libdir/pkgconfig/libpkcs15init.pc
#%_libdir/pkgconfig/libscconf.pc
#%_bindir/opensc-config
%_libdir/libopensc.so
#%_libdir/libpkcs11.so
#%_libdir/libpkcs15init.so
#%_libdir/libscconf.so
#%_libdir/libscldap.so
#%_libdir/libscrandom.a
#%_libdir/libscam.a
#%_libdir/libopensc.la
#%_libdir/libpkcs15init.la
#%_libdir/libscconf.la
#%_libdir/libscldap.la
#%_includedir/opensc

%if_enabled static
%files -n lib%name-devel-static
%_libdir/libopensc.a
%_libdir/libpkcs15init.a
%_libdir/libscconf.a
%_libdir/libscldap.a
%endif

#%files -n pam_opensc
#/lib/security/pam_opensc.so

%changelog
