Name: openssl098
Version: 0.9.8zh
Release: alt0.M70T.1

Summary: OpenSSL - Secure Sockets Layer and cryptography shared libraries and tools
License: BSD-style
Group: System/Base
Url: http://www.openssl.org

Source: ftp://ftp.openssl.org/source/openssl-%version.tar
Source1: openssl-config
Source2: Makefile.certificate
Source3: make-dummy-cert
Source4: ts-20060923.ChangeLog

Patch8: http://www.opentsa.org/ts/ts-20060923-0_9_8c.patch
Patch9: http://www.cryptocom.ru/OpenSource/openssl-asymm-0.9.8d-20061110.diff

Patch11: openssl-0.9.7g-owl-alt-issetugid.patch
Patch12: openssl-0.9.8s-alt-config.patch

Patch22: openssl-0.9.8m-rh-enginesdir.patch
Patch23: openssl-0.9.8a-rh-rpath.patch
Patch25: openssl-0.9.7g-rh-mdk-ia64-asm.patch
Patch26: openssl-0.9.7g-rh-version-engines.patch
Patch27: openssl-0.9.8a-rh-reuse-cipher-change.patch
Patch28: openssl-0.9.8g-rh-ipv6-apps.patch
Patch30: openssl-0.9.8b-rh-x509-name-cmp.patch
Patch31: openssl-0.9.6-rh-x509.patch
Patch32: openssl-0.9.8b-rh-test-use-localhost.patch
Patch33: openssl-0.9.8g-rh-default-paths.patch
Patch34: openssl-0.9.8g-rh-no-extssl.patch
Patch35: openssl-0.9.8s-alt-shlib-version.patch
Patch36: openssl-0.9.8g-rh-alt-soversion.patch
Patch38: openssl-0.9.8-pkcs12-fix.patch
Patch39: openssl-0.9.8l-up-x86_64-crypto-sha1.patch
Patch41: openssl-0.9.8n-alt-ssl-dtls1.patch

%if "%_lib" == "lib64"
%define lib_suffix ()(64bit)
%else
%define lib_suffix %nil
%endif
%define openssldir /var/lib/ssl
%define old_openssldir %_libdir/ssl
%def_enable compat
%def_without tsa
%def_without asymm
%def_with krb

BuildRequires: bc perl-Pod-Parser

%package -n libcrypto7
Summary: OpenSSL libcrypto shared library
Group: System/Legacy libraries
Provides: libcrypto = %version-%release
# due to openssl.cnf
Conflicts: libssl6 < 0:0.9.8d-alt6
# due to libssl split
Conflicts: libssl7 < 0:0.9.8k-alt3
# due to openssldir migration
Conflicts: openssl < 0:0.9.8d-alt1
Requires: ca-certificates
# Backwards compatibility with alien libssl packages.
Provides: libcrypto.so.0.9.8%lib_suffix

%package -n libssl7
Summary: OpenSSL libssl shared library
Group: System/Legacy libraries
Provides: libssl = %version
%{?_with_tsa:Provides: openssl-tsa = %version-%release}
%{?_with_krb:Provides: openssl-krb = %version-%release}
Requires: libcrypto7 = %version-%release
Provides: libssl8 = %version-%release
# Backwards compatibility with alien libssl packages.
Provides: libssl.so.0.9.8%lib_suffix

%package -n libssl-devel
Summary: OpenSSL include files and development libraries
Group: Development/C
Provides: openssl-devel = %version
Obsoletes: openssl-devel < %version
Requires: libssl7 = %version-%release
%{?_with_krb:Requires: libkrb5-devel}
# due to /usr/bin/openssl-config
Conflicts: openssl < %version-%release, openssl > %version-%release
# manpage clash: crypto(3).
Conflicts: erlang <= 0:R9C.0-alt2
%{?_with_tsa:Provides: openssl-tsa-devel = %version-%release}
%{?_with_krb:Provides: openssl-krb-devel = %version-%release}

%package -n libssl-devel-static
Summary: OpenSSL static libraries
Group: Development/C
Provides: openssl-devel-static = %version
Obsoletes: openssl-devel-static < %version
Requires: libssl-devel = %version-%release
%{?_with_tsa:Provides: openssl-tsa-devel-static = %version-%release}
%{?_with_krb:Provides: openssl-krb-devel-static = %version-%release}

%package -n openssl
Summary: OpenSSL tools
Group: System/Base
Provides: %openssldir
# due to /usr/bin/openssl-config
Conflicts: libssl-devel < %version-%release, libssl-devel > %version-%release
Requires: libssl7 = %version-%release
%if_with tsa
BuildRequires: perl-WWW-Curl
Provides: tsa-server = %version-%release
Provides: tsa-client = %version-%release
Requires: libssl-tsa = %version-%release
%endif
%{?_with_krb:BuildRequires: libkrb5-devel}

%package -n openssl-doc
Summary: OpenSSL documentation and demos
Group: Development/C
Requires: openssl = %version-%release
BuildArch: noarch

%package -n openssl-engines
Summary: OpenSSL ENGINE interface modules
Group: System/Libraries
Requires: libssl7 = %version-%release

%package -n tsget
Summary: Time Stamping HTTP/HTTPS client
Group: Security/Networking 
Requires: libssl-tsa = %version-%release

%description
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

%description -n libcrypto7
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the OpenSSL libcrypto shared library.

%description -n libssl7
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the OpenSSL libssl shared library.

%description -n libssl-devel
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the OpenSSL include files and development libraries
required when building OpenSSL-based applications.

%description -n libssl-devel-static
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains static libraries required when developing
OpenSSL-based statically linked applications.

%description -n openssl
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the base OpenSSL cryptography and SSL/TLS tools.

%description -n openssl-doc
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the OpenSSL cryptography and SSL/TLS extra
documentation and demos required when developing applications.

%description -n openssl-engines
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

With OpenSSL 0.9.6, a new component was added to support alternative
cryptography implementations, most commonly for interfacing with external
crypto devices (eg. accelerator cards).  This component is called ENGINE,
and its presence in OpenSSL 0.9.6 (and subsequent bug-fix releases) caused
a little confusion as 0.9.6** releases were rolled in two versions,
a "standard" and an "engine" version.  In development for 0.9.7, the
ENGINE code has been merged into the main branch and will be present in
the standard releases from 0.9.7 forwards.

There are currently built-in ENGINE implementations for the following
crypto devices:

    o CryptoSwift
    o Compaq Atalla
    o nCipher CHIL
    o Nuron
    o Broadcom uBSec

In addition, dynamic binding to external ENGINE implementations is now
provided by a special ENGINE called "dynamic".

%description -n tsget
The tsget command can be used for sending a time stamp request, as
specified in RFC 3161, to a time stamp server over HTTP or HTTPS and
storing the time stamp response in a file.  This tool cannot be used for
creating the requests and verifying responses, you can use the OpenSSL
ts(1) command to do that.  tsget can send several requests to the server
without closing the TCP connection if more than one requests are specified
on the command line.

%prep
%setup -n openssl-%version

%{?_with_tsa:%patch8 -p1}
%{?_with_asymm:%patch9 -p0}

%patch11 -p1
%patch12 -p1

%patch22 -p1
%patch23 -p1
%patch25 -p1
%patch26 -p1
%patch27 -p1
%patch28 -p1
#patch30 -p1
%patch31 -p1
%patch32 -p1
%patch33 -p1
%patch34 -p1
%patch35 -p1
%patch36 -p1
%patch38 -p1
%patch39 -p1
%patch41 -p1

find -type f -name \*.orig -delete

# Correct shared library name.
subst 's/\\\$(SHLIB_MAJOR)\.\\\$(SHLIB_MINOR)/\\$(VERSION)/g' Configure
subst 's/\${SHLIB_MAJOR}\.\${SHLIB_MINOR}/\${VERSION}/g' Makefile.org

# Correct compilation options.
%add_optflags -fno-strict-aliasing -Wa,--noexecstack
subst 's/-O\([0-9s]\>\)\?\( -fomit-frame-pointer\)\?\( -m.86\)\?/\\\$(RPM_OPT_FLAGS)/' \
	Configure

# Save timestamp during copy.
find -type f -name Makefile\* -print0 |
	xargs -r0 grep -FZl 'cp $$' -- |
	xargs -r0 subst -p 's/cp \$\$/cp -pv $$/g' --

# Fix libdir.
find -type f -name Makefile\* -print0 |
	xargs -r0 grep -Zl '/lib\>' -- |
	xargs -r0 subst -p 's,/lib\>\([^$]\|$\),/\${SLIB}\1,g' --

# Be more verbose.
subst -p 's/^\([[:space:]]\+\)@/\1/' Makefile*

%build
ADD_ARGS=%_os-%_arch
%ifarch %ix86
	ADD_ARGS=linux-elf
%ifarch i386
	ADD_ARGS="$ADD_ARGS 386"
%endif
%endif
%ifarch %arm
ADD_ARGS=linux-generic32
%endif

./Configure shared -DSSL_ALLOW_ADH \
	--prefix=%prefix \
	--libdir=%_lib \
	--openssldir=%openssldir \
	--enginesdir=%_libdir/openssl/engines \
%if_with krb
	--with-krb5-flavor=MIT \
	--with-krb5-dir=%prefix \
	--with-krb5-include=-I%_includedir/krb5 \
%endif
	$ADD_ARGS

# SMP-incompatible build.
make SLIB=%_lib SHLIB_SOVERSION=7

# Make soname symlinks.
/sbin/ldconfig -nv .

# Save library timestamps for later check.
touch -r libcrypto.so.%version libcrypto-stamp
touch -r libssl.so.%version libssl-stamp

LD_LIBRARY_PATH=`pwd` make rehash
LD_LIBRARY_PATH=`pwd` make test

%install
# The make_install macro doesn't work here.
make install \
	SLIB=%_lib \
	INSTALL_PREFIX=%buildroot \
	MANDIR=%_mandir

# Fail if one of shared libraries was rebuit.
if [ libcrypto.so.%version -nt libcrypto-stamp -o \
     libssl.so.%version -nt libssl-stamp ]; then
	echo 'Shared library was rebuilt by "make install".'
	exit 1
fi

# Fail if the openssl binary is statically linked against OpenSSL at this
# stage (which could happen if "make install" caused anything to rebuild).
LD_LIBRARY_PATH=`pwd` ldd %buildroot%_bindir/openssl |tee openssl.libs
grep -qw libssl openssl.libs
grep -qw libcrypto openssl.libs

# Install openssl-config script.
install -pDm755 %_sourcedir/openssl-config %buildroot%_bindir/openssl-config
subst -p 's,%%version,%version,g;s,%%openssldir,%openssldir,g' \
	%buildroot%_bindir/openssl-config

# Relocate shared libraries from %_libdir/ to /lib/.
mkdir -p %buildroot{/%_lib,%_libdir/openssl,%_sbindir}
for f in %buildroot%_libdir/*.so; do
	t=$(readlink "$f") || continue
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

# Add extra symlinks for Fedora compatibility.
ln -s ../../%_lib/libcrypto.so.%version %buildroot%_libdir/libcrypto.so.8
ln -s ../../%_lib/libssl.so.%version %buildroot%_libdir/libssl.so.8

# Add extra symlinks for Mandriva compatibility.
ln -s ../../%_lib/libcrypto.so.%version %buildroot%_libdir/libcrypto.so.0.9.8
ln -s ../../%_lib/libssl.so.%version %buildroot%_libdir/libssl.so.0.9.8

mv %buildroot%_libdir/engines %buildroot%_libdir/openssl/

# Relocate openssl.cnf from %%openssldir/ to %_sysconfdir/openssl/.
mkdir -p %buildroot%_sysconfdir/openssl
mv %buildroot%openssldir/openssl.cnf %buildroot%_sysconfdir/openssl/
ln -s `relative %_sysconfdir/openssl/openssl.cnf %openssldir/openssl.cnf` %buildroot%openssldir/

# Rename some man pages, fix references.
for f in passwd.1 err.3 rand.3 threads.3 config.5; do
	name="${f%%.*}"
	sect="${f##*.}"
	NAME=`printf %%s "$name" |tr '[:lower:]' '[:upper:]'`
	subst "s/\\<$NAME $sect\\>/SSL&/" %buildroot%_mandir/man"$sect/$f"
	mv -v %buildroot%_mandir/man"$sect"/{,ssl}"$f"
	find %buildroot%_mandir -type f -print0 |
		xargs -r0 grep -FZl "\\fI$name\\fR\\|($sect)" -- |
		xargs -r0 subst -p "s/\\\\fI$name\\\\fR\\\\|($sect)/\\\\fIssl$name\\\\fR\\\\|($sect)/" --
	find %buildroot%_mandir -type l |while read link; do
		[ "$(readlink -n "$link")" = "$f" ] || continue
		ln -sfv "ssl$f" "$link"
	done
done
ln -s sslconfig.5 %buildroot%_mandir/man5/openssl.cnf.5

# Make backwards-compatibility symlink to ssleay.
ln -snf openssl %buildroot%_bindir/ssleay

# Install a makefile for generating keys and self-signed certs,
# and a script for generating them on the fly.
install -pDm644 %_sourcedir/Makefile.certificate \
	%buildroot%openssldir/certs/Makefile
install -pDm644 %_sourcedir/make-dummy-cert \
	%buildroot%openssldir/certs/make-dummy-cert

# Install standard root certificates.
ln -s ../../..%_datadir/ca-certificates/ca-bundle.crt \
	%buildroot%openssldir/cert.pem

mv %buildroot%openssldir/misc/CA{.sh,}
rm %buildroot%openssldir/misc/CA.pl

%define docdir %_docdir/openssl-%version
mkdir -p %buildroot%docdir
%if_with tsa
mv %buildroot%openssldir/misc/tsget %buildroot%_sbindir/
install -pm644 %_sourcedir/ts-20060923.ChangeLog %buildroot%docdir/TSA-Changelog
%endif #with tsa
install -pm644 CHANGES* LICENSE NEWS README* %buildroot%docdir/
bzip2 -9 %buildroot%docdir/CHANGES*
cp -a demos doc %buildroot%docdir/
rm -rf %buildroot%docdir/doc/{apps,crypto,ssl}

%if_enabled compat
%pre -n openssl
[ $1 -gt 1 ] || exit 0
if [ ! -e %_sysconfdir/openssl -a ! -L %_sysconfdir/openssl -a -e %old_openssldir/openssl.cnf ]; then
	mkdir -p %_sysconfdir/openssl &&
	cp -a %old_openssldir/openssl.cnf %_sysconfdir/openssl/
fi
if [ ! -e %openssldir -a ! -L %openssldir -a -d %old_openssldir ]; then
	cp -a %old_openssldir %openssldir
fi
%endif #compat

%files -n libcrypto7
/%_lib/libcrypto*
%_libdir/libcrypto*.so.*
%config(noreplace) %_sysconfdir/openssl
%dir %openssldir
%openssldir/*.cnf
%openssldir/*.pem
%dir %docdir
%docdir/[A-Z]*

%files -n libssl7
/%_lib/libssl*
%_libdir/libssl*.so.*

%if 0
%files -n libssl-devel
%_bindir/openssl-config
%_libdir/*.so
%_libdir/pkgconfig/*
%_includedir/*

%files -n libssl-devel-static
%_libdir/*.a

%files -n openssl
%_bindir/*
%dir %openssldir
%openssldir/misc
%openssldir/certs
%dir %attr(700,root,root) %openssldir/private
%_mandir/man[157]/*
%if_with tsa
%exclude %_man1dir/tsget.*
%endif

%files -n openssl-doc
%dir %docdir
%docdir/[a-z]*
%_man3dir/*

%files -n openssl-engines
%_libdir/openssl

%if_with tsa
%files -n tsget
%_sbindir/tsget
%_man1dir/tsget.*
%endif
%endif

%changelog
