Name: openssl10
Version: 1.0.1u
Release: alt0.M70P.1

Summary: OpenSSL - Secure Sockets Layer and cryptography shared libraries and tools
License: BSD-style
Group: System/Base
Url: http://www.openssl.org

# git://git.altlinux.org/gears/o/openssl10.git
Source: openssl-%version.tar
Source1: openssl-config
Source2: Makefile.certificate
Source3: make-dummy-cert
Source4: cc.sh

Patch01: openssl-owl-alt-issetugid.patch
Patch02: openssl-alt-krb5.patch
Patch03: openssl-alt-config.patch
Patch04: openssl-alt-fips_premain_dso.patch
Patch05: openssl-gosta-pkcs12-fix.patch
Patch06: openssl-rh-alt-soversion.patch
Patch07: openssl-rh-enginesdir.patch
Patch08: openssl-rh-rpath.patch
Patch09: openssl-rh-test-use-localhost.patch
Patch11: openssl-rh-pod2man-timezone.patch
Patch12: openssl-rh-perlpath.patch
Patch13: openssl-rh-default-paths.patch
Patch14: openssl-rh-x509-issuer-hash.patch
Patch15: openssl-rh-X509_load_cert_file.patch
Patch16: openssl-rh-version-engines.patch
Patch18: openssl-rh-ipv6-apps.patch
Patch19: openssl-rh-env-zlib.patch
Patch21: openssl-rh-algo-doc.patch
Patch22: openssl-rh-apps-dgst.patch
Patch23: openssl-rh-alt-xmpp-starttls.patch
Patch24: openssl-rh-chil-fixes.patch
Patch25: openssl-rh-alt-secure-getenv.patch
Patch27: openssl-rh-padlock64.patch
Patch30: openssl-rh-disable-sslv2v3.patch

Patch84: openssl-rh-trusted-first.patch

%define shlib_soversion 10
%define openssldir /var/lib/ssl
%define old_openssldir %_libdir/ssl
%def_enable compat
%def_with krb

BuildRequires: /usr/bin/pod2man bc zlib-devel

%package -n libcrypto%shlib_soversion
Summary: OpenSSL libcrypto shared library
Group: System/Libraries
Provides: libcrypto = %version-%release
# due to openssl.cnf
Conflicts: libcrypto7 < 0.9.8o-alt3, libssl7 < 0.9.8o-alt3, libssl6 < 0.9.8d-alt6
# due to openssldir migration
Conflicts: openssl < 0:0.9.8d-alt1
# due to runtime openssl version check
Conflicts: openssh-common < 5.9p1-alt5
Requires: ca-certificates

%package -n libssl%shlib_soversion
Summary: OpenSSL libssl shared library
Group: System/Libraries
Provides: libssl = %version
%{?_with_krb:Provides: openssl-krb = %version-%release}
Requires: libcrypto%shlib_soversion = %version-%release

%package -n libssl-devel
Summary: OpenSSL include files and development libraries
Group: Development/C
Provides: openssl-devel = %version
Obsoletes: openssl-devel < %version
Requires: libssl%shlib_soversion = %version-%release
%{?_with_krb:Requires: libkrb5-devel}
# due to /usr/bin/openssl-config
Conflicts: openssl < %version-%release, openssl > %version-%release
# manpage clash: crypto(3).
Conflicts: erlang <= 0:R9C.0-alt2
%{?_with_krb:Provides: openssl-krb-devel = %version-%release}

%package -n libssl-devel-static
Summary: OpenSSL static libraries
Group: Development/C
Provides: openssl-devel-static = %version
Obsoletes: openssl-devel-static < %version
Requires: libssl-devel = %version-%release
%{?_with_krb:Provides: openssl-krb-devel-static = %version-%release}

%package -n openssl
Summary: OpenSSL tools
Group: System/Base
Provides: %openssldir
# due to /usr/bin/openssl-config
Conflicts: libssl-devel < %version-%release, libssl-devel > %version-%release
Requires: libssl%shlib_soversion = %version-%release
%{?_with_krb:BuildRequires: libkrb5-devel}

%package -n openssl-doc
Summary: OpenSSL documentation and demos
Group: Development/C
Requires: openssl = %version-%release
BuildArch: noarch

%package -n openssl-engines
Summary: OpenSSL ENGINE interface modules
Group: System/Libraries
Requires: libssl%shlib_soversion = %version-%release

%package -n tsget
Summary: Time Stamping HTTP/HTTPS client
Group: Security/Networking 
BuildArch: noarch
Requires: libssl%shlib_soversion = %version-%release
BuildRequires: perl-WWW-Curl

%description
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

%description -n libcrypto%shlib_soversion
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the OpenSSL libcrypto shared library.

%description -n libssl%shlib_soversion
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the OpenSSL libssl shared library.

%description -n libssl-devel
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the OpenSSL include files and development libraries
required when building OpenSSL-based applications.

%description -n libssl-devel-static
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains static libraries required when developing
OpenSSL-based statically linked applications.

%description -n openssl
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the base OpenSSL cryptography and SSL/TLS tools.

%description -n openssl-doc
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

This package contains the OpenSSL cryptography and SSL/TLS extra
documentation and demos required when developing applications.

%description -n openssl-engines
The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

With OpenSSL 0.9.6, a new component was added to support alternative
cryptography implementations, most commonly for interfacing with external
crypto devices (eg. accelerator cards).  This component is called ENGINE,
and its presence in OpenSSL 0.9.6 (and subsequent bug-fix releases) caused
a little confusion as 0.9.6** releases were rolled in two versions,
a "standard" and an "engine" version.  In development for 0.9.7, the
ENGINE code has been merged into the main branch and is present in
the standard releases from 0.9.7 forwards.

There are currently following built-in ENGINE implementations:
- 4758cca: IBM 4758 CCA hardware support;
- aep: Aep hardware support;
- atalla: Atalla hardware support;
- chil: CHIL hardware support;
- cswift: CryptoSwift hardware support;
- gost: GOST (Russian cryptography standard) implementation;
- nuron: Nuron hardware support;
- padlock: VIA PadLock ACE support;
- sureware: SureWare hardware support;
- ubsec: UBSEC hardware support.

In addition, dynamic binding to external ENGINE implementations is
provided by a special ENGINE called "dynamic".

%description -n tsget
The tsget command can be used for sending a time stamp request, as
specified in RFC 3161, to a time stamp server over HTTP or HTTPS and
storing the time stamp response in a file.  This tool cannot be used for
creating the requests and verifying responses, you can use the OpenSSL
ts(1) command to do that.  tsget can send several requests to the server
without closing the TCP connection if more than one requests are specified
on the command line.

%prep
%setup -n openssl-%version

%patch01 -p1
%patch02 -p1
%patch03 -p1
%patch04 -p1
%patch05 -p1
%patch06 -p1
%patch07 -p1
%patch08 -p1
%patch09 -p1

%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch18 -p1
%patch19 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p1
%patch27 -p1
%patch30 -p1

%patch84 -p1

find -type f -name \*.orig -delete

# Correct shared library name.
sed -i 's/@SHLIB_SOVERSION@/%shlib_soversion/g' Configure Makefile.*
sed -i 's/\\\$(SHLIB_MAJOR)\.\\\$(SHLIB_MINOR)/\\$(VERSION)/g' Configure
sed -i 's/\$(SHLIB_MAJOR)\.\$(SHLIB_MINOR)/\$(VERSION)/g' Makefile.org
sed -i 's/\(^#define[[:space:]]\+SHLIB_VERSION_NUMBER[[:space:]]\+\).*/\1"%version"/' crypto/opensslv.h

# Correct compilation options.
%add_optflags -fno-strict-aliasing -Wa,--noexecstack
sed -i 's/-O\([0-9s]\>\)\?\( -fomit-frame-pointer\)\?\( -m.86\)\?/\\\$(RPM_OPT_FLAGS)/' \
	Configure

# Be more verbose.
sed -i 's/^\([[:space:]]\+\)@[[:space:]]*/\1/' Makefile*

%build
ADD_ARGS=%_os-%_arch
%ifarch %ix86
	ADD_ARGS=linux-elf
%ifarch i386
	ADD_ARGS="$ADD_ARGS 386"
%endif
%endif
%ifarch %arm
ADD_ARGS=linux-generic32
%endif

if echo 'extern __uint128_t i;' |
   gcc %optflags -Werror -c -o/dev/null -xc -; then
	ADD_ARGS="enable-ec_nistp_64_gcc_128 $ADD_ARGS"
fi

./Configure shared \
	--prefix=%prefix \
	--libdir=%_lib \
	--openssldir=%openssldir \
	--enginesdir=%_libdir/openssl/engines \
%if_with krb
	--with-krb5-flavor=MIT \
	--with-krb5-dir=%prefix \
%endif
	enable-md2 \
	enable-ssl2 \
	enable-rfc3779 \
	zlib \
	$ADD_ARGS

# SMP-incompatible build.
make

# Make soname symlinks.
/sbin/ldconfig -nv .

# Save library timestamps for later check.
touch -r libcrypto.so.%version libcrypto-stamp
touch -r libssl.so.%version libssl-stamp

LD_LIBRARY_PATH=`pwd` make rehash

%install
# The make_install macro doesn't work here.
make install \
	CC=%_sourcedir/cc.sh \
	INSTALL_PREFIX=%buildroot \
	MANDIR=%_mandir

# Fail if one of shared libraries was rebuit.
if [ libcrypto.so.%version -nt libcrypto-stamp -o \
     libssl.so.%version -nt libssl-stamp ]; then
	echo 'Shared library was rebuilt by "make install".'
	exit 1
fi

# Fail if the openssl binary is statically linked against OpenSSL at this
# stage (which could happen if "make install" caused anything to rebuild).
LD_LIBRARY_PATH=`pwd` ldd %buildroot%_bindir/openssl |tee openssl.libs
grep -qw libssl openssl.libs
grep -qw libcrypto openssl.libs

# Install openssl-config script.
install -pDm755 %_sourcedir/openssl-config %buildroot%_bindir/openssl-config
subst -p 's,%%version,%version,g;s,%%openssldir,%openssldir,g' \
	%buildroot%_bindir/openssl-config

# Relocate shared libraries from %_libdir/ to /lib/.
mkdir -p %buildroot{/%_lib,%_libdir/openssl,%_sbindir}
for f in %buildroot%_libdir/*.so; do
	t=$(readlink "$f") || continue
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

# Relocate engines.
mv %buildroot%_libdir/engines %buildroot%_libdir/openssl/

# Relocate openssl.cnf from %%openssldir/ to %_sysconfdir/openssl/.
mkdir -p %buildroot%_sysconfdir/openssl
mv %buildroot%openssldir/openssl.cnf %buildroot%_sysconfdir/openssl/
ln -s `relative %_sysconfdir/openssl/openssl.cnf %openssldir/openssl.cnf` %buildroot%openssldir/

# Rename some man pages, fix references.
for f in passwd.1 err.3 rand.3 threads.3 config.5; do
	name="${f%%.*}"
	sect="${f##*.}"
	NAME=`printf %%s "$name" |tr '[:lower:]' '[:upper:]'`
	sed -i "s/\\<$NAME $sect\\>/SSL&/" %buildroot%_mandir/man"$sect/$f"
	mv -v %buildroot%_mandir/man"$sect"/{,ssl}"$f"
	find %buildroot%_mandir -type f -print0 |
		xargs -r0 grep -FZl "\\fI$name\\fR\\|($sect)" -- |
		xargs -r0 subst -p "s/\\\\fI$name\\\\fR\\\\|($sect)/\\\\fIssl$name\\\\fR\\\\|($sect)/" --
	find %buildroot%_mandir -type l |while read link; do
		[ "$(readlink -n "$link")" = "$f" ] || continue
		ln -sfv "ssl$f" "$link"
	done
done
ln -s sslconfig.5 %buildroot%_mandir/man5/openssl.cnf.5

# Make backwards-compatibility symlink to ssleay.
ln -snf openssl %buildroot%_bindir/ssleay

# Install a makefile for generating keys and self-signed certs,
# and a script for generating them on the fly.
install -pDm644 %_sourcedir/Makefile.certificate \
	%buildroot%openssldir/certs/Makefile
install -pDm644 %_sourcedir/make-dummy-cert \
	%buildroot%openssldir/certs/make-dummy-cert

# Install standard root certificates.
ln -s ../../..%_datadir/ca-certificates/ca-bundle.crt \
	%buildroot%openssldir/cert.pem

mv %buildroot%openssldir/misc/CA{.sh,}
rm %buildroot%openssldir/misc/CA.pl

mv %buildroot%openssldir/misc/tsget %buildroot%_sbindir/

%define docdir %_docdir/openssl-%version
mkdir -p %buildroot%docdir
install -pm644 CHANGES* LICENSE NEWS README* engines/ccgost/README.gost \
	%buildroot%docdir/
bzip2 -9 %buildroot%docdir/CHANGES*
cp -a demos doc %buildroot%docdir/
rm -rf %buildroot%docdir/doc/{apps,crypto,ssl}

%check
LD_LIBRARY_PATH=%buildroot/%_lib make test

%if_enabled compat
%pre -n openssl
[ $1 -gt 1 ] || exit 0
if [ ! -e %_sysconfdir/openssl -a ! -L %_sysconfdir/openssl -a -e %old_openssldir/openssl.cnf ]; then
	mkdir -p %_sysconfdir/openssl &&
	cp -a %old_openssldir/openssl.cnf %_sysconfdir/openssl/
fi
if [ ! -e %openssldir -a ! -L %openssldir -a -d %old_openssldir ]; then
	cp -a %old_openssldir %openssldir
fi
%endif #compat

%files -n libcrypto%shlib_soversion
/%_lib/libcrypto*
%config(noreplace) %_sysconfdir/openssl
%dir %openssldir
%openssldir/*.cnf
%openssldir/*.pem
%dir %docdir
%docdir/[A-Z]*

%files -n libssl%shlib_soversion
/%_lib/libssl*

%files -n libssl-devel
%_bindir/openssl-config
%_libdir/*.so
%_libdir/pkgconfig/*
%_includedir/*

%files -n libssl-devel-static
%_libdir/*.a

%files -n openssl
%_bindir/*
%dir %openssldir
%openssldir/misc
%openssldir/certs
%dir %attr(700,root,root) %openssldir/private
%_mandir/man[157]/*
%exclude %_man1dir/tsget.*

%files -n openssl-doc
%dir %docdir
%docdir/[a-z]*
%_man3dir/*

%files -n openssl-engines
%_libdir/openssl

%files -n tsget
%_sbindir/tsget
%_man1dir/tsget.*

%changelog
