Name: osec
Version: 1.2.5
Release: alt3

Summary: Lightweight file permission checker
License: GPL3
Group: System/Base
Url: https://sourceforge.net/projects/o-security/
Packager: Alexey Gladkov <legion@altlinux.ru>

Source: osec-%version.tar

PreReq: shadow-utils

Provides: mtree-sec = %version-%release
Obsoletes: mtree-sec

%define osec_statedir /var/lib/osec
%define osec_group osec
%define osec_user osec

# Automatically added by buildreq on Sat Apr 21 2007 (-bi)
BuildRequires: flex bison help2man libcdb-devel libcap-devel libattr-devel perl-RPM

%package cronjob
Summary: General cron framework for osec
Requires: %name = %version-%release
Requires: %name-reporter
Group: System/Base

%package mailreport
Summary: Collection of reporters for osec
Group: System/Base
Provides: %name-reporter
Requires: %name = %version-%release
Requires: %name-cronjob
Requires: /bin/mail
Requires: perl-base
PreReq: coreutils

%description
This package contains osec program which performs files integrity check
by traversing filesystem and making human readable reports about changes
and found files/directories with suspicious ownership or permissions.

%description cronjob
This package contains a general framework for osec pipelines.

%description mailreport
This package contains a set of reporters to use with osec:
osec_reporter - creates human readable reports;
osec_mailer - send mail only if some changes was detected;
osec_rpm_reporter - additional filter for osec_reporter,
add name of rpm packages for files in report.

%prep
%setup -q

%build
%autoreconf
%configure
%make_build

%install
%makeinstall

cd %buildroot
#cron job file
mkdir -p -- etc/cron.d .%_datadir/osec
mv -- .%_datadir/osec.cron .%_datadir/osec/
echo '0 0 * * * root %_datadir/osec/osec.cron' > etc/cron.d/osec

#configs
mkdir -pm700 -- etc/osec
mv -- etc/dirs.conf .%_datadir/pipe.conf etc/osec/
chmod 600 -- etc/osec/*.conf

#install directory for the databases
mkdir -p -- .%osec_statedir

%pre
/usr/sbin/groupadd -r -f %osec_group
/usr/sbin/useradd -r -g %osec_group -d /dev/null -s /dev/null -n %osec_user >/dev/null 2>&1 ||:

%triggerpostun -- %name < 0:1.0.0-alt1
rm -f %osec_statedir/osec.db.*

%files
%doc ChangeLog NEWS README src/restore data/osec-recheck
%_bindir/osec
%_bindir/osec2txt
%_bindir/txt2osec
%_bindir/osec-migrade-db
%_man1dir/*

%files cronjob
%config(noreplace) /etc/cron.d/osec
%attr(700,root,root) %_datadir/osec/osec.cron
%defattr(600,root,root,700)
%config(noreplace) /etc/osec

%files mailreport
%_bindir/osec_mailer
%_bindir/osec_reporter
%_bindir/osec_rpm_reporter
%attr(770,root,%osec_group) %osec_statedir

%changelog
