%def_without doc-admin-de

%define installdir %webserver_webappsdir/%name
%define otrs_user otrs

Name: otrs
Version: 3.2.6
Release: alt2

Summary: Open source Ticket Request System
Group: Networking/WWW
License: AGPLv3
Url: http://www.otrs.org/

Packager: Pavel Zilke <zidex at altlinux dot org>

BuildArch: noarch

Requires(pre): %{_sbindir}/useradd
Requires(post): perl
Requires: webserver-common perl-CGI perl-DBI perl-DBD-mysql perl-Crypt-PasswdMD5 perl-Net-DNS perl-ldap perl-GD perl-GD-Text perl-GD-Graph perl-PDF-API2 perl-Compress-Zlib perl-Unicode-Normalize perl-Term-ANSIColor perl-TimeDate perl-YAML-LibYAML
BuildRequires(pre): rpm-macros-webserver-common rpm-macros-apache2 >= 3.9
BuildRequires: perl-CGI perl-DBI perl-DBD-mysql perl-Crypt-PasswdMD5 perl-Net-DNS perl-ldap perl-GD perl-GD-Text perl-GD-Graph perl-PDF-API2 perl-Compress-Zlib

Source0: %name-%version.tar.gz
Source1: README.ALT
Source2: otrs-hold.conf
Source3: apache2.conf

Patch: patch0.patch

%add_findreq_skiplist */bin/*
%add_findreq_skiplist */Kernel/*
%add_findreq_skiplist */scripts/*

%description
OTRS is an Open source Ticket Request System (also well known as trouble ticket system)
with many features to manage customer telephone calls and e-mails.
The system is built to allow your support, sales, pre-sales, billing,
internal IT, helpdesk, etc. department to react quickly to inbound inquiries.

%package apache2
Summary: Apache 2.x web-server configuration for %name
Group: Networking/WWW
Requires: %name = %version-%release, apache2, apache2-mod_perl perl-Apache-DBI
%description apache2
Apache 2.x web-server configuration for %name

%package doc-admin-en-pdf
Summary: %name admin manual (En)
Group: Networking/WWW
%description doc-admin-en-pdf
%name admin manual (En)

%if_with doc-admin-de
%package doc-admin-de-pdf
Summary: %name admin manual (De)
Group: Networking/WWW
%description doc-admin-de-pdf
%name admin manual (De)
%endif

%prep
%setup
%patch -p0

%install
# install apache config
install -pD -m0644 %SOURCE3 %buildroot%_sysconfdir/httpd2/conf/addon.d/A.%name.conf

# install apt's hold file
install -pD -m0644 %SOURCE2 %buildroot%_sysconfdir/apt/apt.conf.d/%name-hold.conf

# install otrs
mkdir -p %buildroot%installdir
cp -rp * %buildroot%installdir/

#install docs
chmod -x CHANGES
install -pD -m0644 %SOURCE1 README.ALT
mv %buildroot%installdir/doc/OTRSDatabaseDiagram.mwb OTRSDatabaseDiagram.mwb
mv %buildroot%installdir/doc/OTRSDatabaseDiagram.png OTRSDatabaseDiagram.png
mv %buildroot%installdir/doc/manual/en/otrs_admin_book.pdf admin_en.pdf
%if_with doc-admin-de
mv %buildroot%installdir/doc/manual/de/otrs_admin_book.pdf admin_de.pdf
%endif

#replace '/opt/otrs' to '/var/www/webapps/otrs' in all files
find %buildroot%installdir -type f -exec sed -i -e "s/\/opt\/otrs/\/var\/www\/webapps\/otrs/g" {} \;

# remove files
find %buildroot%installdir -name *.spec -delete
find %buildroot%installdir -name *.conf -delete

#install default config
cp %buildroot%installdir/Kernel/Config.pm.dist %buildroot%installdir/Kernel/Config.pm
cd %buildroot%installdir/Kernel/Config/
for foo in *.dist; do cp $foo `basename $foo .dist`; done
cd %buildroot%installdir/var/cron/
for foo in *.dist; do cp $foo `basename $foo .dist`; done

# all needed files packaged from %%builddir
rm -f %buildroot%installdir/ARCHIVE
rm -f %buildroot%installdir/CHANGES
rm -f %buildroot%installdir/COPYING-Third-Party
rm -f %buildroot%installdir/CREDITS
rm -f %buildroot%installdir/Custom/README
rm -f %buildroot%installdir/INSTALL.md
rm -f %buildroot%installdir/INSTALL.RedHat
rm -f %buildroot%installdir/INSTALL.SuSE
rm -f %buildroot%installdir/README.*
rm -f %buildroot%installdir/UPGRADING.md

%pre
if id %otrs_user >/dev/null 2>&1; then
    # update groups
    usermod -g %webserver_group %otrs_user
    # update home dir
    usermod -d %installdir %otrs_user
else
   %_sbindir/useradd -r  -g %webserver_group -c 'OTRS User' -d %installdir -s '/dev/null' %otrs_user >/dev/null 2>&1 ||:
fi

%post
cd %installdir/bin/
./otrs.SetPermissions.pl --otrs-user=%otrs_user --web-user=root --otrs-group=%webserver_group --web-group=%webserver_group %installdir >/dev/null 2>&1
#./Cron.sh start %otrs_user >/dev/null 2>&1

%postun
rm -rf %_docdir/%name-%version/

%post apache2
%post_apache2_rpma2chkconfigfile

%postun apache2
%post_apache2_rpma2chkconfigfile

%files
%doc COPYING
%doc RELEASE
%doc CHANGES
%doc COPYING-Third-Party
%doc OTRSDatabaseDiagram.mwb
%doc OTRSDatabaseDiagram.png
%doc README.*
%doc UPGRADING.md
%doc Custom/README
%defattr(0775,root, %webserver_group)
%dir %installdir
%config(noreplace) %attr(0660,root,%webserver_group) %installdir/Kernel/Config.pm
%config(noreplace) %attr(0660,root,%webserver_group) %installdir/Kernel/Config/GenericAgent.pm
%installdir/bin
%installdir/Kernel
%installdir/scripts
%installdir/doc
%installdir/var
%installdir/COPYING
%installdir/RELEASE

%config(noreplace) %attr(0644,root,root) %_sysconfdir/apt/apt.conf.d/%name-hold.conf

%files apache2
%config(noreplace) %attr(0644,root,root) %_sysconfdir/httpd2/conf/addon.d/A.%name.conf

%files doc-admin-en-pdf
%doc admin_en.pdf

%if_with doc-admin-de
%files doc-admin-de-pdf
%doc admin_de.pdf
%endif

%changelog
