Name: p7zip
Version: 9.20.1
Release: alt1

Summary: 7zip unofficial port - a file-archiver with highest compression ratio
License: Freely distributable
Group: Archiving/Compression

Url: http://p7zip.sourceforge.net/
Source: http://downloads.sourceforge.net/p7zip/p7zip_%{version}_src_all.tar.bz2

# Automatically added by buildreq on Sat Oct 08 2011
# optimized out: libstdc++-devel
BuildRequires: gcc-c++

%description
p7zip is a port of 7-Zip for Unix. 7-Zip is a file archiver
with a very high compression ratio.

%package standalone
Summary: Standalone p7zip executable without plugins
Group: Archiving/Compression
License: LGPLv2.1+
Requires: p7zip

%description standalone
p7zip is a port of 7-Zip for Unix. 7-Zip is a file archiver
with a very high compression ratio.

This package contains standalone version of p7zip.
It handles less archive formats than plugin capable version.

%prep
%setup -n p7zip_%version

%build
# Make p7zip looks for plugins in fixed directory. Upstream behavior was to
# look in current directory by default (when environment variable P7ZIP_HOME_DIR
# is not set)
find . -name '*.cpp' -exec \
subst 's@getenv("P7ZIP_HOME_DIR")@"%_libdir/p7zip/"@g' {} \;

# NB: 'all' is not default target in this makefile
%make_build OPTFLAGS="%optflags" all2

# NB: Someday I probably should build and package 7zG (7z GUI), but for now
# this GUI is far from useful.

%install
./install.sh %_bindir %_libdir/p7zip %_mandir %_docdir/%name-%version %buildroot
# Install script put shell wrappers in /usr/bin/ instead of executables.
# We don't want this, see comments to inline patch above to get idea of our way.
mv -f %buildroot%_libdir/p7zip/{7z,7za} %buildroot%_bindir/

# fixed in 9.20.1
#cp -a bin/Codecs %buildroot%_libdir/p7zip/

%files
%doc README ChangeLog DOCS
%_bindir/7z
%dir %_libdir/p7zip
%_libdir/p7zip/*.so
%_libdir/p7zip/*.sfx
%_libdir/p7zip/Codecs
%_man1dir/7z.*
%exclude %_man1dir/7zr.*

%files standalone
%_bindir/7za
%_man1dir/7za.*

%changelog
