%define git_commit 609b2f5 

%define branch_point alt0
%define branch M70P
%define revision 1

Summary: The New Moon browser, an unofficial branding of the Pale Moon project browser
Summary(ru_RU.UTF-8): Интернет-браузер New Moon - неофициальная сборка браузера Pale Moon

Name: palemoon
Version: 27.8.3
Release: %branch_point.%branch.%revision

License: MPL/GPL/LGPL
Group: Networking/WWW

# git commit 609b2f53c5bbd98064d5c59c3d772b59b6a076f6
Url: https://github.com/MoonchildProductions/Pale-Moon
Epoch: 2

%define sname palemoon
%define bname newmoon

Packager: Hihin Ruslan <ruslandh@altlinux.ru>


%define palemoon_cid                    \{8de7fcbb-c55c-4fbe-bfc5-fc555c87dbc4\}

%define palemoon_prefix                 %_datadir/%bname-data
%define palemoon_datadir                %_datadir/%bname-data
%define palemoon_bindir                 %_libdir/%bname-base
%define palemoon_arch_extensionsdir     %palemoon_bindir/extensions
%define palemoon_noarch_extensionsdir   %palemoon_datadir/extensions

Source: %sname-source-%version-%release.tar
Source1: rpm-build.tar
Source2: defaults-newmoon.tar

Source4: %sname-mozconfig
Source6: %bname.desktop
Source7: firefox.c
Source8: firefox-prefs.js
Source9: HISTORY_GIT
Source10: Changelog
Source11: content.tar

Source12: xulstore.json
Source13: kde.js

#Patch1: palemoon_google_add-26.4.0.patch
Patch5: firefox-duckduckgo.patch
Patch6: firefox3-alt-disable-werror.patch
#Patch14:	firefox-fix-install.patch
Patch16: firefox-cross-desktop.patch
#Patch17:	mozilla-disable-installer.patch
# Patch18: mozilla_palimoon-bug-1153109-enable-stdcxx-compat.patch
Patch20: mozilla_palimoon-bug-1025605-GLIBCXX-26.0.0.patch
Patch21: palemoon-build-el5-nss.patch
Patch22: palemoon_rpath-27.5.0_v2.patch

Patch23: palemoon_version-27.5.0.patch
Patch24: palemoon-27.0.2-ui_picker_false.patch
#Patch25: palemoon-27.4.0-blocklist.patch

# Patch from Rosa
# Patch101: palemoon-27.4.0-lang.patch
Patch103: palemoon-27.4.0-disable-check-default-browser.patch
Patch105: firefox-3.5.3-default-mail-handler.patch
Patch106: palemoon-27.4.0-enable-addons.patch
Patch107: palemoon-27.6.1-user-agent-overrides.patch

# Patches for KDE integration of New Moon
Patch111: palemoon-27.3.0-firefox-kde.patch
Patch112: palemoon-27.4.0-mozilla-kde.patch
Patch113: mozilla-kde-background.patch

%set_gcc_version 4.7
%set_autoconf_version 2.13

# Automatically added by buildreq on Sun Aug 06 2017
# optimized out: alternatives ca-certificates fontconfig fontconfig-devel glib2-devel libICE-devel libSM-devel libX11-devel libXext-devel libXrender-devel libatk-devel libcairo-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libpango-devel libstdc++-devel libwayland-client libwayland-server pkg-config python-base python-devel python-modules python-modules-compiler python-modules-ctypes python-modules-curses python-modules-email python-modules-encodings python-modules-logging python-modules-multiprocessing python-modules-xml xorg-kbproto-devel xorg-renderproto-devel xorg-scrnsaverproto-devel xorg-xextproto-devel xorg-xproto-devel
BuildRequires: doxygen gcc-c++ glibc-devel-static imake java-devel libGConf-devel libXScrnSaver-devel libXt-devel libalsa-devel
BuildRequires: libgtk+2-devel
BuildRequires: python-module-yaml python-modules-json python-modules-wsgiref

BuildRequires: unzip wget xorg-cf-files yasm zip

BuildRequires: libpulseaudio-devel

BuildRequires(pre): mozilla-common-devel
BuildRequires(pre): browser-plugins-npapi-devel

BuildPreReq: python-module-yaml python-modules-json python-modules-wsgiref
BuildRequires: gcc%_gcc_version-c++

BuildPreReq: chrpath
BuildPreReq: autoconf_%_autoconf_version

BuildPreReq: gstreamer1.0-devel gst-plugins1.0-devel

%description
The %sname project is a redesign of Mozilla's  Firefox browser component,
written using the XUL user interface language and designed to be
cross-platform.

%description -l ru_RU.UTF8
Интернет-браузер %sname - кроссплатформенная модификация браузера Mozilla Firefox ,
созданная с использованием языка XUL для описания интерфейса пользователя.

%package -n newmoon-base
Summary: The New Moon browser, an unofficial branding of the Pale Moon project browser
Summary(ru_RU.UTF-8): Интернет-браузер New Moon - неофициальная сборка браузера Pale Moon
Group: Networking/WWW

Obsoletes: palemoon  <= 26.2.2
Provides:  palemoon = %EVR
Provides:  webclient

Conflicts: newmoon < 27.1.2
Obsoletes: newmoon < 27.1.2
Provides: newmoon = %EVR

Requires: libgstreamer1.0 gst-libav
Requires: gst-plugins-base1.0
Requires: newmoon-data = %EVR

# Protection against fraudulent DigiNotar certificates
Requires: libnss

%description -n newmoon-base
The New Moon browser, an unofficial branding of the Pale Moon project browser
The %sname project is a redesign of Mozilla's  Firefox browser component,
written using the XUL user interface language and designed to be
cross-platform.

%description -n newmoon-base -l ru_RU.UTF8
Интернет-браузер New Moon - неофициальная сборка браузера Pale Moon
Интернет-браузер %sname - кроссплатформенная модификация браузера Mozilla Firefox ,
созданная с использованием языка XUL для описания интерфейса пользователя.

%package -n newmoon-data
Summary: The New Moon browser (noarch) , an unofficial branding of the Pale Moon project browser
Summary(ru_RU.UTF-8): Интернет-браузер New Moon (архитектуронезависимая часть)  - неофициальная сборка браузера Pale Moon
Group: Networking/WWW
BuildArch: noarch

#Provides: newmoon = %EVR
Conflicts: newmoon < %EVR
Obsoletes: newmoon < %EVR

%description -n newmoon-data
The New Moon browser, an unofficial branding of the Pale Moon project browser
The %sname project is a redesign of Mozilla's  Firefox browser component,
written using the XUL user interface language and designed to be
cross-platform.

%description -n newmoon-data -l ru_RU.UTF8
Интернет-браузер New Moon - неофициальная сборка браузера (архитектуронезависимая часть)  Pale Moon
Интернет-браузер %sname - кроссплатформенная модификация браузера Mozilla Firefox ,
созданная с использованием языка XUL для описания интерфейса пользователя.

%package -n rpm-build-palemoon
Summary: RPM helper macros to rebuild %name packages
Group: Development/Other
BuildArch: noarch

Requires: mozilla-common-devel
Requires: rpm-build-mozilla.org

%description -n rpm-build-palemoon
These helper macros provide possibility to rebuild
%sname packages by some Alt Linux Team Policy compatible way.

%prep
# Add fake RPATH
#export LDFLAGS="-Wl,-rpath,%palemoon_prefix"
#export LD_LIBRARY_PATH="-Wl,-rpath,%palemoon_prefix"
rpath="/$(printf %%s '%palemoon_prefix' |tr '[:print:]' '_')"
export LDFLAGS="$LDFLAGS -Wl,-rpath,$rpath"

# for  palemoon_rpath-27.0.2.patch
export RPATH_PATH="$rpath"

%setup -n %sname-%version -c
%setup -T -D -a 2
%setup -T -D -a 11

%patch20 -p1
%patch24 -p1
#patch26 -p1

%patch21 -p1

cd %sname

tar -xf %SOURCE1

#patch5  -p1
#patch14 -p1
#patch17 -p1

%patch6  -p1
%patch16 -p1
%patch22 -p1
%patch23 -p1

#patch18 -p1

#Pach from Rosa
#patch101 -p1 -b .lang
%patch103 -p1 -b .disable-software-update
%patch105 -p1 -b .default-mail-handler
%patch106 -p1 -b .addons
%patch107 -p1 -b .ua

# KDE integration
%patch111 -p1 -b .kdepatch
%patch112 -p1 -b .kdemoz
%patch113 -p1 -b .kdebackground

# icons
for s in 16 22 24 32 48 256; do
	install -D -m 644 \
		../defaults-newmoon/default$s.png \
		browser/branding/unofficial/
done

cat >> browser/confvars.sh <<EOF
MOZ_UPDATER=
MOZ_JAVAXPCOM=
MOZ_EXTENSIONS_DEFAULT=' gio'
MOZ_CHROME_FILE_FORMAT=jar
EOF

echo %version > browser/config/version.txt

%__subst s~'$(MOZ_APP_NAME)-$(MOZ_APP_VERSION)'~'$(MOZ_APP_NAME)$(MOZ_APP_VERSION)'~g  ./config/baseconfig.mk
#subst s~'Moonchild Productions'~'Moonchild_Productions'~g  ./build/application.ini
#subst s~'Pale Moon'~'Pale_Moon'~g  ./build/application.ini

%__subst s~'"Moonchild Productions"'~'"Moonchild_Productions"'~g  ./build/application.ini
%__subst s~'"Pale Moon"'~'"Pale_Moon"'~g  ./build/application.ini

cp -f %SOURCE4 .mozconfig

echo "ac_add_options --enable-rpath"  >> .mozconfig


%ifnarch %ix86 x86_64
echo "ac_add_options --disable-methodjit" >> .mozconfig
echo "ac_add_options --disable-monoic" >> .mozconfig
echo "ac_add_options --disable-polyic" >> .mozconfig
echo "ac_add_options --disable-tracejit" >> .mozconfig
%endif

echo "ac_add_options --disable-static" >> .mozconfig
# echo "ac_add_options --enable-media-plugins --disable-elf-hack --enable-media-plugins --enable-media-navigator" >> .mozconfig
# echo "ac_add_options --with-system-libvpx --enable-wave --enable-alsa --enable-pulseaudio" >> .mozconfig
# echo "ac_add_options --enable-system-cairo" >> .mozconfig
echo "ac_add_options --with-x" >> .mozconfig
echo "ac_add_options --enable-release" >> .mozconfig
echo "ac_add_options --enable-wave --enable-alsa --enable-pulseaudio" >> .mozconfig

# echo "ac_add_options --enable-system-hunspell" >> .mozconfig

# Add  Ofiicial Options:
#  --enable-shared-js --enable-jemalloc --enable-jemalloc-lib --with-pthreads --x-libraries=%_libexecdir/X11
echo "ac_add_options --with-pthreads" >> .mozconfig
echo "ac_add_options --enable-shared-js"  >> .mozconfig
# echo "ac_add_options --enable-jemalloc --enable-jemalloc-lib" >> .mozconfig
echo "ac_add_options --x-libraries=%_libexecdir/X11" >> .mozconfig
# echo "ac_add_options --sharedstatedir=%_datadir" >> .mozconfig
echo "ac_add_options --datadir=%_datadir" >> .mozconfig


# echo "ac_add_options --with-system-nss"  >> .mozconfig

echo "ac_add_options --with-nss-prefix=$RPATH_PATH" >> .mozconfig

# echo "ac_add_options --with-nss-prefix=%_libdir" >> .mozconfig

%ifarch %ix86
echo "ac_add_options --with-arch=i586 " >> .mozconfig
echo 'ac_add_options --enable-optimize="-O2 -msse2 -mfpmath=sse" ' >> .mozconfig
%endif

echo "ac_add_options --enable-gstreamer" >> .mozconfig

%build
cd %sname

%add_optflags %optflags_shared
%add_findprov_lib_path %palemoon_prefix
export MOZ_BUILD_APP=browser

# Mozilla builds with -Wall with exception of a few warnings which show up
# everywhere in the code; so, don't override that.
#
# Disable C++ exceptions since Mozilla code is not exception-safe
#
MOZ_OPT_FLAGS=$(echo $RPM_OPT_FLAGS | \
                sed -e 's/-Wall//' -e 's/-fexceptions/-fno-exceptions/g')

export CFLAGS="$MOZ_OPT_FLAGS"
export CXXFLAGS="$MOZ_OPT_FLAGS -Wmaybe-uninitialized -Wreorder -D_GNUC_"

# Add fake RPATH
#export LDFLAGS="-Wl,-rpath,%palemoon_prefix"
#export LD_LIBRARY_PATH="-Wl,-rpath,%palemoon_prefix"
rpath="/$(printf %%s '%palemoon_prefix' |tr '[:print:]' '_')"
export LDFLAGS="$LDFLAGS -Wl,-rpath,$rpath"

# for  palemoon_rpath-27.0.2.patch
export RPATH_PATH="$rpath"

#make -f client.mk build STRIP="/bin/true" MOZ_MAKE_FLAGS="$MOZ_SMP_FLAGS"

export PREFIX="%prefix"
export LIBDIR="%_libdir"
export LIBIDL_CONFIG=%_bindir/libIDL-config-2
export srcdir="$PWD"
export SHELL=/bin/sh

%__autoconf
# On x86 architectures, Mozilla can build up to 4 jobs at once in parallel,
# however builds tend to fail on other arches when building in parallel.
MOZ_SMP_FLAGS=-j1
%ifarch %ix86 x86_64
[ "%__nprocs" -ge 2 ] && MOZ_SMP_FLAGS=-j2
[ "%__nprocs" -ge 4 ] && MOZ_SMP_FLAGS=-j4
%endif


make -f client.mk \
	MAKENSISU= \
	STRIP="/bin/true" \
	MOZ_MAKE_FLAGS="$MOZ_SMP_FLAGS" \
	mozappdir=%buildroot/%palemoon_prefix \
	clobber

make -f client.mk \
	MAKENSISU= \
	STRIP="/bin/true" \
	MOZ_MAKE_FLAGS="$MOZ_SMP_FLAGS" \
	mozappdir=%buildroot/%palemoon_prefix \
	build

#	MOZ_APP_VERSION="" \

gcc %optflags \
	-Wall -Wextra \
	-DMOZ_PLUGIN_PATH=\"%browser_plugins_path\" \
	-DMOZ_PROGRAM=\"%palemoon_bindir/%sname-bin\" \
	%SOURCE7 -o %sname



%install
#set_verify_elf_method unresolved=strict


cd %sname
mkdir -p \
	%buildroot/%mozilla_arch_extdir/%palemoon_cid \
	%buildroot/%mozilla_noarch_extdir/%palemoon_cid \
	#


install -D -m644 %SOURCE13 objdir/dist/bin/defaults/pref/kde.js
install -D -m644 %SOURCE12 objdir/dist/bin/browser/defaults/profile/xulstore.json

pushd objdir
%makeinstall_std MOZ_APP_VERSION=
popd

# icons
for s in 16 32 48; do
	install -D -m 644 \
		../defaults-newmoon/default$s.png \
		%buildroot/%_iconsdir/hicolor/${s}x${s}/apps/%bname.png
done

if [ -f %buildroot/%_bindir/%sname ];then
    rm  -f %buildroot/%_bindir/%sname
fi

install  %sname  %buildroot/%_bindir/%sname

#mv -f %buildroot%palemoon_prefix-%version %buildroot%palemoon_prefix

#cp  %buildroot/%palemoon_prefix/%name-bin  %buildroot%_bindir/%name

# install rpm-build-%sname
mkdir -p -- \
	%buildroot/%_rpmmacrosdir
sed \
	-e 's,@palemoon_version@,%version,' \
	-e 's,@palemoon_release@,%release,' \
	rpm-build/rpm.macros.%sname.standalone > %buildroot/%_rpmmacrosdir/%sname

pushd %buildroot

# Remove devel files
rm -rf -- \
	%buildroot%_includedir/%sname-%version \
	%buildroot%_datadir/idl/%sname-%version \
	%buildroot%_libdir/%sname-devel-%version \
	%buildroot%_libdir/%sname-devel- \

install -d %buildroot%palemoon_prefix
mv -f %buildroot/%_libdir/%sname/* %buildroot%palemoon_prefix


# install altlinux-specific configuration
install -D -m 644 %SOURCE8 %buildroot/%palemoon_prefix/browser/defaults/preferences/all-altlinux.js

mv -f %buildroot%palemoon_prefix/application.ini %buildroot%palemoon_prefix/browser/application.ini

cat > %buildroot/%palemoon_prefix/browser/defaults/preferences/%sname-l10n.js <<EOF
pref("intl.locale.matchOS",		true);
pref("general.useragent.locale",	"chrome://global/locale/intl.properties");
pref("extensions.getAddons.cache.enabled", false);
EOF

#install -D -m644 browser/app/profile/prefs.js %buildroot%palemoon_datadir/browser/defaults/profile/prefs.js

cat << EOF >> %buildroot%palemoon_datadir/browser/defaults/profile/prefs.js
user_pref("browser.EULA.override", true);
user_pref("browser.ctrlTab.previews", true);
user_pref("browser.tabs.insertRelatedAfterCurrent", false);
user_pref("browser.tabs.onTop", true);
user_pref("browser.startup.homepage", "file://%_docdir/HTML/index.html");
user_pref("browser.backspace_action", 2);
user_pref("browser.display.use_system_colors", true);
user_pref("browser.download.folderList", 1);
user_pref("browser.link.open_external", 3);
user_pref("app.update.auto", false);
user_pref("app.update.enabled", false);
user_pref("app.update.autoInstallEnabled", false);
user_pref("dom.ipc.plugins.enabled.nswrapper*", false);
user_pref("extensions.autoDisableScopes", 0);
user_pref("extensions.shownSelectionUI", true);
user_pref("network.manage-offline-status", true);
EOF

# install menu file
install -D -m 644 %SOURCE6 ./%_desktopdir/%bname.desktop

# Add alternatives
mkdir -p ./%_altdir
printf '%_bindir/xbrowser\t%_bindir/%bname\t100\n' >./%_altdir/%bname

install -d  %buildroot%palemoon_bindir/components/
install -d  %buildroot%palemoon_bindir/browser/components/

install -m 644 %buildroot%palemoon_prefix/components/* %buildroot%palemoon_bindir/components/
install -m 644 %buildroot%palemoon_prefix/browser/components/* %buildroot%palemoon_bindir/browser/components/

rm -f %buildroot%palemoon_prefix/components/*
rmdir  %buildroot%palemoon_prefix/components/

rm -f %buildroot%palemoon_prefix/browser/components/*
rmdir %buildroot%palemoon_prefix/browser/components/

mv %buildroot/%palemoon_prefix/{palemoon,palemoon-bin,plugin-container,run-mozilla.sh} %buildroot%palemoon_bindir/
mv %buildroot/%palemoon_prefix/*.so* %buildroot%palemoon_bindir/
mv %buildroot/%palemoon_prefix/*.manifest %buildroot%palemoon_bindir/

install -d %buildroot%palemoon_bindir/
mv %buildroot/%palemoon_prefix/chrome/ %buildroot%palemoon_bindir/
install -d %buildroot%palemoon_prefix/chrome/

install -d %buildroot%palemoon_bindir/browser
mv %buildroot/%palemoon_prefix/browser/chrome/ %buildroot%palemoon_bindir/browser

install -d %buildroot%palemoon_prefix/browser/chrome/

mv %buildroot/%palemoon_prefix/*.chk %buildroot%palemoon_bindir/

ln -s %palemoon_prefix/{defaults,dictionaries,hyphenation,modules,res} %buildroot/%palemoon_bindir/
ln -s %palemoon_prefix/{dependentlibs.list,platform.ini,goanna.js} %buildroot/%palemoon_bindir/
ln -s %palemoon_prefix/browser/{application.ini,blocklist.xml,chrome.manifest,defaults,extensions,icons,modules,searchplugins} %buildroot/%palemoon_bindir/browser/

rm -f -- \
	./%palemoon_prefix/%bname \
	./%palemoon_prefix/removed-files

# Add real RPATH
(set +x
	rpath="/$(printf %%s '%palemoon_bindir' |tr '[:print:]' '_')"

	find \
		%buildroot/%palemoon_bindir \
	-type f |
	while read f; do
		t="$(readlink -ev "$f")"

		file "$t" | fgrep -qs ELF || continue

		if chrpath -l "$t" | fgrep -qs "PATH=$rpath"; then
			chrpath -r "%palemoon_bindir" "$t"
		fi
	done
    )
popd

install -m 644 ../defaults-newmoon/default48.png %buildroot%palemoon_bindir/browser/chrome/icons/default/PMaboutDialog48.png

# Add Docdir
install -D -m 644 %SOURCE9 ../
install -D -m 644 %SOURCE10 ../
install -D -m 644 AUTHORS ../
install -D -m 644 LICENSE ../
install -D -m 644 README.md ../

%post -n %bname-base
 for n in libfreeblpriv3.chk libnssdbm3.chk libsoftokn3.chk; do
  	[  -e "%palemoon_datadir/$n" ] || ln -fs  %palemoon_bindir/$n %palemoon_datadir/$n
 done

 for n in browser.jar chrome.manifest en-US.jar; do
  	[  -e "%palemoon_datadir/browser/chrome/$n" ] || ln -fs  %palemoon_bindir/browser/chrome/$n %palemoon_datadir/browser/chrome/$n
 done

 for n in chrome.manifest en-US.jar marionette.jar pippki.jar recording.jar toolkit.jar; do
  	[  -e "%palemoon_datadir/chrome/$n" ] || ln -fs  %palemoon_bindir/chrome/$n %palemoon_datadir/chrome/$n
 done

%postun -n %bname-base
 for n in libfreeblpriv3.chk libnssdbm3.chk libsoftokn3.chk; do
 	[ !  -L "%palemoon_datadir/$n" ] || rm -f  %palemoon_datadir/$n
 done

 for n in browser.jar chrome.manifest en-US.jar; do
 	[ ! -L "%palemoon_datadir/browser/chrome/$n" ] || rm -f %palemoon_datadir/browser/chrome/$n
 done

 for n in chrome.manifest en-US.jar marionette.jar pippki.jar recording.jar toolkit.jar; do
 	[ ! -L "%palemoon_datadir/chrome/$n" ] || rm -f %palemoon_datadir/chrome/$n
 done

%files -n %bname-data
%dir %palemoon_prefix
%palemoon_prefix/
%dir %palemoon_prefix/browser
%palemoon_prefix/browser/*
%dir %palemoon_prefix/chrome
%dir %palemoon_prefix/defaults
%palemoon_prefix/defaults/*
%dir %palemoon_prefix/dictionaries
%palemoon_prefix/dictionaries/*
%dir %palemoon_prefix/hyphenation
%palemoon_prefix/hyphenation/*
%dir %palemoon_prefix/modules
%palemoon_prefix/modules/*
%dir %palemoon_prefix/res
%palemoon_prefix/res/*


%palemoon_prefix/dependentlibs.list
%palemoon_prefix/goanna.js
%palemoon_prefix/platform.ini

%_desktopdir/%bname.desktop
%_miconsdir/%bname.png
%_niconsdir/%bname.png
%_liconsdir/%bname.png

%files -n %bname-base
%doc AUTHORS LICENSE HISTORY_GIT Changelog README.md
%_altdir/%bname
%_bindir/%sname

%dir %palemoon_bindir
%palemoon_bindir/*

%mozilla_arch_extdir/%palemoon_cid
%mozilla_noarch_extdir/%palemoon_cid

%files -n rpm-build-%sname
%_rpmmacrosdir/%sname
%exclude %_includedir/*

%exclude %_datadir/idl/*

# git commit 609b2f53c5bbd98064d5c59c3d772b59b6a076f6
%changelog
