%define partimaged_user _partimaged
%define partimaged_group _partimaged

Summary: Partition Image
Name: partimage
Version: 0.6.9
Release: alt1.2
License: GPL
Group: System/Configuration/Hardware
URL:     http://www.partimage.org/

Packager: Ilya Mashkin <oddity@altlinux.ru>

Source: %name-%version.tar.bz2
Patch1: partimage-0.6.7-autoconf.patch
Patch2:  partimage-0.6.7-gcc43.patch
Patch3:  partimage-0.6.7-gcc44.patch
Patch4: partimage-0.6.9-alt-zlib-1.2.7.patch

Source1: partimaged.pam
Source2: partimaged.init

Obsoletes: partimage = 0.6.5_beta3

Requires: libnewt, dmraid

# Automatically added by buildreq on Tue Feb 19 2008
BuildRequires: bzlib-devel cvs gcc-c++ libnewt-devel libpam-devel libssl-devel openssl zlib-devel

%description
Partition Image is a Linux/UNIX partition imaging utility: it saves all used
blocks in a partition to an image file. 

This allows you to back up a full Linux/Windows system with a single
operation. When problems such as viruses, crashes, or other errors occur, you
just have to restore, and after several minutes your system can be restored
(boot record and all your files) and fully working.

%package server
Summary: partimage server
Group: System/Servers

Obsoletes: partimaged, partimage-partimaged

%description server
Server to store images from partimage accross the network

%prep
%setup -q
#patch0 -p1
#patch1
#patch2 -p1 -b .gcc43
#patch3 -p1 -b .gcc44
%patch4 -p2


sed -i '/^#define PARTIMAGED_USER/ s,"partimag","%{partimaged_user}",' -i src/shared/pathnames.h.in

perl -pi.orig -e 's|^[[:space:]]*chown partimag[\.:]root.*$|\\|' Makefile.am
### FIXME: Fix mkinstalldirs during 'make install' in po/
perl -pi.orig -e 's|^(mkinstalldirs) = .+$|$1 = %__mkdir_p|' po/Makefile.in.in

autoreconf -fisv

%build
%configure --with-log-dir=/var/log --enable-ssl --enable-pam --disable-static 
%make_build

%install
%makeinstall
install -d %buildroot%_spooldir/partimaged 
install -D -m 644 %SOURCE1  %buildroot/%_sysconfdir/pam.d/partimaged
install -D -m 755 %SOURCE2  %buildroot/%_initdir/partimaged
%find_lang %name

%pre server
%_sbindir/groupadd -r -f %partimaged_group 2>/dev/null ||:
%_sbindir/useradd -g %partimaged_group -c 'Partimage server' -d %_spooldir/partimaged -s '' \
        -r %partimaged_user 2>/dev/null || :

%post server
%post_service partimaged

%preun server
%preun_service partimaged

%files -f %name.lang
%doc AUTHORS BUGS  ChangeLog COPYING README README.partimaged
%_sbindir/partimage

%files server
%doc AUTHORS BUGS  ChangeLog COPYING README README.partimaged
%_sbindir/partimaged
%_initdir/partimaged
%dir %_sysconfdir/partimaged
%config(noreplace) %_sysconfdir/partimaged/*
%config(noreplace) %_sysconfdir/pam.d/partimaged
%attr(700,%partimaged_user,%partimaged_group)%_spooldir/partimaged

%changelog
