# This spec is backported to ALTLinux p7 automatically by rpmbph script. Do not edit it.
#
#undefine XXX__libtoolize
#define unstable 1
%def_disable static

Name: pcsc-lite
Version: 1.8.18
Release: alt1.M70P.2

Summary: PC/SC Lite smart card framework and applications
License: %bsd
Group: System/Servers

Url: http://pcsclite.alioth.debian.org/

Source: %name-%version.tar
Patch: %name-%version-%release.patch

Source1: pcscd.init
Source2: pcsc-lite-pcscd.sysconfig
Source3: pcsc-lite.tmpfiles

Requires: libpcsclite = %version-%release
Requires: polkit

BuildRequires: rpm-build-licenses perl-podlators
BuildRequires: flex
BuildRequires: pkgconfig(polkit-gobject-1) >= 0.111
BuildRequires: pkgconfig(libudev)
BuildRequires: pkgconfig(systemd)

%if_enabled static
BuildRequires: glibc-devel-static
%endif

%description
pcscd is the daemon program for PC/SC Lite. It is a resource
manager that coorinates communications with Smart Card readers and Smart
Cards that are connected to the system.
The purpose of PCSC Lite is to provide a Windows(R) SCard interface
in a very small form factor for communicating to smartcards and readers.
PCSC Lite uses the same winscard api as used under Windows(R)

This package contains the service for PC/SC Lite.

%package -n libpcsclite
Group: System/Libraries
Summary: Libraries for pcscd
#
%description -n libpcsclite
Libraries for pcscd. pcscd is the daemon program
for PC/SC Lite. It is a resource manager that coorinates
communications with Smart Card readers and Smart Cards
that are connected to the system. The purpose of PCSC Lite
is to provide a Windows(R) SCard interface in a very small
form factor for communicating to smartcards and readers.
PCSC Lite uses the same winscard api as used under Windows(R)

%package -n libpcsclite-devel
Group: Development/C
Summary: Haeders and other development files for libpcsclite
Requires: libpcsclite = %version-%release
#
%description -n libpcsclite-devel
Haeders and other development files for libpcsclite

%package -n libpcsclite-devel-static
Group: Development/C
Summary: Static libraries for libpcsclite
Requires: libpcsclite-devel = %version-%release
#
%description -n libpcsclite-devel-static
Static libraries for libpcsclite

%prep
%setup
%patch -p1

subst 's|AC_PREREQ(\[2.69\])|AC_PREREQ(\[2.68\])|' configure.ac

%build
%autoreconf
%configure \
    %{subst_enable static} \
    --enable-debugatr \
    --enable-ipcdir=/var/run/pcscd \
    --enable-usbdropdir=%_libdir/pcsc/drivers \
    --enable-polkit \
    --with-systemdsystemunitdir=%_unitdir

%make_build

# pdf
%make_build -C doc

%install
%makeinstall_std

install -pDm755 %SOURCE1 %buildroot/%_initdir/pcscd
install -pDm644 %SOURCE2 %buildroot/%_sysconfdir/sysconfig/pcscd

mkdir -p %buildroot%_sysconfdir/reader.conf.d
mkdir -p %buildroot/var/run/pcscd
mkdir -p %buildroot%_libdir/pcsc/drivers

# enable pcscd socket activation
mkdir -p %buildroot%_unitdir/sockets.target.wants
ln -s ../pcscd.socket %buildroot%_unitdir/sockets.target.wants
mkdir -p %buildroot/lib/tmpfiles.d
install -pDm644 %SOURCE3 %buildroot/lib/tmpfiles.d/pcsc-lite.conf

%preun
%preun_service pcscd

%post
%post_service pcscd

%files
%doc AUTHORS COPYING DRIVERS HELP NEWS README SECURITY TODO doc/README.DAEMON doc/README.polkit
%dir %_sysconfdir/reader.conf.d
%config(noreplace) %_sysconfdir/sysconfig/pcscd
%_initdir/pcscd
%_unitdir/pcscd.*
%_unitdir/sockets.target.wants/*
/lib/tmpfiles.d/pcsc-lite.conf
%_sbindir/pcscd
#_bindir/make_hash_link.sh
%_man5dir/*
%_man8dir/*
%dir %_libdir/pcsc
%dir %_libdir/pcsc/drivers
%_datadir/polkit-1/actions/*.policy
%ghost %dir /var/run/pcscd

# NB: .so belongs here, see ALT#25275
%files -n libpcsclite
%_libdir/libpcsclite.so.*
%_libdir/libpcsclite.so

%files -n libpcsclite-devel
%doc ChangeLog
%_bindir/pcsc-spy
%_libdir/libpcscspy.so*
%_includedir/PCSC/
%_libdir/pkgconfig/libpcsclite.pc
%_man1dir/pcsc-spy.*

%if_enabled static
%files -n libpcsclite-devel-static
%_libdir/libpcsclite.a
%endif

%changelog
