# BEGIN SourceDeps(oneline):
BuildRequires: unzip
# END SourceDeps(oneline)
BuildRequires: gcc-c++
BuildRequires: /proc
BuildRequires: jpackage-compat
%global itextvers 2.1.7

Summary:        The PDF Tool Kit
Name:           pdftk
Version:        1.44
Release:        alt2_10jpp7
License:        GPLv2+
URL:            http://www.pdflabs.com/tools/pdftk-the-pdf-toolkit/
Source0:        http://www.pdflabs.com/tools/pdftk-the-pdf-toolkit/%{name}-%{version}-src.zip
Patch0:         pdftk-use-internal-itext.patch
# Solves ".afm files not found" error. RHBZ#494785:
Patch1:         pdftk-classpath.patch
Patch2:         pdftk-1.44-gcjfix.patch
Group:          Publishing
# Solves #712013 wjocj requires gcc 4.7.0-2 as minimum
BuildRequires:  gcc-java >= 4.7.0-2
BuildRequires:  libgcj-devel >= 4.7.0-2

BuildRequires:  itext >= %{itextvers}

Requires:       itext%{?_isa} >= 2.1.7-6

%{echo 
%filter_from_requires /\.jar\.so/d

}
Source44: import.info

%description
If PDF is electronic paper, then pdftk is an electronic staple-remover,
hole-punch, binder, secret-decoder-ring, and X-Ray-glasses. Pdftk is a simple
tool for doing everyday things with PDF documents. Keep one in the top drawer
of your desktop and use it to:

   * Merge PDF Documents
   * Split PDF Pages into a New Document
   * Decrypt Input as Necessary (Password Required)
   * Encrypt Output as Desired
   * Burst a PDF Document into Single Pages
   * Report on PDF Metrics, including Metadata and Bookmarks
   * Uncompress and Re-Compress Page Streams
   * Repair Corrupted PDF (Where Possible)

Pdftk is also an example of how to use a library of Java classes in a
stand-alone C++ program. Specifically, it demonstrates how GCJ and CNI allow
C++ code to use iText's (itext-paulo) Java classes.

%prep
%setup -q -n %{name}-%{version}-dist
%patch0 -p1
%patch1 -p0 -b .classpath
%patch2 -p1 -b .gcjfix

# Remove bundled libraries from the source tree
rm -rf java

# Fix EOL encoding
for file in *.txt license_gpl_pdftk//*.txt; do
    sed 's|\r||' $file > $file.tmp
    touch -r $file $file.tmp
    mv $file.tmp $file
done

%build
# Requires as a workaround for gcc BZ #39380
export CFLAGS="${RPM_OPT_FLAGS}"
jar tf %{_javadir}/itext-%{itextvers}.jar | grep '\.class$' | sed 's/\.class//' | sed 's|/|\.|g' > classes
    gjavah -d java -cni -classpath=%{_javadir}/itext-%{itextvers}.jar \
       `cat classes`
    cd pdftk
    make -f Makefile.Redhat LIBDIR=%{_libdir} %{?_smp_mflags} ITEXTVERS="%{itextvers}" 

%install
mkdir -p $RPM_BUILD_ROOT/%{_bindir}
mkdir -p $RPM_BUILD_ROOT/%{_mandir}/man1
install -m 0755 pdftk/pdftk $RPM_BUILD_ROOT/%{_bindir}/pdftk
install -m 0644 pdftk.1 $RPM_BUILD_ROOT/%{_mandir}/man1/pdftk.1

%files
%doc changelog.html changelog.notes changelog.txt
%doc pdftk.1.html pdftk.1.notes pdftk.1.txt
%doc license_gpl_pdftk/pdftk_gpl_license.txt license_gpl_pdftk/readme.txt
%{_bindir}/%{name}
%{_mandir}/man1/%{name}*

%changelog
