%define dist DBI
Name: perl-%dist
Version: 1.622
Release: alt1

Summary: Database independent interface for Perl
License: GPL or Artistic
Group: Development/Perl

URL: %CPAN %dist
Source: %dist-%version.tar
Patch: %name-%version-%release.patch

# requires Apache; not required by any package
%add_findreq_skiplist */DBI/ProfileDumper/Apache.pm
# requires Coro::Select
%add_findreq_skiplist */DBD/Gofer/Transport/corostream.pm

# Automatically added by buildreq on Fri Oct 07 2011
BuildRequires: perl-Devel-Leak perl-JSON-XS perl-List-MoreUtils perl-MLDBM perl-PlRPC perl-SQL-Statement perl-Test-Pod perl-Test-Pod-Coverage

%description
The DBI is a database access module for the Perl programming language.
It defines a set of methods, variables, and conventions that provide
a consistent database interface, independent of the actual database
being used.

# required to build binary DBI drivers
%package devel
Summary: DBI development files
Group: Development/Perl
Requires: %name = %version-%release

%description devel
This package contains DBI header files and additional modules
required to build DBI binary drivers.

# profiler
%package Profile
Summary: Performance profiling and benchmarking for the DBI
Group: Development/Perl
Requires: %name = %version-%release

%description Profile
The DBI::Profile module provides a simple interface to collect
and report performance and benchmarking data from the DBI.
DBI::ProfileDumper is a subclass of DBI::Profile which dumps
profile data to disk instead of printing a summary to your screen.
You can then use %_bindir/dbiprof to analyze the data in a number
of interesting ways, or you can roll your own analysis using
DBI::ProfileData.

# requires MLDBM
%package -n perl-DBD-DBM
Summary: DBI driver for DBM and MLDBM files
Group: Development/Perl
Requires: perl-DBD-File = %version-%release

%description -n perl-DBD-DBM
DBD::DBM is a database management sytem that can work right out
of the box.  The module uses a DBM file storage layer.  DBM file
storage is common on many platforms and files can be created with
it in many languges.

# required by perl-DBD-DBM, DBD::AnyData, and DBD::CSV
%package -n perl-DBD-File
Summary: Base class for writing DBI drivers
Group: Development/Perl
Requires: %name = %version-%release
Requires: perl(SQL/Statement.pm) >= 1.280
Conflicts: perl(DBD/CSV.pm) <= 0.290

%description -n perl-DBD-File
DBD::File module is a base class for writing DBI drivers
that work with plain files, for example CSV files.

# requires PlRPC
%package -n perl-DBD-Proxy
Summary: A proxy driver for the DBI
Group: Development/Perl
Requires: %name = %version-%release

%description -n perl-DBD-Proxy
DBD::Proxy is a Perl module for connecting to a database
via a remote DBI driver.

# requires PlRPC
%package ProxyServer
Summary: A server for the DBD::Proxy driver
Group: Development/Perl
Requires: %name = %version-%release

%description ProxyServer
DBI::ProxyServer is a module for implementing a proxy
for the DBI proxy driver, DBD::Proxy. It allows access
to databases over the network.

# Gofer is "next big thing"
%package Gofer
Summary: DBI::Gofer proxy server classes
Group: Development/Perl
Requires: %name = %version-%release

%description Gofer
DBI::Gofer::Execute accepts remote DBI::Gofer::Request object,
executes the requested DBI method calls, and returns
a DBI::Gofer::Response object.

%package -n perl-DBD-Gofer
Summary: A stateless-proxy driver for communicating with a remote DBI
Group: Development/Perl
Requires: %name-Gofer = %version-%release

%description -n perl-DBD-Gofer
DBD::Gofer is a DBI database driver that forwards requests to another
DBI driver, usually in a seperate process, often on a separate machine.
It tries to be as transparent as possible so it appears that you are
using the remote driver directly.

%prep
%setup -q -n %dist-%version
%patch -p1

%build
%perl_vendor_build

rm blib/lib/DBI/PurePerl.pm
rm blib/lib/DBI/W32ODBC.pm
rm blib/lib/Win32/DBIODBC.pm
rm blib/lib/Bundle/DBI.pm
rm blib/lib/dbixs_rev.pl
mv blib/lib/DBI/FAQ.{pm,pod}

%install
%perl_vendor_install

%files
	%perl_vendor_archlib/DBI.pm
%dir	%perl_vendor_archlib/DBD
	%perl_vendor_archlib/DBD/Sponge.pm
%dir	%perl_vendor_autolib/DBI
	%perl_vendor_autolib/DBI/DBI.so
%dir	%perl_vendor_archlib/DBI
%dir	%perl_vendor_archlib/DBI/Const
	%perl_vendor_archlib/DBI/Const/GetInfo*
%dir	%perl_vendor_archlib/DBI/Util
	%perl_vendor_archlib/DBI/Util/*.pm
%doc	%perl_vendor_archlib/DBI/Changes.pod
%doc	%perl_vendor_archlib/DBI/FAQ.pod

%files devel
	%_bindir/dbilogstrip
%dir	%perl_vendor_archlib/DBI
%dir	%perl_vendor_archlib/DBI/DBD
	%perl_vendor_archlib/DBI/DBD.pm
	%perl_vendor_archlib/DBI/DBD/Metadata.pm
%dir	%perl_vendor_autolib/DBI
	%perl_vendor_autolib/DBI/*.h
	%perl_vendor_autolib/DBI/Driver.xst
# extras
%dir	%perl_vendor_archlib/DBD
	%perl_vendor_archlib/DBD/ExampleP.pm
	%perl_vendor_archlib/DBD/NullP.pm

%files Profile
	%_bindir/dbiprof
%dir	%perl_vendor_archlib/DBI
	%perl_vendor_archlib/DBI/Profile*

%files -n perl-DBD-DBM
%dir	%perl_vendor_archlib/DBD
	%perl_vendor_archlib/DBD/DBM.pm

%files -n perl-DBD-File
%dir	%perl_vendor_archlib/DBD
	%perl_vendor_archlib/DBD/File.pm
%dir	%perl_vendor_archlib/DBD/File
%doc	%perl_vendor_archlib/DBD/File/*.pod
%dir	%perl_vendor_archlib/DBI/SQL
	%perl_vendor_archlib/DBI/SQL/Nano.pm
%dir	%perl_vendor_archlib/DBI/DBD
	%perl_vendor_archlib/DBI/DBD/SqlEngine.pm
%dir	%perl_vendor_archlib/DBI/DBD/SqlEngine
	%perl_vendor_archlib/DBI/DBD/SqlEngine/*.pod

%files -n perl-DBD-Proxy
%dir	%perl_vendor_archlib/DBD
	%perl_vendor_archlib/DBD/Proxy.pm

%files ProxyServer
	%_bindir/dbiproxy
%dir	%perl_vendor_archlib/DBI
	%perl_vendor_archlib/DBI/ProxyServer.pm

%files Gofer
%dir	%perl_vendor_archlib/DBI
	%perl_vendor_archlib/DBI/Gofer*

%files -n perl-DBD-Gofer
%dir	%perl_vendor_archlib/DBD
	%perl_vendor_archlib/DBD/Gofer*

%changelog
